/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.fafquery;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.CombinationEnumeration;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValue;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueEquals;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValueRange;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexLookup;
import com.espertech.esper.epl.join.exec.composite.CompositeIndexLookupFactory;
import com.espertech.esper.epl.join.hint.IndexHint;
import com.espertech.esper.epl.join.hint.IndexHintInstruction;
import com.espertech.esper.epl.join.plan.QueryGraphRangeConsolidateDesc;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphRangeUtil;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableAndNamePair;
import com.espertech.esper.epl.join.table.PropertyCompositeEventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTable;
import com.espertech.esper.epl.join.table.PropertyIndexedEventTableSingle;
import com.espertech.esper.epl.join.table.PropertySortedEventTable;
import com.espertech.esper.epl.join.util.IndexNameAndDescPair;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescFAF;
import com.espertech.esper.epl.join.util.QueryPlanIndexHook;
import com.espertech.esper.epl.join.util.QueryPlanIndexHookUtil;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterSpecParamConstant;
import com.espertech.esper.filter.FilterSpecParamIn;
import com.espertech.esper.filter.FilterSpecParamRange;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class FireAndForgetQueryExec {
    public static Collection<EventBean> snapshot(FilterSpecCompiled optionalFilter, Annotation[] annotations, VirtualDWView virtualDataWindow, EventTableIndexRepository indexRepository, boolean queryPlanLogging, Log queryPlanLogDestination, String objectName, AgentInstanceContext agentInstanceContext) {
        Pair<IndexMultiKey, EventTableAndNamePair> tablePair;
        if (optionalFilter == null || optionalFilter.getParameters().length == 0) {
            if (virtualDataWindow != null) {
                Pair<IndexMultiKey, EventTable> pair = virtualDataWindow.getFireAndForgetDesc(Collections.<String>emptySet(), Collections.<String>emptySet());
                return virtualDataWindow.getFireAndForgetData(pair.getSecond(), new Object[0], new RangeIndexLookupValue[0], annotations);
            }
            return null;
        }
        HashSet<String> keysAvailable = new HashSet<String>();
        HashSet<String> rangesAvailable = new HashSet<String>();
        if (optionalFilter.getParameters().length == 1) {
            for (FilterSpecParam param : optionalFilter.getParameters()[0]) {
                if (!(param instanceof FilterSpecParamConstant) && !(param instanceof FilterSpecParamRange) && !(param instanceof FilterSpecParamIn)) continue;
                if (param.getFilterOperator() == FilterOperator.EQUAL || param.getFilterOperator() == FilterOperator.IS || param.getFilterOperator() == FilterOperator.IN_LIST_OF_VALUES) {
                    keysAvailable.add(param.getLookupable().getExpression());
                    continue;
                }
                if (param.getFilterOperator().isRangeOperator() || param.getFilterOperator().isInvertedRangeOperator() || param.getFilterOperator().isComparisonOperator()) {
                    rangesAvailable.add(param.getLookupable().getExpression());
                    continue;
                }
                if (!param.getFilterOperator().isRangeOperator()) continue;
                rangesAvailable.add(param.getLookupable().getExpression());
            }
        }
        if (virtualDataWindow != null) {
            Pair<IndexMultiKey, EventTable> tablePairNoName = virtualDataWindow.getFireAndForgetDesc(keysAvailable, rangesAvailable);
            tablePair = new Pair<IndexMultiKey, EventTableAndNamePair>(tablePairNoName.getFirst(), new EventTableAndNamePair(tablePairNoName.getSecond(), null));
        } else {
            IndexHint indexHint = IndexHint.getIndexHint(annotations);
            List<IndexHintInstruction> optionalIndexHintInstructions = null;
            if (indexHint != null) {
                optionalIndexHintInstructions = indexHint.getInstructionsFireAndForget();
            }
            tablePair = indexRepository.findTable(keysAvailable, rangesAvailable, optionalIndexHintInstructions);
        }
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(annotations);
        if (queryPlanLogging && (queryPlanLogDestination.isInfoEnabled() || hook != null)) {
            String prefix = "Fire-and-forget from " + objectName + " ";
            String indexName = tablePair != null && tablePair.getSecond() != null ? tablePair.getSecond().getIndexName() : null;
            String indexText = indexName != null ? "index " + indexName + " " : "full table scan ";
            indexText = indexText + "(snapshot only, for join see separate query plan)";
            if (tablePair == null) {
                queryPlanLogDestination.info((Object)(prefix + indexText));
            } else {
                queryPlanLogDestination.info((Object)(prefix + indexText + tablePair.getSecond().getEventTable().toQueryPlan()));
            }
            if (hook != null) {
                hook.fireAndForget(new QueryPlanIndexDescFAF(new IndexNameAndDescPair[]{new IndexNameAndDescPair(indexName, tablePair != null ? tablePair.getSecond().getEventTable().getProviderClass().getSimpleName() : null)}));
            }
        }
        if (tablePair == null) {
            return null;
        }
        String[] keyIndexProps = IndexedPropDesc.getIndexProperties(tablePair.getFirst().getHashIndexedProps());
        boolean hasKeyWithInClause = false;
        Object[] keyValues = new Object[keyIndexProps.length];
        block1: for (int keyIndex = 0; keyIndex < keyIndexProps.length; ++keyIndex) {
            for (FilterSpecParam param : optionalFilter.getParameters()[0]) {
                if (!param.getLookupable().getExpression().equals(keyIndexProps[keyIndex])) continue;
                if (param.getFilterOperator() == FilterOperator.IN_LIST_OF_VALUES) {
                    Object[] keyValuesList = ((MultiKeyUntyped)param.getFilterValue(null, agentInstanceContext)).getKeys();
                    if (keyValuesList.length == 0) continue;
                    if (keyValuesList.length == 1) {
                        keyValues[keyIndex] = keyValuesList[0];
                        continue block1;
                    }
                    keyValues[keyIndex] = keyValuesList;
                    hasKeyWithInClause = true;
                    continue block1;
                }
                keyValues[keyIndex] = param.getFilterValue(null, agentInstanceContext);
                continue block1;
            }
        }
        String[] rangeIndexProps = IndexedPropDesc.getIndexProperties(tablePair.getFirst().getRangeIndexedProps());
        RangeIndexLookupValue[] rangeValues = rangeIndexProps.length > 0 ? FireAndForgetQueryExec.compileRangeLookupValues(rangeIndexProps, optionalFilter.getParameters()[0], agentInstanceContext) : new RangeIndexLookupValue[]{};
        EventTable eventTable = tablePair.getSecond().getEventTable();
        IndexMultiKey indexMultiKey = tablePair.getFirst();
        if (!hasKeyWithInClause) {
            return FireAndForgetQueryExec.fafTableLookup(virtualDataWindow, indexMultiKey, eventTable, keyValues, rangeValues, annotations);
        }
        Object[][] combinations = new Object[keyIndexProps.length][];
        for (int i = 0; i < keyValues.length; ++i) {
            combinations[i] = keyValues[i] instanceof Object[] ? (Object[])keyValues[i] : new Object[]{keyValues[i]};
        }
        CombinationEnumeration enumeration = new CombinationEnumeration(combinations);
        HashSet<EventBean> events = new HashSet<EventBean>();
        while (enumeration.hasMoreElements()) {
            Object[] keys = enumeration.nextElement();
            Collection<EventBean> result = FireAndForgetQueryExec.fafTableLookup(virtualDataWindow, indexMultiKey, eventTable, keys, rangeValues, annotations);
            events.addAll(result);
        }
        return events;
    }

    private static Collection<EventBean> fafTableLookup(VirtualDWView virtualDataWindow, IndexMultiKey indexMultiKey, EventTable eventTable, Object[] keyValues, RangeIndexLookupValue[] rangeValues, Annotation[] annotations) {
        Set<EventBean> result;
        if (virtualDataWindow != null) {
            return virtualDataWindow.getFireAndForgetData(eventTable, keyValues, rangeValues, annotations);
        }
        if (indexMultiKey.getHashIndexedProps().length > 0 && indexMultiKey.getRangeIndexedProps().length == 0) {
            if (indexMultiKey.getHashIndexedProps().length == 1) {
                PropertyIndexedEventTableSingle table = (PropertyIndexedEventTableSingle)eventTable;
                result = table.lookup(keyValues[0]);
            } else {
                PropertyIndexedEventTable table = (PropertyIndexedEventTable)eventTable;
                result = table.lookup(keyValues);
            }
        } else if (indexMultiKey.getHashIndexedProps().length == 0 && indexMultiKey.getRangeIndexedProps().length == 1) {
            PropertySortedEventTable table = (PropertySortedEventTable)eventTable;
            result = table.lookupConstants(rangeValues[0]);
        } else {
            PropertyCompositeEventTable table = (PropertyCompositeEventTable)eventTable;
            Class[] rangeCoercion = table.getOptRangeCoercedTypes();
            CompositeIndexLookup lookup = CompositeIndexLookupFactory.make(keyValues, rangeValues, rangeCoercion);
            result = new HashSet<EventBean>();
            lookup.lookup((Map)table.getIndex(), result, table.getPostProcessor());
        }
        if (result != null) {
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private static RangeIndexLookupValue[] compileRangeLookupValues(String[] rangeIndexProps, FilterSpecParam[] parameters, AgentInstanceContext agentInstanceContext) {
        RangeIndexLookupValue[] result = new RangeIndexLookupValue[rangeIndexProps.length];
        for (int rangeIndex = 0; rangeIndex < rangeIndexProps.length; ++rangeIndex) {
            for (FilterSpecParam param : parameters) {
                RangeIndexLookupValueRange existingRange;
                QueryGraphRangeEnum opExist;
                QueryGraphRangeConsolidateDesc desc;
                if (!param.getLookupable().getExpression().equals(rangeIndexProps[rangeIndex])) continue;
                if (param.getFilterOperator() == FilterOperator.EQUAL || param.getFilterOperator() == FilterOperator.IS) {
                    result[rangeIndex] = new RangeIndexLookupValueEquals(param.getFilterValue(null, agentInstanceContext));
                    continue;
                }
                if (param.getFilterOperator().isRangeOperator() || param.getFilterOperator().isInvertedRangeOperator()) {
                    QueryGraphRangeEnum opAdd = QueryGraphRangeEnum.mapFrom(param.getFilterOperator());
                    result[rangeIndex] = new RangeIndexLookupValueRange(param.getFilterValue(null, agentInstanceContext), opAdd, true);
                    continue;
                }
                if (!param.getFilterOperator().isComparisonOperator()) continue;
                RangeIndexLookupValue existing = result[rangeIndex];
                QueryGraphRangeEnum opAdd = QueryGraphRangeEnum.mapFrom(param.getFilterOperator());
                if (existing == null) {
                    result[rangeIndex] = new RangeIndexLookupValueRange(param.getFilterValue(null, agentInstanceContext), opAdd, true);
                    continue;
                }
                if (!(existing instanceof RangeIndexLookupValueRange) || (desc = QueryGraphRangeUtil.getCanConsolidate(opExist = (existingRange = (RangeIndexLookupValueRange)existing).getOperator(), opAdd)) == null) continue;
                DoubleRange doubleRange = FireAndForgetQueryExec.getDoubleRange(desc.isReverse(), existing.getValue(), param.getFilterValue(null, agentInstanceContext));
                result[rangeIndex] = new RangeIndexLookupValueRange(doubleRange, desc.getType(), false);
            }
        }
        return result;
    }

    private static DoubleRange getDoubleRange(boolean reverse, Object start, Object end) {
        if (start == null || end == null) {
            return null;
        }
        double startDbl = ((Number)start).doubleValue();
        double endDbl = ((Number)end).doubleValue();
        if (reverse) {
            return new DoubleRange(startDbl, endDbl);
        }
        return new DoubleRange(endDbl, startDbl);
    }
}

