/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.join.hint.ExcludePlanFilterOperatorType;
import com.espertech.esper.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.epl.join.plan.QueryGraphKey;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphValue;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.type.RelationalOpEnum;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QueryGraph {
    private final int numStreams;
    private final ExcludePlanHint optionalHint;
    private final boolean nToZeroAnalysis;
    private final Map<QueryGraphKey, QueryGraphValue> streamJoinMap;

    public QueryGraph(int numStreams, ExcludePlanHint optionalHint, boolean nToZeroAnalysis) {
        this.numStreams = numStreams;
        this.optionalHint = optionalHint;
        this.nToZeroAnalysis = nToZeroAnalysis;
        this.streamJoinMap = new HashMap<QueryGraphKey, QueryGraphValue>();
    }

    public int getNumStreams() {
        return this.numStreams;
    }

    public boolean addStrictEquals(int streamLeft, String propertyLeft, ExprIdentNode nodeLeft, int streamRight, String propertyRight, ExprIdentNode nodeRight) {
        this.check(streamLeft, streamRight);
        if (propertyLeft == null || propertyRight == null) {
            throw new IllegalArgumentException("Null property names supplied");
        }
        if (streamLeft == streamRight) {
            throw new IllegalArgumentException("Streams supplied are the same");
        }
        boolean addedLeft = this.internalAddEquals(streamLeft, propertyLeft, nodeLeft, streamRight, nodeRight);
        boolean addedRight = this.internalAddEquals(streamRight, propertyRight, nodeRight, streamLeft, nodeLeft);
        return addedLeft || addedRight;
    }

    public boolean isNavigableAtAll(int streamFrom, int streamTo) {
        QueryGraphKey key = new QueryGraphKey(streamFrom, streamTo);
        QueryGraphValue value = this.streamJoinMap.get(key);
        return value != null && !value.isEmptyNotNavigable();
    }

    public Set<Integer> getNavigableStreams(int streamFrom) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < this.numStreams; ++i) {
            if (!this.isNavigableAtAll(streamFrom, i)) continue;
            result.add(i);
        }
        return result;
    }

    public QueryGraphValue getGraphValue(int streamLookup, int streamIndexed) {
        QueryGraphKey key = new QueryGraphKey(streamLookup, streamIndexed);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value != null) {
            return value;
        }
        return new QueryGraphValue();
    }

    public static void fillEquivalentNav(EventType[] typesPerStream, QueryGraph queryGraph) {
        boolean addedEquivalency;
        do {
            addedEquivalency = false;
            for (int lookupStream = 0; lookupStream < queryGraph.numStreams; ++lookupStream) {
                for (int indexedStream = 0; indexedStream < queryGraph.numStreams; ++indexedStream) {
                    boolean added;
                    if (lookupStream == indexedStream || !(added = QueryGraph.fillEquivalentNav(typesPerStream, queryGraph, lookupStream, indexedStream))) continue;
                    addedEquivalency = true;
                }
            }
        } while (addedEquivalency);
    }

    private static boolean fillEquivalentNav(EventType[] typesPerStream, QueryGraph queryGraph, int lookupStream, int indexedStream) {
        boolean addedEquivalency = false;
        QueryGraphValue value = queryGraph.getGraphValue(lookupStream, indexedStream);
        if (value.isEmptyNotNavigable()) {
            return false;
        }
        QueryGraphValuePairHashKeyIndex hashKeys = value.getHashKeyProps();
        String[] strictKeyProps = hashKeys.getStrictKeys();
        String[] indexProps = hashKeys.getIndexed();
        if (strictKeyProps.length == 0) {
            return false;
        }
        if (strictKeyProps.length != indexProps.length) {
            throw new IllegalStateException("Unexpected key and index property number mismatch");
        }
        for (int i = 0; i < strictKeyProps.length; ++i) {
            boolean added;
            if (strictKeyProps[i] == null || !(added = QueryGraph.fillEquivalentNav(typesPerStream, queryGraph, lookupStream, strictKeyProps[i], indexedStream, indexProps[i]))) continue;
            addedEquivalency = true;
        }
        return addedEquivalency;
    }

    private static boolean fillEquivalentNav(EventType[] typesPerStream, QueryGraph queryGraph, int lookupStream, String keyProp, int indexedStream, String indexProp) {
        boolean addedEquivalency = false;
        for (int otherStream = 0; otherStream < queryGraph.numStreams; ++otherStream) {
            ExprIdentNodeImpl identNodeOther;
            ExprIdentNodeImpl identNodeLookup;
            boolean added;
            if (otherStream == lookupStream || otherStream == indexedStream) continue;
            QueryGraphValue value = queryGraph.getGraphValue(otherStream, indexedStream);
            QueryGraphValuePairHashKeyIndex hashKeys = value.getHashKeyProps();
            String[] otherStrictKeyProps = hashKeys.getStrictKeys();
            String[] otherIndexProps = hashKeys.getIndexed();
            int otherPropertyNum = -1;
            if (otherIndexProps == null) continue;
            for (int i = 0; i < otherIndexProps.length; ++i) {
                if (!otherIndexProps[i].equals(indexProp)) continue;
                otherPropertyNum = i;
                break;
            }
            if (otherPropertyNum == -1 || otherStrictKeyProps[otherPropertyNum] == null || !(added = queryGraph.addStrictEquals(lookupStream, keyProp, identNodeLookup = new ExprIdentNodeImpl(typesPerStream[lookupStream], keyProp, lookupStream), otherStream, otherStrictKeyProps[otherPropertyNum], identNodeOther = new ExprIdentNodeImpl(typesPerStream[otherStream], otherStrictKeyProps[otherPropertyNum], otherStream)))) continue;
            addedEquivalency = true;
        }
        return addedEquivalency;
    }

    public String toString() {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        int count = 0;
        for (Map.Entry<QueryGraphKey, QueryGraphValue> entry : this.streamJoinMap.entrySet()) {
            writer.println("Entry " + ++count + ": key=" + entry.getKey());
            writer.println("  value=" + entry.getValue());
        }
        return buf.toString();
    }

    public void addRangeStrict(int streamNumStart, ExprIdentNode propertyStartExpr, int streamNumEnd, ExprIdentNode propertyEndExpr, int streamNumValue, ExprIdentNode propertyValueExpr, boolean includeStart, boolean includeEnd, boolean isInverted) {
        this.check(streamNumStart, streamNumValue);
        this.check(streamNumEnd, streamNumValue);
        if (streamNumStart == streamNumEnd && streamNumStart != streamNumValue) {
            QueryGraphRangeEnum rangeOp = QueryGraphRangeEnum.getRangeOp(includeStart, includeEnd, isInverted);
            this.internalAddRange(streamNumStart, streamNumValue, rangeOp, propertyStartExpr, propertyEndExpr, propertyValueExpr);
            this.internalAddRelOp(streamNumValue, streamNumStart, propertyValueExpr, QueryGraphRangeEnum.GREATER_OR_EQUAL, propertyEndExpr, false);
            this.internalAddRelOp(streamNumValue, streamNumStart, propertyValueExpr, QueryGraphRangeEnum.LESS_OR_EQUAL, propertyStartExpr, false);
        } else {
            if (streamNumValue != streamNumStart) {
                this.internalAddRelOp(streamNumStart, streamNumValue, propertyStartExpr, QueryGraphRangeEnum.GREATER_OR_EQUAL, propertyValueExpr, true);
                this.internalAddRelOp(streamNumValue, streamNumStart, propertyValueExpr, QueryGraphRangeEnum.LESS_OR_EQUAL, propertyStartExpr, true);
            }
            if (streamNumValue != streamNumEnd) {
                this.internalAddRelOp(streamNumEnd, streamNumValue, propertyEndExpr, QueryGraphRangeEnum.LESS_OR_EQUAL, propertyValueExpr, true);
                this.internalAddRelOp(streamNumValue, streamNumEnd, propertyValueExpr, QueryGraphRangeEnum.GREATER_OR_EQUAL, propertyEndExpr, true);
            }
        }
    }

    public void addRelationalOpStrict(int streamIdLeft, ExprIdentNode propertyLeftExpr, int streamIdRight, ExprIdentNode propertyRightExpr, RelationalOpEnum relationalOpEnum) {
        this.check(streamIdLeft, streamIdRight);
        this.internalAddRelOp(streamIdLeft, streamIdRight, propertyLeftExpr, QueryGraphRangeEnum.mapFrom(relationalOpEnum.reversed()), propertyRightExpr, false);
        this.internalAddRelOp(streamIdRight, streamIdLeft, propertyRightExpr, QueryGraphRangeEnum.mapFrom(relationalOpEnum), propertyLeftExpr, false);
    }

    public void addUnkeyedExpression(int indexedStream, ExprIdentNode indexedProp, ExprNode exprNodeNoIdent) {
        if (indexedStream < 0 || indexedStream >= this.numStreams) {
            throw new IllegalArgumentException("Invalid indexed stream " + indexedStream);
        }
        for (int i = 0; i < this.numStreams; ++i) {
            if (i == indexedStream) continue;
            this.internalAddEqualsUnkeyed(i, indexedStream, indexedProp, exprNodeNoIdent);
        }
    }

    public void addKeyedExpression(int indexedStream, ExprIdentNode indexedProp, int keyExprStream, ExprNode exprNodeNoIdent) {
        this.check(indexedStream, keyExprStream);
        this.internalAddEqualsNoProp(keyExprStream, indexedStream, indexedProp, exprNodeNoIdent);
    }

    private void check(int indexedStream, int keyStream) {
        if (indexedStream < 0 || indexedStream >= this.numStreams) {
            throw new IllegalArgumentException("Invalid indexed stream " + indexedStream);
        }
        if (keyStream < 0 || keyStream >= this.numStreams) {
            throw new IllegalArgumentException("Invalid key stream " + keyStream);
        }
        if (keyStream == indexedStream) {
            throw new IllegalArgumentException("Invalid key stream equals indexed stream " + keyStream);
        }
    }

    public void addRangeExpr(int indexedStream, ExprIdentNode indexedProp, ExprNode startNode, Integer optionalStartStreamNum, ExprNode endNode, Integer optionalEndStreamNum) {
        if (optionalStartStreamNum == null && optionalEndStreamNum == null) {
            for (int i = 0; i < this.numStreams; ++i) {
                if (i == indexedStream) continue;
                this.internalAddRange(i, indexedStream, QueryGraphRangeEnum.RANGE_CLOSED, startNode, endNode, indexedProp);
            }
            return;
        }
        if ((optionalStartStreamNum = Integer.valueOf(optionalStartStreamNum != null ? optionalStartStreamNum : -1)).equals(optionalEndStreamNum = Integer.valueOf(optionalEndStreamNum != null ? optionalEndStreamNum : -1)) || optionalEndStreamNum.equals(-1)) {
            this.internalAddRange(optionalStartStreamNum, indexedStream, QueryGraphRangeEnum.RANGE_CLOSED, startNode, endNode, indexedProp);
        }
        if (optionalStartStreamNum.equals(-1)) {
            this.internalAddRange(optionalEndStreamNum, indexedStream, QueryGraphRangeEnum.RANGE_CLOSED, startNode, endNode, indexedProp);
        }
    }

    public void addRelationalOp(int indexedStream, ExprIdentNode indexedProp, Integer keyStreamNum, ExprNode exprNodeNoIdent, RelationalOpEnum relationalOpEnum) {
        if (keyStreamNum == null) {
            for (int i = 0; i < this.numStreams; ++i) {
                if (i == indexedStream) continue;
                this.internalAddRelOp(i, indexedStream, exprNodeNoIdent, QueryGraphRangeEnum.mapFrom(relationalOpEnum), indexedProp, false);
            }
            return;
        }
        this.internalAddRelOp(keyStreamNum, indexedStream, exprNodeNoIdent, QueryGraphRangeEnum.mapFrom(relationalOpEnum), indexedProp, false);
    }

    public void addInSetSingleIndex(int testStreamNum, ExprNode testPropExpr, int setStreamNum, ExprNode[] setPropExpr) {
        this.check(testStreamNum, setStreamNum);
        this.internalAddInKeywordSingleIndex(setStreamNum, testStreamNum, testPropExpr, setPropExpr);
    }

    public void addInSetSingleIndexUnkeyed(int testStreamNum, ExprNode testPropExpr, ExprNode[] setPropExpr) {
        for (int i = 0; i < this.numStreams; ++i) {
            if (i == testStreamNum) continue;
            this.internalAddInKeywordSingleIndex(i, testStreamNum, testPropExpr, setPropExpr);
        }
    }

    public void addInSetMultiIndex(int testStreamNum, ExprNode testPropExpr, int setStreamNum, ExprNode[] setPropExpr) {
        this.check(testStreamNum, setStreamNum);
        this.internalAddInKeywordMultiIndex(testStreamNum, setStreamNum, testPropExpr, setPropExpr);
    }

    public void addInSetMultiIndexUnkeyed(ExprNode testPropExpr, int setStreamNum, ExprNode[] setPropExpr) {
        for (int i = 0; i < this.numStreams; ++i) {
            if (i == setStreamNum) continue;
            this.internalAddInKeywordMultiIndex(i, setStreamNum, testPropExpr, setPropExpr);
        }
    }

    private void internalAddRange(int streamKey, int streamValue, QueryGraphRangeEnum rangeOp, ExprNode propertyStartExpr, ExprNode propertyEndExpr, ExprIdentNode propertyValueExpr) {
        if (this.nToZeroAnalysis && streamValue != 0) {
            return;
        }
        if (this.optionalHint != null && this.optionalHint.filter(streamKey, streamValue, ExcludePlanFilterOperatorType.RELOP, new ExprNode[0])) {
            return;
        }
        QueryGraphValue valueLeft = this.getCreateValue(streamKey, streamValue);
        valueLeft.addRange(rangeOp, propertyStartExpr, propertyEndExpr, propertyValueExpr);
    }

    private void internalAddRelOp(int streamKey, int streamValue, ExprNode keyExpr, QueryGraphRangeEnum rangeEnum, ExprIdentNode valueExpr, boolean isBetweenOrIn) {
        if (this.nToZeroAnalysis && streamValue != 0) {
            return;
        }
        if (this.optionalHint != null && this.optionalHint.filter(streamKey, streamValue, ExcludePlanFilterOperatorType.RELOP, new ExprNode[0])) {
            return;
        }
        QueryGraphValue value = this.getCreateValue(streamKey, streamValue);
        value.addRelOp(keyExpr, rangeEnum, valueExpr, isBetweenOrIn);
    }

    private boolean internalAddEquals(int streamLookup, String propertyLookup, ExprIdentNode propertyLookupNode, int streamIndexed, ExprIdentNode propertyIndexedNode) {
        if (this.nToZeroAnalysis && streamIndexed != 0) {
            return false;
        }
        if (this.optionalHint != null && this.optionalHint.filter(streamLookup, propertyIndexedNode.getStreamId(), ExcludePlanFilterOperatorType.EQUALS, propertyLookupNode, propertyIndexedNode)) {
            return false;
        }
        QueryGraphValue value = this.getCreateValue(streamLookup, streamIndexed);
        return value.addStrictCompare(propertyLookup, propertyLookupNode, propertyIndexedNode);
    }

    private void internalAddEqualsNoProp(int keyExprStream, int indexedStream, ExprIdentNode indexedProp, ExprNode exprNodeNoIdent) {
        if (this.nToZeroAnalysis && indexedStream != 0) {
            return;
        }
        if (this.optionalHint != null && this.optionalHint.filter(keyExprStream, indexedStream, ExcludePlanFilterOperatorType.EQUALS, new ExprNode[0])) {
            return;
        }
        QueryGraphValue value = this.getCreateValue(keyExprStream, indexedStream);
        value.addKeyedExpr(indexedProp, exprNodeNoIdent);
    }

    private void internalAddEqualsUnkeyed(int streamKey, int streamValue, ExprIdentNode indexedProp, ExprNode exprNodeNoIdent) {
        if (this.nToZeroAnalysis && streamValue != 0) {
            return;
        }
        if (this.optionalHint != null && this.optionalHint.filter(streamKey, streamValue, ExcludePlanFilterOperatorType.EQUALS, new ExprNode[0])) {
            return;
        }
        QueryGraphValue value = this.getCreateValue(streamKey, streamValue);
        value.addUnkeyedExpr(indexedProp, exprNodeNoIdent);
    }

    private void internalAddInKeywordSingleIndex(int streamKey, int streamValue, ExprNode testPropExpr, ExprNode[] setPropExpr) {
        if (this.nToZeroAnalysis && streamValue != 0) {
            return;
        }
        if (this.optionalHint != null && this.optionalHint.filter(streamKey, streamValue, ExcludePlanFilterOperatorType.INKW, new ExprNode[0])) {
            return;
        }
        QueryGraphValue valueSingleIdx = this.getCreateValue(streamKey, streamValue);
        valueSingleIdx.addInKeywordSingleIdx(testPropExpr, setPropExpr);
    }

    private void internalAddInKeywordMultiIndex(int streamKey, int streamValue, ExprNode testPropExpr, ExprNode[] setPropExpr) {
        if (this.nToZeroAnalysis && streamValue != 0) {
            return;
        }
        if (this.optionalHint != null && this.optionalHint.filter(streamKey, streamValue, ExcludePlanFilterOperatorType.INKW, new ExprNode[0])) {
            return;
        }
        QueryGraphValue value = this.getCreateValue(streamKey, streamValue);
        value.addInKeywordMultiIdx(testPropExpr, setPropExpr);
    }

    private QueryGraphValue getCreateValue(int streamKey, int streamValue) {
        this.check(streamValue, streamKey);
        QueryGraphKey key = new QueryGraphKey(streamKey, streamValue);
        QueryGraphValue value = this.streamJoinMap.get(key);
        if (value == null) {
            value = new QueryGraphValue();
            this.streamJoinMap.put(key, value);
        }
        return value;
    }
}

