/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.join.plan.QueryGraphRangeConsolidateDesc;
import com.espertech.esper.epl.join.plan.QueryGraphRangeEnum;
import com.espertech.esper.epl.join.plan.QueryGraphRangeUtil;
import com.espertech.esper.epl.join.plan.QueryGraphValueDesc;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedExpr;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyedProp;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryInKeywordMultiIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryInKeywordSingleIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeIn;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRangeRelOp;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairHashKeyIndex;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairInKWMultiIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairInKWSingleIdx;
import com.espertech.esper.epl.join.plan.QueryGraphValuePairRangeIndex;
import com.espertech.esper.util.CollectionUtil;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class QueryGraphValue {
    private List<QueryGraphValueDesc> items = new ArrayList<QueryGraphValueDesc>();

    public boolean isEmptyNotNavigable() {
        return this.items.isEmpty();
    }

    public List<QueryGraphValueDesc> getItems() {
        return this.items;
    }

    public boolean addStrictCompare(String keyProperty, ExprIdentNode keyPropNode, ExprIdentNode indexPropertyIdent) {
        QueryGraphValueEntryHashKeyedExpr expr;
        QueryGraphValueDesc value = this.findIdentEntry(indexPropertyIdent);
        if (value != null && value.getEntry() instanceof QueryGraphValueEntryHashKeyedExpr && (expr = (QueryGraphValueEntryHashKeyedExpr)value.getEntry()).isConstant()) {
            return false;
        }
        if (value != null && value.getEntry() instanceof QueryGraphValueEntryHashKeyedProp) {
            return false;
        }
        this.items.add(new QueryGraphValueDesc(new ExprNode[]{indexPropertyIdent}, new QueryGraphValueEntryHashKeyedProp(keyPropNode, keyProperty)));
        return true;
    }

    public void addRange(QueryGraphRangeEnum rangeType, ExprNode propertyStart, ExprNode propertyEnd, ExprIdentNode propertyValueIdent) {
        if (!rangeType.isRange()) {
            throw new IllegalArgumentException("Expected range type, received " + (Object)((Object)rangeType));
        }
        if (this.findIdentEntry(propertyValueIdent) != null) {
            return;
        }
        this.items.add(new QueryGraphValueDesc(new ExprNode[]{propertyValueIdent}, new QueryGraphValueEntryRangeIn(rangeType, propertyStart, propertyEnd, true)));
    }

    public void addRelOp(ExprNode propertyKey, QueryGraphRangeEnum op, ExprIdentNode propertyValueIdent, boolean isBetweenOrIn) {
        QueryGraphValueDesc existing = this.findIdentEntry(propertyValueIdent);
        if (existing == null) {
            this.items.add(new QueryGraphValueDesc(new ExprNode[]{propertyValueIdent}, new QueryGraphValueEntryRangeRelOp(op, propertyKey, isBetweenOrIn)));
            return;
        }
        if (!(existing.getEntry() instanceof QueryGraphValueEntryRangeRelOp)) {
            return;
        }
        QueryGraphValueEntryRangeRelOp relOp = (QueryGraphValueEntryRangeRelOp)existing.getEntry();
        QueryGraphRangeConsolidateDesc opsDesc = QueryGraphRangeUtil.getCanConsolidate(op, relOp.getType());
        if (opsDesc != null) {
            ExprNode start = !opsDesc.isReverse() ? relOp.getExpression() : propertyKey;
            ExprNode end = !opsDesc.isReverse() ? propertyKey : relOp.getExpression();
            this.items.remove(existing);
            this.addRange(opsDesc.getType(), start, end, propertyValueIdent);
        }
    }

    public void addUnkeyedExpr(ExprIdentNode indexedPropIdent, ExprNode exprNodeNoIdent) {
        this.items.add(new QueryGraphValueDesc(new ExprNode[]{indexedPropIdent}, new QueryGraphValueEntryHashKeyedExpr(exprNodeNoIdent, false)));
    }

    public void addKeyedExpr(ExprIdentNode indexedPropIdent, ExprNode exprNodeNoIdent) {
        this.items.add(new QueryGraphValueDesc(new ExprNode[]{indexedPropIdent}, new QueryGraphValueEntryHashKeyedExpr(exprNodeNoIdent, true)));
    }

    public QueryGraphValuePairHashKeyIndex getHashKeyProps() {
        ArrayList<QueryGraphValueEntryHashKeyed> keys = new ArrayList<QueryGraphValueEntryHashKeyed>();
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryHashKeyed)) continue;
            QueryGraphValueEntryHashKeyed keyprop = (QueryGraphValueEntryHashKeyed)desc.getEntry();
            keys.add(keyprop);
            indexed.add(this.getSingleIdentNodeProp(desc.getIndexExprs()));
        }
        String[] strictKeys = new String[indexed.size()];
        int count = 0;
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryHashKeyed)) continue;
            if (desc.getEntry() instanceof QueryGraphValueEntryHashKeyedProp) {
                QueryGraphValueEntryHashKeyedProp keyprop = (QueryGraphValueEntryHashKeyedProp)desc.getEntry();
                strictKeys[count] = keyprop.getKeyProperty();
            }
            ++count;
        }
        return new QueryGraphValuePairHashKeyIndex(indexed.toArray(new String[indexed.size()]), keys, strictKeys);
    }

    public QueryGraphValuePairRangeIndex getRangeProps() {
        ArrayDeque<String> indexed = new ArrayDeque<String>();
        ArrayList<QueryGraphValueEntryRange> keys = new ArrayList<QueryGraphValueEntryRange>();
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryRange)) continue;
            QueryGraphValueEntryRange keyprop = (QueryGraphValueEntryRange)desc.getEntry();
            keys.add(keyprop);
            indexed.add(this.getSingleIdentNodeProp(desc.getIndexExprs()));
        }
        return new QueryGraphValuePairRangeIndex(indexed.toArray(new String[indexed.size()]), keys);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.append("QueryGraphValue ");
        String delimiter = "";
        for (QueryGraphValueDesc desc : this.items) {
            writer.append(delimiter);
            writer.append(ExprNodeUtility.toExpressionStringMinPrecedence(desc.getIndexExprs()));
            writer.append(": ");
            writer.append(desc.getEntry().toString());
            delimiter = ", ";
        }
        return writer.toString();
    }

    public void addInKeywordMultiIdx(ExprNode testPropExpr, ExprNode[] setProps) {
        this.items.add(new QueryGraphValueDesc(setProps, new QueryGraphValueEntryInKeywordMultiIdx(testPropExpr)));
    }

    public void addInKeywordSingleIdx(ExprNode testPropIdent, ExprNode[] setPropExpr) {
        ExprNode[] indexExpressions = new ExprNode[]{testPropIdent};
        QueryGraphValueDesc found = this.findEntry(indexExpressions);
        ExprNode[] setExpressions = setPropExpr;
        if (found != null && found.getEntry() instanceof QueryGraphValueEntryInKeywordSingleIdx) {
            QueryGraphValueEntryInKeywordSingleIdx existing = (QueryGraphValueEntryInKeywordSingleIdx)found.getEntry();
            setExpressions = (ExprNode[])CollectionUtil.addArrays(existing.getKeyExprs(), setPropExpr);
            this.items.remove(found);
        }
        this.items.add(new QueryGraphValueDesc(new ExprNode[]{testPropIdent}, new QueryGraphValueEntryInKeywordSingleIdx(setExpressions)));
    }

    public QueryGraphValuePairInKWSingleIdx getInKeywordSingles() {
        ArrayList<String> indexedProps = new ArrayList<String>();
        ArrayList<QueryGraphValueEntryInKeywordSingleIdx> single = new ArrayList<QueryGraphValueEntryInKeywordSingleIdx>();
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryInKeywordSingleIdx)) continue;
            QueryGraphValueEntryInKeywordSingleIdx keyprop = (QueryGraphValueEntryInKeywordSingleIdx)desc.getEntry();
            single.add(keyprop);
            indexedProps.add(this.getSingleIdentNodeProp(desc.getIndexExprs()));
        }
        return new QueryGraphValuePairInKWSingleIdx(indexedProps.toArray(new String[indexedProps.size()]), single);
    }

    public List<QueryGraphValuePairInKWMultiIdx> getInKeywordMulti() {
        ArrayList<QueryGraphValuePairInKWMultiIdx> multi = new ArrayList<QueryGraphValuePairInKWMultiIdx>();
        for (QueryGraphValueDesc desc : this.items) {
            if (!(desc.getEntry() instanceof QueryGraphValueEntryInKeywordMultiIdx)) continue;
            QueryGraphValueEntryInKeywordMultiIdx keyprop = (QueryGraphValueEntryInKeywordMultiIdx)desc.getEntry();
            multi.add(new QueryGraphValuePairInKWMultiIdx(desc.getIndexExprs(), keyprop));
        }
        return multi;
    }

    private QueryGraphValueDesc findIdentEntry(ExprIdentNode search) {
        for (QueryGraphValueDesc desc : this.items) {
            if (desc.getIndexExprs().length > 1 || !(desc.getIndexExprs()[0] instanceof ExprIdentNode)) continue;
            ExprIdentNode other = (ExprIdentNode)desc.getIndexExprs()[0];
            if (!search.getResolvedPropertyName().equals(other.getResolvedPropertyName())) continue;
            return desc;
        }
        return null;
    }

    private QueryGraphValueDesc findEntry(ExprNode[] search) {
        for (QueryGraphValueDesc desc : this.items) {
            if (!ExprNodeUtility.deepEquals(search, desc.getIndexExprs())) continue;
            return desc;
        }
        return null;
    }

    private String getSingleIdentNodeProp(ExprNode[] indexExprs) {
        if (indexExprs.length != 1) {
            throw new IllegalStateException("Incorrect number of index expressions");
        }
        ExprIdentNode identNode = (ExprIdentNode)indexExprs[0];
        return identNode.getResolvedPropertyName();
    }
}

