/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.plan;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.epl.join.exec.base.SortedTableLookupStrategy;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryHashKeyed;
import com.espertech.esper.epl.join.plan.QueryGraphValueEntryRange;
import com.espertech.esper.epl.join.plan.TableLookupIndexReqKey;
import com.espertech.esper.epl.join.plan.TableLookupKeyDesc;
import com.espertech.esper.epl.join.plan.TableLookupPlan;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.PropertySortedEventTable;
import java.util.Collections;

public class SortedTableLookupPlan
extends TableLookupPlan {
    private QueryGraphValueEntryRange rangeKeyPair;
    private int lookupStream;

    public SortedTableLookupPlan(int lookupStream, int indexedStream, TableLookupIndexReqKey indexNum, QueryGraphValueEntryRange rangeKeyPair) {
        super(lookupStream, indexedStream, new TableLookupIndexReqKey[]{indexNum});
        this.rangeKeyPair = rangeKeyPair;
        this.lookupStream = lookupStream;
    }

    public QueryGraphValueEntryRange getRangeKeyPair() {
        return this.rangeKeyPair;
    }

    @Override
    public TableLookupKeyDesc getKeyDescriptor() {
        return new TableLookupKeyDesc(Collections.<QueryGraphValueEntryHashKeyed>emptyList(), Collections.singletonList(this.rangeKeyPair));
    }

    @Override
    public JoinExecTableLookupStrategy makeStrategyInternal(EventTable[] eventTable, EventType[] eventTypes) {
        PropertySortedEventTable index = (PropertySortedEventTable)eventTable[0];
        return new SortedTableLookupStrategy(this.lookupStream, -1, this.rangeKeyPair, null, index);
    }

    @Override
    public String toString() {
        return "SortedTableLookupPlan " + super.toString() + " keyProperties=" + this.rangeKeyPair.toQueryPlan();
    }
}

