/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.join.table;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.epl.join.exec.base.RangeIndexLookupValue;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableOrganization;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class PropertySortedEventTable
implements EventTable {
    protected final EventPropertyGetter propertyGetter;
    protected final EventTableOrganization organization;

    public abstract Set<EventBean> lookupRange(Object var1, boolean var2, Object var3, boolean var4, boolean var5);

    public abstract Collection<EventBean> lookupRangeColl(Object var1, boolean var2, Object var3, boolean var4, boolean var5);

    public abstract Set<EventBean> lookupRangeInverted(Object var1, boolean var2, Object var3, boolean var4);

    public abstract Collection<EventBean> lookupRangeInvertedColl(Object var1, boolean var2, Object var3, boolean var4);

    public abstract Set<EventBean> lookupLess(Object var1);

    public abstract Collection<EventBean> lookupLessThenColl(Object var1);

    public abstract Set<EventBean> lookupLessEqual(Object var1);

    public abstract Collection<EventBean> lookupLessEqualColl(Object var1);

    public abstract Set<EventBean> lookupGreaterEqual(Object var1);

    public abstract Collection<EventBean> lookupGreaterEqualColl(Object var1);

    public abstract Set<EventBean> lookupGreater(Object var1);

    public abstract Collection<EventBean> lookupGreaterColl(Object var1);

    public abstract Set<EventBean> lookupConstants(RangeIndexLookupValue var1);

    public PropertySortedEventTable(EventPropertyGetter propertyGetter, EventTableOrganization organization) {
        this.propertyGetter = propertyGetter;
        this.organization = organization;
    }

    protected Object getIndexedValue(EventBean theEvent) {
        return this.propertyGetter.get(theEvent);
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (EventBean theEvent : newData) {
                this.add(theEvent);
            }
        }
        if (oldData != null) {
            for (EventBean theEvent : oldData) {
                this.remove(theEvent);
            }
        }
    }

    @Override
    public void add(EventBean[] events) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.add(theEvent);
            }
        }
    }

    @Override
    public void remove(EventBean[] events) {
        if (events != null) {
            for (EventBean theEvent : events) {
                this.remove(theEvent);
            }
        }
    }

    @Override
    public Integer getNumberOfEvents() {
        return null;
    }

    protected static Set<EventBean> normalize(SortedMap<Object, Set<EventBean>> submap) {
        if (submap.size() == 0) {
            return null;
        }
        if (submap.size() == 1) {
            return (Set)submap.get(submap.firstKey());
        }
        LinkedHashSet<EventBean> result = new LinkedHashSet<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submap.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    protected static Collection<EventBean> normalizeCollection(SortedMap<Object, Set<EventBean>> submap) {
        if (submap.size() == 0) {
            return null;
        }
        if (submap.size() == 1) {
            return (Collection)submap.get(submap.firstKey());
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submap.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    protected static Collection<EventBean> normalizeCollection(SortedMap<Object, Set<EventBean>> submapOne, SortedMap<Object, Set<EventBean>> submapTwo) {
        if (submapOne.size() == 0) {
            return PropertySortedEventTable.normalizeCollection(submapTwo);
        }
        if (submapTwo.size() == 0) {
            return PropertySortedEventTable.normalizeCollection(submapOne);
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submapOne.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<EventBean>> entry : submapTwo.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    protected static Set<EventBean> normalize(SortedMap<Object, Set<EventBean>> submapOne, SortedMap<Object, Set<EventBean>> submapTwo) {
        if (submapOne.size() == 0) {
            return PropertySortedEventTable.normalize(submapTwo);
        }
        if (submapTwo.size() == 0) {
            return PropertySortedEventTable.normalize(submapOne);
        }
        LinkedHashSet<EventBean> result = new LinkedHashSet<EventBean>();
        for (Map.Entry<Object, Set<EventBean>> entry : submapOne.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        for (Map.Entry<Object, Set<EventBean>> entry : submapTwo.entrySet()) {
            result.addAll((Collection<EventBean>)entry.getValue());
        }
        return result;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.organization.getStreamNum() + " propertyGetter=" + this.propertyGetter;
    }

    @Override
    public EventTableOrganization getOrganization() {
        return this.organization;
    }
}

