/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.plan.QueryPlanIndexItem;
import com.espertech.esper.epl.lookup.EventTableIndexMetadataEntry;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EventTableIndexMetadata {
    private final Map<IndexMultiKey, EventTableIndexMetadataEntry> indexes = new HashMap<IndexMultiKey, EventTableIndexMetadataEntry>();

    public void addIndex(boolean isPrimary, IndexMultiKey indexMultiKey, String explicitIndexName, String statementName, boolean failIfExists, QueryPlanIndexItem optionalQueryPlanIndexItem) throws ExprValidationException {
        if (this.getIndexByName(explicitIndexName) != null) {
            throw new ExprValidationException("An index by name '" + explicitIndexName + "' already exists");
        }
        if (this.indexes.containsKey(indexMultiKey)) {
            if (failIfExists) {
                throw new ExprValidationException("An index for the same columns already exists");
            }
            return;
        }
        EventTableIndexMetadataEntry entry = new EventTableIndexMetadataEntry(explicitIndexName, isPrimary, optionalQueryPlanIndexItem);
        entry.addReferringStatement(statementName);
        this.indexes.put(indexMultiKey, entry);
    }

    public Map<IndexMultiKey, EventTableIndexMetadataEntry> getIndexes() {
        return this.indexes;
    }

    public void removeIndex(IndexMultiKey imk) {
        this.indexes.remove(imk);
    }

    public boolean removeIndexReference(IndexMultiKey index, String referringStatementName) {
        EventTableIndexMetadataEntry entry = this.indexes.get(index);
        if (entry == null) {
            return false;
        }
        return entry.removeReferringStatement(referringStatementName);
    }

    public void addIndexReference(String indexName, String statementName) {
        Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry = this.findIndex(indexName);
        if (entry == null) {
            return;
        }
        entry.getValue().addReferringStatement(statementName);
    }

    public void addIndexReference(IndexMultiKey indexMultiKey, String statementName) {
        EventTableIndexMetadataEntry entry = this.indexes.get(indexMultiKey);
        if (entry == null) {
            return;
        }
        entry.addReferringStatement(statementName);
    }

    public IndexMultiKey getIndexByName(String indexName) {
        Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry = this.findIndex(indexName);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    public Collection<String> getRemoveRefIndexesDereferenced(String statementName) {
        ArrayDeque<String> indexNamesDerrefd = null;
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : this.indexes.entrySet()) {
            boolean last = entry.getValue().removeReferringStatement(statementName);
            if (!last) continue;
            if (indexNamesDerrefd == null) {
                indexNamesDerrefd = new ArrayDeque<String>(2);
            }
            indexNamesDerrefd.add(entry.getValue().getOptionalIndexName());
        }
        if (indexNamesDerrefd == null) {
            return Collections.emptyList();
        }
        for (String name : indexNamesDerrefd) {
            this.removeIndex(this.getIndexByName(name));
        }
        return indexNamesDerrefd;
    }

    private Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> findIndex(String indexName) {
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : this.indexes.entrySet()) {
            if (entry.getValue().getOptionalIndexName() == null || !entry.getValue().getOptionalIndexName().equals(indexName)) continue;
            return entry;
        }
        return null;
    }

    public String[][] getUniqueIndexProps() {
        ArrayDeque<String[]> uniques = new ArrayDeque<String[]>(2);
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : this.indexes.entrySet()) {
            if (!entry.getKey().isUnique()) continue;
            String[] props = new String[entry.getKey().getHashIndexedProps().length];
            for (int i = 0; i < entry.getKey().getHashIndexedProps().length; ++i) {
                props[i] = entry.getKey().getHashIndexedProps()[i].getIndexPropName();
            }
            uniques.add(props);
        }
        return (String[][])uniques.toArray((T[])new String[uniques.size()][]);
    }
}

