/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.epl.lookup.LookupStrategyType;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategy;
import com.espertech.esper.epl.table.strategy.ExprTableEvalLockUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

public class SubordFullTableScanTableLookupStrategy
implements SubordTableLookupStrategy {
    private final Lock tableLevelLock;
    private final Iterable<EventBean> contents;

    public SubordFullTableScanTableLookupStrategy(Lock tableLevelLock, Iterable<EventBean> contents) {
        this.tableLevelLock = tableLevelLock;
        this.contents = contents;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] events, ExprEvaluatorContext context) {
        return this.lookupInternal(context);
    }

    private Collection<EventBean> lookupInternal(ExprEvaluatorContext context) {
        ExprTableEvalLockUtil.obtainLockUnless(this.tableLevelLock, context);
        Iterator<EventBean> it = this.contents.iterator();
        if (!it.hasNext()) {
            return null;
        }
        ArrayDeque<EventBean> result = new ArrayDeque<EventBean>(2);
        while (it.hasNext()) {
            EventBean eventBean = it.next();
            result.add(eventBean);
        }
        return result;
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return new LookupStrategyDesc(LookupStrategyType.FULLTABLESCAN, null);
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }
}

