/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.lookup;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.plan.CoercionDesc;
import com.espertech.esper.epl.join.table.EventTable;
import com.espertech.esper.epl.join.table.EventTableAndNamePair;
import com.espertech.esper.epl.join.table.EventTableUtil;
import com.espertech.esper.epl.join.util.IndexNameAndDescPair;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescOnExpr;
import com.espertech.esper.epl.join.util.QueryPlanIndexDescSubquery;
import com.espertech.esper.epl.join.util.QueryPlanIndexHook;
import com.espertech.esper.epl.join.util.QueryPlanIndexHookUtil;
import com.espertech.esper.epl.lookup.EventTableIndexMetadata;
import com.espertech.esper.epl.lookup.EventTableIndexRepository;
import com.espertech.esper.epl.lookup.EventTableIndexRepositoryEntry;
import com.espertech.esper.epl.lookup.IndexKeyInfo;
import com.espertech.esper.epl.lookup.IndexMultiKey;
import com.espertech.esper.epl.lookup.IndexedPropDesc;
import com.espertech.esper.epl.lookup.SubordPropHashKey;
import com.espertech.esper.epl.lookup.SubordPropRangeKey;
import com.espertech.esper.epl.lookup.SubordTableLookupStrategyFactory;
import com.espertech.esper.epl.lookup.SubordinateQueryIndexDesc;
import com.espertech.esper.epl.lookup.SubordinateQueryPlanDesc;
import com.espertech.esper.epl.lookup.SubordinateQueryPlannerIndexPropListPair;
import com.espertech.esper.epl.lookup.SubordinateWMatchExprQueryPlanResult;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;

public class SubordinateQueryPlannerUtil {
    public static void queryPlanLogOnExpr(boolean queryPlanLogging, Log queryPlanLog, SubordinateWMatchExprQueryPlanResult strategy, Annotation[] annotations) {
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(annotations);
        if (queryPlanLogging && (queryPlanLog.isInfoEnabled() || hook != null)) {
            String prefix = "On-Expr ";
            queryPlanLog.info((Object)(prefix + "strategy " + strategy.getFactory().toQueryPlan()));
            if (strategy.getIndexDescs() == null) {
                queryPlanLog.info((Object)(prefix + "full table scan"));
            } else {
                for (int i = 0; i < strategy.getIndexDescs().length; ++i) {
                    String indexName = strategy.getIndexDescs()[i].getIndexName();
                    String indexText = indexName != null ? "index " + indexName + " " : "(implicit) (" + i + ")";
                    queryPlanLog.info((Object)(prefix + indexText));
                }
            }
            if (hook != null) {
                IndexNameAndDescPair[] pairs = SubordinateQueryPlannerUtil.getPairs(strategy.getIndexDescs());
                SubordTableLookupStrategyFactory inner = strategy.getFactory().getOptionalInnerStrategy();
                hook.infraOnExpr(new QueryPlanIndexDescOnExpr(pairs, strategy.getFactory().getClass().getSimpleName(), inner == null ? null : inner.getClass().getSimpleName()));
            }
        }
    }

    public static void queryPlanLogOnSubq(boolean queryPlanLogging, Log queryPlanLog, SubordinateQueryPlanDesc plan, int subqueryNum, Annotation[] annotations) {
        QueryPlanIndexHook hook = QueryPlanIndexHookUtil.getHook(annotations);
        if (queryPlanLogging && (queryPlanLog.isInfoEnabled() || hook != null)) {
            String prefix = "Subquery " + subqueryNum + " ";
            String strategy = plan == null || plan.getLookupStrategyFactory() == null ? "table scan" : plan.getLookupStrategyFactory().toQueryPlan();
            queryPlanLog.info((Object)(prefix + "strategy " + strategy));
            if (plan != null && plan.getIndexDescs() != null) {
                for (int i = 0; i < plan.getIndexDescs().length; ++i) {
                    String indexName = plan.getIndexDescs()[i].getIndexName();
                    String indexText = indexName != null ? "index " + indexName + " " : "(implicit) ";
                    queryPlanLog.info((Object)(prefix + "shared index"));
                    queryPlanLog.info((Object)(prefix + indexText));
                }
            }
            if (hook != null) {
                IndexNameAndDescPair[] pairs = plan == null ? new IndexNameAndDescPair[]{} : SubordinateQueryPlannerUtil.getPairs(plan.getIndexDescs());
                String factory = plan == null ? null : plan.getLookupStrategyFactory().getClass().getSimpleName();
                hook.subquery(new QueryPlanIndexDescSubquery(pairs, subqueryNum, factory));
            }
        }
    }

    private static IndexNameAndDescPair[] getPairs(SubordinateQueryIndexDesc[] indexDescs) {
        if (indexDescs == null) {
            return null;
        }
        IndexNameAndDescPair[] pairs = new IndexNameAndDescPair[indexDescs.length];
        for (int i = 0; i < indexDescs.length; ++i) {
            SubordinateQueryIndexDesc index = indexDescs[i];
            pairs[i] = new IndexNameAndDescPair(index.getIndexName(), index.getIndexMultiKey().toQueryPlan());
        }
        return pairs;
    }

    public static SubordinateQueryPlannerIndexPropListPair toListOfHashedAndBtreeProps(String[] hashIndexPropsProvided, Class[] hashIndexCoercionType, String[] rangeIndexPropsProvided, Class[] rangeIndexCoercionType) {
        int i;
        ArrayList<IndexedPropDesc> hashedProps = new ArrayList<IndexedPropDesc>();
        ArrayList<IndexedPropDesc> btreeProps = new ArrayList<IndexedPropDesc>();
        for (i = 0; i < hashIndexPropsProvided.length; ++i) {
            hashedProps.add(new IndexedPropDesc(hashIndexPropsProvided[i], hashIndexCoercionType[i]));
        }
        for (i = 0; i < rangeIndexPropsProvided.length; ++i) {
            btreeProps.add(new IndexedPropDesc(rangeIndexPropsProvided[i], rangeIndexCoercionType[i]));
        }
        return new SubordinateQueryPlannerIndexPropListPair(hashedProps, btreeProps);
    }

    public static IndexKeyInfo compileIndexKeyInfo(IndexMultiKey indexMultiKey, String[] hashIndexPropsProvided, SubordPropHashKey[] hashJoinedProps, String[] rangeIndexPropsProvided, SubordPropRangeKey[] rangeJoinedProps) {
        IndexedPropDesc[] indexedKeyProps = indexMultiKey.getHashIndexedProps();
        boolean isCoerceHash = false;
        SubordPropHashKey[] hashesDesc = new SubordPropHashKey[indexedKeyProps.length];
        Class[] hashPropCoercionTypes = new Class[indexedKeyProps.length];
        for (int i = 0; i < indexedKeyProps.length; ++i) {
            String indexField = indexedKeyProps[i].getIndexPropName();
            int index = CollectionUtil.findItem(hashIndexPropsProvided, indexField);
            if (index == -1) {
                throw new IllegalStateException("Could not find index property for lookup '" + indexedKeyProps[i]);
            }
            hashesDesc[i] = hashJoinedProps[index];
            hashPropCoercionTypes[i] = indexedKeyProps[i].getCoercionType();
            ExprEvaluator evaluatorHashkey = hashesDesc[i].getHashKey().getKeyExpr().getExprEvaluator();
            if (evaluatorHashkey == null || JavaClassHelper.getBoxedType(indexedKeyProps[i].getCoercionType()) == JavaClassHelper.getBoxedType(evaluatorHashkey.getType())) continue;
            isCoerceHash = true;
        }
        indexedKeyProps = indexMultiKey.getRangeIndexedProps();
        SubordPropRangeKey[] rangesDesc = new SubordPropRangeKey[indexedKeyProps.length];
        Class[] rangePropCoercionTypes = new Class[indexedKeyProps.length];
        boolean isCoerceRange = false;
        for (int i = 0; i < indexedKeyProps.length; ++i) {
            String indexField = indexedKeyProps[i].getIndexPropName();
            int index = CollectionUtil.findItem(rangeIndexPropsProvided, indexField);
            if (index == -1) {
                throw new IllegalStateException("Could not find range property for lookup '" + indexedKeyProps[i]);
            }
            rangesDesc[i] = rangeJoinedProps[index];
            rangePropCoercionTypes[i] = rangeJoinedProps[index].getCoercionType();
            if (JavaClassHelper.getBoxedType(indexedKeyProps[i].getCoercionType()) == JavaClassHelper.getBoxedType(rangePropCoercionTypes[i])) continue;
            isCoerceRange = true;
        }
        return new IndexKeyInfo(Arrays.asList(hashesDesc), new CoercionDesc(isCoerceHash, hashPropCoercionTypes), Arrays.asList(rangesDesc), new CoercionDesc(isCoerceRange, rangePropCoercionTypes));
    }

    private static IndexNameAndDescPair[] getTableClassNamePairs(EventTableAndNamePair[] pairs) {
        if (pairs == null) {
            return new IndexNameAndDescPair[0];
        }
        IndexNameAndDescPair[] names = new IndexNameAndDescPair[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            names[i] = new IndexNameAndDescPair(pairs[i].getIndexName(), pairs[i].getEventTable().getProviderClass().getSimpleName());
        }
        return names;
    }

    public static EventTable[] realizeTables(SubordinateQueryIndexDesc[] indexDescriptors, EventType eventType, EventTableIndexRepository indexRepository, Iterable<EventBean> contents, AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        EventTable[] tables = new EventTable[indexDescriptors.length];
        for (int i = 0; i < tables.length; ++i) {
            SubordinateQueryIndexDesc desc = indexDescriptors[i];
            EventTable table = indexRepository.getIndexByDesc(desc.getIndexMultiKey());
            if (table == null) {
                table = EventTableUtil.buildIndex(agentInstanceContext, 0, desc.getQueryPlanIndexItem(), eventType, true, desc.getIndexMultiKey().isUnique(), null, null, false);
                if (!isRecoveringResilient) {
                    EventBean[] events = new EventBean[1];
                    Iterator<EventBean> i$ = contents.iterator();
                    while (i$.hasNext()) {
                        EventBean prefilledEvent;
                        events[0] = prefilledEvent = i$.next();
                        table.add(events);
                    }
                }
                indexRepository.addIndex(desc.getIndexMultiKey(), new EventTableIndexRepositoryEntry(null, table));
            }
            tables[i] = table;
        }
        return tables;
    }

    public static void addIndexMetaAndRef(SubordinateQueryIndexDesc[] indexDescs, EventTableIndexMetadata repo, String statementName) throws ExprValidationException {
        for (SubordinateQueryIndexDesc desc : indexDescs) {
            if (desc.getIndexName() != null) {
                repo.addIndexReference(desc.getIndexName(), statementName);
                continue;
            }
            repo.addIndex(false, desc.getIndexMultiKey(), null, statementName, false, desc.getQueryPlanIndexItem());
            repo.addIndexReference(desc.getIndexMultiKey(), statementName);
        }
    }
}

