/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.named.NamedWindowConsumerLatch;
import com.espertech.esper.epl.named.NamedWindowConsumerLatchFactory;
import com.espertech.esper.epl.named.NamedWindowConsumerView;
import com.espertech.esper.epl.named.NamedWindowDeltaData;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NamedWindowConsumerLatchWait
extends NamedWindowConsumerLatch {
    private static final Log log = LogFactory.getLog(NamedWindowConsumerLatchWait.class);
    private final NamedWindowConsumerLatchFactory factory;
    private NamedWindowConsumerLatchWait earlier;
    private NamedWindowConsumerLatchWait later;
    private volatile boolean isCompleted;
    private Thread currentThread;

    public NamedWindowConsumerLatchWait(NamedWindowDeltaData deltaData, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> dispatchTo, NamedWindowConsumerLatchFactory factory, NamedWindowConsumerLatchWait earlier) {
        super(deltaData, dispatchTo);
        this.factory = factory;
        this.earlier = earlier;
    }

    public NamedWindowConsumerLatchWait(NamedWindowConsumerLatchFactory factory) {
        super(null, null);
        this.factory = factory;
        this.isCompleted = true;
        this.earlier = null;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setLater(NamedWindowConsumerLatchWait later) {
        this.later = later;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() {
        if (this.earlier.isCompleted) {
            this.currentThread = Thread.currentThread();
            return;
        }
        if (this.earlier.getCurrentThread() == Thread.currentThread()) {
            this.currentThread = Thread.currentThread();
            return;
        }
        NamedWindowConsumerLatchWait namedWindowConsumerLatchWait = this;
        synchronized (namedWindowConsumerLatchWait) {
            if (!this.earlier.isCompleted) {
                try {
                    this.wait(this.factory.getMsecWait());
                }
                catch (InterruptedException e) {
                    log.error((Object)e);
                }
            }
        }
        if (!this.earlier.isCompleted) {
            log.info((Object)"Wait timeout exceeded for named window '' consumer dispatch with notify");
        }
    }

    @Override
    public Thread getCurrentThread() {
        return this.currentThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        this.isCompleted = true;
        if (this.later != null) {
            NamedWindowConsumerLatchWait namedWindowConsumerLatchWait = this.later;
            synchronized (namedWindowConsumerLatchWait) {
                this.later.notify();
            }
        }
        this.earlier = null;
        this.later = null;
    }
}

