/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.named;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.collection.FilteredEventIterator;
import com.espertech.esper.collection.FlushedEventBuffer;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.named.NamedWindowConsumerCallback;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;

public class NamedWindowConsumerView
extends ViewSupport
implements StopCallback {
    private final ExprEvaluator[] filterList;
    private final EventType eventType;
    private final NamedWindowConsumerCallback consumerCallback;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final PropertyEvaluator optPropertyEvaluator;
    private final FlushedEventBuffer optPropertyContainedBuffer;
    private final boolean audit;

    public NamedWindowConsumerView(ExprEvaluator[] filterList, PropertyEvaluator optPropertyEvaluator, EventType eventType, NamedWindowConsumerCallback consumerCallback, ExprEvaluatorContext exprEvaluatorContext, boolean audit) {
        this.filterList = filterList;
        this.optPropertyEvaluator = optPropertyEvaluator;
        this.optPropertyContainedBuffer = optPropertyEvaluator != null ? new FlushedEventBuffer() : null;
        this.eventType = eventType;
        this.consumerCallback = consumerCallback;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.audit = audit;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (this.audit && AuditPath.isInfoEnabled()) {
            AuditPath.auditLog(this.exprEvaluatorContext.getEngineURI(), this.exprEvaluatorContext.getStatementName(), AuditEnum.STREAM, this.eventType.getName() + " insert {" + EventBeanUtility.summarize(newData) + "} remove {" + EventBeanUtility.summarize(oldData) + "}");
        }
        if (this.filterList.length != 0) {
            EventBean[] eventPerStream = new EventBean[1];
            newData = this.passFilter(newData, true, this.exprEvaluatorContext, eventPerStream);
            oldData = this.passFilter(oldData, false, this.exprEvaluatorContext, eventPerStream);
        }
        if (this.optPropertyEvaluator != null) {
            newData = this.getUnpacked(newData);
            oldData = this.getUnpacked(oldData);
        }
        if (newData != null || oldData != null) {
            this.updateChildren(newData, oldData);
        }
    }

    private EventBean[] getUnpacked(EventBean[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return data;
        }
        for (int i = 0; i < data.length; ++i) {
            EventBean[] unpacked = this.optPropertyEvaluator.getProperty(data[i], this.exprEvaluatorContext);
            this.optPropertyContainedBuffer.add(unpacked);
        }
        return this.optPropertyContainedBuffer.getAndFlush();
    }

    private EventBean[] passFilter(EventBean[] eventData, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext, EventBean[] eventPerStream) {
        if (eventData == null || eventData.length == 0) {
            return null;
        }
        OneEventCollection filtered = null;
        EventBean[] arr$ = eventData;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean theEvent;
            eventPerStream[0] = theEvent = arr$[i$];
            boolean pass = true;
            for (ExprEvaluator filter : this.filterList) {
                Boolean result = (Boolean)filter.evaluate(eventPerStream, isNewData, exprEvaluatorContext);
                if (result != null && result.booleanValue()) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            if (filtered == null) {
                filtered = new OneEventCollection();
            }
            filtered.add(theEvent);
        }
        if (filtered == null) {
            return null;
        }
        return filtered.toArray();
    }

    @Override
    public EventType getEventType() {
        if (this.optPropertyEvaluator != null) {
            return this.optPropertyEvaluator.getFragmentEventType();
        }
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new FilteredEventIterator(this.filterList, this.consumerCallback.getIterator(), this.exprEvaluatorContext);
    }

    @Override
    public void stop() {
        this.consumerCallback.stopped(this);
    }
}

