/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.type.BoolValue;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.type.FloatValue;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.LongValue;
import com.espertech.esper.type.StringValue;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;

public class ASTConstantHelper {
    public static String removeTicks(String tickedString) {
        int indexLast;
        int indexFirst = tickedString.indexOf(96);
        if (indexFirst != (indexLast = tickedString.lastIndexOf(96)) && indexFirst != -1 && indexLast != -1) {
            return tickedString.substring(indexFirst + 1, indexLast);
        }
        return tickedString;
    }

    public static Object parse(ParseTree node) {
        if (node instanceof TerminalNode) {
            TerminalNode terminal = (TerminalNode)node;
            switch (terminal.getSymbol().getType()) {
                case 104: {
                    return BoolValue.parseString(terminal.getText());
                }
                case 105: {
                    return BoolValue.parseString(terminal.getText());
                }
                case 106: {
                    return null;
                }
            }
            throw ASTWalkException.from("Encountered unexpected constant type " + terminal.getSymbol().getType(), terminal.getSymbol());
        }
        RuleNode ruleNode = (RuleNode)node;
        int ruleIndex = ruleNode.getRuleContext().getRuleIndex();
        if (ruleIndex == 234) {
            return ASTConstantHelper.parseNumber(ruleNode, 1);
        }
        if (ruleIndex == 237) {
            RuleNode number = ASTConstantHelper.findChildRuleByType((Tree)ruleNode, 234);
            if (ruleNode.getChildCount() > 1) {
                if (ASTUtil.isTerminatedOfType((Tree)ruleNode.getChild(0), 158)) {
                    return ASTConstantHelper.parseNumber(number, -1);
                }
                return ASTConstantHelper.parseNumber(number, 1);
            }
            return ASTConstantHelper.parseNumber(number, 1);
        }
        if (ruleIndex == 238) {
            return StringValue.parseString(node.getText());
        }
        if (ruleIndex == 236) {
            return ASTConstantHelper.parse(ruleNode.getChild(0));
        }
        throw ASTWalkException.from("Encountered unrecognized constant", node.getText());
    }

    private static Object parseNumber(RuleNode number, int factor) {
        int tokenType = ASTConstantHelper.getSingleChildTokenType(number);
        if (tokenType == 192) {
            return ASTConstantHelper.parseIntLongByte(number.getText(), factor);
        }
        if (tokenType == 193) {
            String numberText = number.getText();
            if (numberText.endsWith("f") || numberText.endsWith("F")) {
                return Float.valueOf(FloatValue.parseString(number.getText()) * (float)factor);
            }
            return DoubleValue.parseString(number.getText()) * (double)factor;
        }
        throw ASTWalkException.from("Encountered unrecognized constant", number.getText());
    }

    private static Object parseIntLongByte(String arg, int factor) {
        try {
            return IntValue.parseString(arg) * factor;
        }
        catch (NumberFormatException e1) {
            try {
                return LongValue.parseString(arg) * (long)factor;
            }
            catch (Exception e2) {
                try {
                    return Byte.decode(arg);
                }
                catch (Exception e3) {
                    throw e1;
                }
            }
        }
    }

    private static RuleNode findChildRuleByType(Tree node, int ruleNum) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            Tree child = node.getChild(i);
            if (!ASTConstantHelper.isRuleOfType(child, ruleNum)) continue;
            return (RuleNode)child;
        }
        return null;
    }

    private static boolean isRuleOfType(Tree child, int ruleNum) {
        if (!(child instanceof RuleNode)) {
            return false;
        }
        RuleNode ruleNode = (RuleNode)child;
        return ruleNode.getRuleContext().getRuleIndex() == ruleNum;
    }

    private static int getSingleChildTokenType(RuleNode node) {
        return ((TerminalNode)node.getChild(0)).getSymbol().getType();
    }
}

