/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.client.EPException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.ColumnDesc;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class ASTCreateSchemaHelper {
    public static CreateSchemaDesc walkCreateSchema(EsperEPL2GrammarParser.CreateSchemaExprContext ctx) throws EPException {
        CreateSchemaDesc.AssignedType assignedType = CreateSchemaDesc.AssignedType.NONE;
        if (ctx.keyword != null) {
            assignedType = CreateSchemaDesc.AssignedType.parseKeyword(ctx.keyword.getText());
        }
        return ASTCreateSchemaHelper.getSchemaDesc(ctx.createSchemaDef(), assignedType);
    }

    private static CreateSchemaDesc getSchemaDesc(EsperEPL2GrammarParser.CreateSchemaDefContext ctx, CreateSchemaDesc.AssignedType assignedType) throws EPException {
        String schemaName = ctx.name.getText();
        List<ColumnDesc> columnTypes = ASTCreateSchemaHelper.getColTypeList(ctx.createColumnList());
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
        if (ctx.variantList() != null) {
            List<EsperEPL2GrammarParser.VariantListElementContext> variantCtxs = ctx.variantList().variantListElement();
            for (EsperEPL2GrammarParser.VariantListElementContext variantCtx : variantCtxs) {
                typeNames.add(variantCtx.getText());
            }
        }
        String startTimestamp = null;
        String endTimestamp = null;
        LinkedHashSet<String> inherited = new LinkedHashSet<String>();
        LinkedHashSet<String> copyFrom = new LinkedHashSet<String>();
        if (ctx.createSchemaQual() != null) {
            List<EsperEPL2GrammarParser.CreateSchemaQualContext> qualCtxs = ctx.createSchemaQual();
            for (EsperEPL2GrammarParser.CreateSchemaQualContext qualCtx : qualCtxs) {
                String qualName = qualCtx.i.getText().toLowerCase();
                List<String> cols = ASTUtil.getIdentList(qualCtx.columnList());
                if (qualName.toLowerCase().equals("inherits")) {
                    inherited.addAll(cols);
                    continue;
                }
                if (qualName.toLowerCase().equals("starttimestamp")) {
                    startTimestamp = cols.get(0);
                    continue;
                }
                if (qualName.toLowerCase().equals("endtimestamp")) {
                    endTimestamp = cols.get(0);
                    continue;
                }
                if (qualName.toLowerCase().equals("copyfrom")) {
                    copyFrom.addAll(cols);
                    continue;
                }
                throw new EPException("Expected 'inherits', 'starttimestamp', 'endtimestamp' or 'copyfrom' keyword after create-schema clause but encountered '" + qualName + "'");
            }
        }
        return new CreateSchemaDesc(schemaName, typeNames, columnTypes, inherited, assignedType, startTimestamp, endTimestamp, copyFrom);
    }

    public static List<ColumnDesc> getColTypeList(EsperEPL2GrammarParser.CreateColumnListContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnDesc> result = new ArrayList<ColumnDesc>(ctx.createColumnListElement().size());
        for (EsperEPL2GrammarParser.CreateColumnListElementContext colctx : ctx.createColumnListElement()) {
            List<EsperEPL2GrammarParser.ClassIdentifierContext> idents = colctx.classIdentifier();
            String name = ASTUtil.unescapeClassIdent(idents.get(0));
            String type = colctx.VALUE_NULL() != null ? null : ASTUtil.unescapeClassIdent(idents.get(1));
            boolean array = colctx.b != null;
            boolean primitiveArray = ASTCreateSchemaHelper.validateIsPrimitiveArray(colctx.p);
            result.add(new ColumnDesc(name, type, array, primitiveArray));
        }
        return result;
    }

    protected static boolean validateIsPrimitiveArray(Token p) {
        if (p != null) {
            if (!p.getText().toLowerCase().equals("primitive")) {
                throw ASTWalkException.from("Column type keyword '" + p.getText() + "' not recognized, expecting '[primitive]'");
            }
            return true;
        }
        return false;
    }
}

