/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprValidationPropertyException;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstMsec;
import com.espertech.esper.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.epl.property.PropertyEvaluatorFactory;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.MatchEventSpec;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.pattern.EvalAuditInstanceCount;
import com.espertech.esper.pattern.EvalEveryDistinctFactoryNode;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalFollowedByFactoryNode;
import com.espertech.esper.pattern.EvalGuardFactoryNode;
import com.espertech.esper.pattern.EvalMatchUntilFactoryNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.EvalNodeUtilFactoryFilter;
import com.espertech.esper.pattern.EvalObserverFactoryNode;
import com.espertech.esper.pattern.MatchedEventConvertorImpl;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import com.espertech.esper.pattern.PatternNodeFactory;
import com.espertech.esper.pattern.PatternObjectException;
import com.espertech.esper.pattern.guard.GuardFactory;
import com.espertech.esper.pattern.guard.GuardParameterException;
import com.espertech.esper.pattern.observer.ObserverFactory;
import com.espertech.esper.pattern.observer.ObserverParameterException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.UuidGenerator;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PatternStreamSpecRaw
extends StreamSpecBase
implements StreamSpecRaw {
    private final EvalFactoryNode evalFactoryNode;
    private final boolean suppressSameEventMatches;
    private final boolean discardPartialsOnMatch;
    private static final Log log = LogFactory.getLog(PatternStreamSpecRaw.class);
    private static final long serialVersionUID = 6393401926404401433L;

    public PatternStreamSpecRaw(EvalFactoryNode evalFactoryNode, ViewSpec[] viewSpecs, String optionalStreamName, StreamSpecOptions streamSpecOptions, boolean suppressSameEventMatches, boolean discardPartialsOnMatch) {
        super(optionalStreamName, viewSpecs, streamSpecOptions);
        this.evalFactoryNode = evalFactoryNode;
        this.suppressSameEventMatches = suppressSameEventMatches;
        this.discardPartialsOnMatch = discardPartialsOnMatch;
    }

    public EvalFactoryNode getEvalFactoryNode() {
        return this.evalFactoryNode;
    }

    @Override
    public PatternStreamSpecCompiled compile(StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto, Collection<Integer> assignedTypeNumberStack, boolean isJoin, boolean isContextDeclaration, boolean isOnTrigger, String optionalStreamName) throws ExprValidationException {
        return this.compileInternal(context, eventTypeReferences, isInsertInto, assignedTypeNumberStack, null, null, isJoin, isContextDeclaration, isOnTrigger);
    }

    public PatternStreamSpecCompiled compile(StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto, Collection<Integer> assignedTypeNumberStack, MatchEventSpec priorTags, Set<String> priorAllTags, boolean isJoin, boolean isContextDeclaration, boolean isOnTrigger) throws ExprValidationException {
        return this.compileInternal(context, eventTypeReferences, isInsertInto, assignedTypeNumberStack, priorTags, priorAllTags, isJoin, isContextDeclaration, isOnTrigger);
    }

    private PatternStreamSpecCompiled compileInternal(StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto, Collection<Integer> assignedTypeNumberStack, MatchEventSpec tags, Set<String> priorAllTags, boolean isJoin, boolean isContextDeclaration, boolean isOnTrigger) throws ExprValidationException {
        if ((this.suppressSameEventMatches || this.discardPartialsOnMatch) && (isJoin || isContextDeclaration || isOnTrigger)) {
            throw new ExprValidationException("Discard-partials and suppress-matches is not supported in a joins, context declaration and on-action");
        }
        if (tags == null) {
            tags = new MatchEventSpec();
        }
        ArrayDeque<Integer> subexpressionIdStack = new ArrayDeque<Integer>(assignedTypeNumberStack);
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(context, false);
        Stack<EvalFactoryNode> nodeStack = new Stack<EvalFactoryNode>();
        Set<EvalFactoryNode> filterFactoryNodes = EvalNodeUtil.recursiveGetChildNodes(this.evalFactoryNode, FilterForFilterFactoryNodes.INSTANCE);
        LinkedHashSet<String> allTagNamesOrdered = new LinkedHashSet<String>();
        if (priorAllTags != null) {
            allTagNamesOrdered.addAll(priorAllTags);
        }
        for (EvalFactoryNode filterNode : filterFactoryNodes) {
            int tagNumber;
            EvalFilterFactoryNode factory = (EvalFilterFactoryNode)filterNode;
            if (factory.getEventAsName() == null) continue;
            if (!allTagNamesOrdered.contains(factory.getEventAsName())) {
                allTagNamesOrdered.add(factory.getEventAsName());
                tagNumber = allTagNamesOrdered.size() - 1;
            } else {
                tagNumber = PatternStreamSpecRaw.findTagNumber(factory.getEventAsName(), allTagNamesOrdered);
            }
            factory.setEventAsTagNumber(tagNumber);
        }
        PatternStreamSpecRaw.recursiveCompile(this.evalFactoryNode, context, evaluatorContextStmt, eventTypeReferences, isInsertInto, tags, subexpressionIdStack, nodeStack, allTagNamesOrdered);
        Audit auditPattern = AuditEnum.PATTERN.getAudit(context.getAnnotations());
        Audit auditPatternInstance = AuditEnum.PATTERNINSTANCES.getAudit(context.getAnnotations());
        EvalFactoryNode compiledEvalFactoryNode = this.evalFactoryNode;
        if (context.getPatternNodeFactory().isAuditSupported() && (auditPattern != null || auditPatternInstance != null)) {
            EvalAuditInstanceCount instanceCount = new EvalAuditInstanceCount();
            compiledEvalFactoryNode = PatternStreamSpecRaw.recursiveAddAuditNode(context.getPatternNodeFactory(), null, auditPattern != null, auditPatternInstance != null, this.evalFactoryNode, instanceCount);
        }
        return new PatternStreamSpecCompiled(compiledEvalFactoryNode, tags.getTaggedEventTypes(), tags.getArrayEventTypes(), allTagNamesOrdered, this.getViewSpecs(), this.getOptionalStreamName(), this.getOptions(), this.suppressSameEventMatches, this.discardPartialsOnMatch);
    }

    private static void recursiveCompile(EvalFactoryNode evalNode, StatementContext context, ExprEvaluatorContext evaluatorContext, Set<String> eventTypeReferences, boolean isInsertInto, MatchEventSpec tags, Deque<Integer> subexpressionIdStack, Stack<EvalFactoryNode> parentNodeStack, LinkedHashSet<String> allTagNamesOrdered) throws ExprValidationException {
        int counter = 0;
        parentNodeStack.push(evalNode);
        for (EvalFactoryNode child : evalNode.getChildNodes()) {
            subexpressionIdStack.addLast(counter++);
            PatternStreamSpecRaw.recursiveCompile(child, context, evaluatorContext, eventTypeReferences, isInsertInto, tags, subexpressionIdStack, parentNodeStack, allTagNamesOrdered);
            subexpressionIdStack.removeLast();
        }
        parentNodeStack.pop();
        LinkedHashMap<String, Pair<EventType, String>> newTaggedEventTypes = null;
        LinkedHashMap<String, Pair<EventType, String>> newArrayEventTypes = null;
        if (evalNode instanceof EvalFilterFactoryNode) {
            String selfStreamName;
            EventType resolvedEventType;
            EvalFilterFactoryNode filterNode = (EvalFilterFactoryNode)evalNode;
            String eventName = filterNode.getRawFilterSpec().getEventTypeName();
            if (context.getTableService().getTableMetadata(eventName) != null) {
                throw new ExprValidationException("Tables cannot be used in pattern filter atoms");
            }
            EventType finalEventType = resolvedEventType = FilterStreamSpecRaw.resolveType(context.getEngineURI(), eventName, context.getEventAdapterService(), context.getPlugInTypeResolutionURIs());
            String optionalTag = filterNode.getEventAsName();
            boolean isPropertyEvaluation = false;
            boolean isParentMatchUntil = PatternStreamSpecRaw.isParentMatchUntil(evalNode, parentNodeStack);
            if (filterNode.getRawFilterSpec().getOptionalPropertyEvalSpec() != null) {
                PropertyEvaluator optionalPropertyEvaluator = PropertyEvaluatorFactory.makeEvaluator(filterNode.getRawFilterSpec().getOptionalPropertyEvalSpec(), resolvedEventType, filterNode.getEventAsName(), context.getEventAdapterService(), context.getEngineImportService(), context.getSchedulingService(), context.getVariableService(), context.getTableService(), context.getEngineURI(), context.getStatementId(), context.getStatementName(), context.getAnnotations(), subexpressionIdStack, context.getConfigSnapshot(), context.getNamedWindowMgmtService(), context.getStatementExtensionServicesContext());
                finalEventType = optionalPropertyEvaluator.getFragmentEventType();
                isPropertyEvaluation = true;
            }
            if (finalEventType instanceof EventTypeSPI) {
                eventTypeReferences.add(((EventTypeSPI)finalEventType).getMetadata().getPrimaryName());
            }
            if (optionalTag != null) {
                Pair<EventType, String> pair = tags.getTaggedEventTypes().get(optionalTag);
                EventType existingType = null;
                if (pair != null) {
                    existingType = pair.getFirst();
                }
                if (existingType == null && (pair = tags.getArrayEventTypes().get(optionalTag)) != null) {
                    throw new ExprValidationException("Tag '" + optionalTag + "' for event '" + eventName + "' used in the repeat-until operator cannot also appear in other filter expressions");
                }
                if (existingType != null && existingType != finalEventType) {
                    throw new ExprValidationException("Tag '" + optionalTag + "' for event '" + eventName + "' has already been declared for events of type " + existingType.getUnderlyingType().getName());
                }
                pair = new Pair<EventType, String>(finalEventType, eventName);
                if (isPropertyEvaluation || isParentMatchUntil) {
                    newArrayEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                    newArrayEventTypes.put(optionalTag, pair);
                } else {
                    newTaggedEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                    newTaggedEventTypes.put(optionalTag, pair);
                }
            }
            if ((selfStreamName = optionalTag) == null) {
                selfStreamName = "s_" + UuidGenerator.generate();
            }
            LinkedHashMap<String, Pair<EventType, String>> filterTypes = new LinkedHashMap<String, Pair<EventType, String>>();
            Pair<EventType, String> typePair = new Pair<EventType, String>(finalEventType, eventName);
            filterTypes.put(selfStreamName, typePair);
            filterTypes.putAll(tags.getTaggedEventTypes());
            LinkedHashMap<String, Pair<EventType, String>> filterTaggedEventTypes = new LinkedHashMap<String, Pair<EventType, String>>(tags.getTaggedEventTypes());
            filterTaggedEventTypes.remove(optionalTag);
            LinkedHashMap<String, Pair<EventType, String>> arrayCompositeEventTypes = null;
            if (tags.getArrayEventTypes() != null && !tags.getArrayEventTypes().isEmpty()) {
                arrayCompositeEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                String patternSubexEventType = PatternStreamSpecRaw.getPatternSubexEventType(context.getStatementId(), "pattern", subexpressionIdStack);
                for (Map.Entry<String, Pair<EventType, String>> entry : tags.getArrayEventTypes().entrySet()) {
                    LinkedHashMap<String, Pair<EventType, String>> specificArrayType = new LinkedHashMap<String, Pair<EventType, String>>();
                    specificArrayType.put(entry.getKey(), entry.getValue());
                    EventType arrayTagCompositeEventType = context.getEventAdapterService().createSemiAnonymousMapType(patternSubexEventType, Collections.<String, Pair<EventType, String>>emptyMap(), specificArrayType, isInsertInto);
                    context.getStatementSemiAnonymousTypeRegistry().register(arrayTagCompositeEventType);
                    String tag = entry.getKey();
                    if (filterTypes.containsKey(tag)) continue;
                    Pair<EventType, String> pair = new Pair<EventType, String>(arrayTagCompositeEventType, tag);
                    filterTypes.put(tag, pair);
                    arrayCompositeEventTypes.put(tag, pair);
                }
            }
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(filterTypes, context.getEngineURI(), true, false);
            List<ExprNode> exprNodes = filterNode.getRawFilterSpec().getFilterExpressions();
            FilterSpecCompiled spec = FilterSpecCompiler.makeFilterSpec(resolvedEventType, eventName, exprNodes, filterNode.getRawFilterSpec().getOptionalPropertyEvalSpec(), filterTaggedEventTypes, arrayCompositeEventTypes, streamTypeService, null, context, subexpressionIdStack);
            filterNode.setFilterSpec(spec);
        } else {
            if (evalNode instanceof EvalObserverFactoryNode) {
                EvalObserverFactoryNode observerNode = (EvalObserverFactoryNode)evalNode;
                try {
                    ObserverFactory observerFactory = context.getPatternResolutionService().create(observerNode.getPatternObserverSpec());
                    StreamTypeService streamTypeService = PatternStreamSpecRaw.getStreamTypeService(context.getEngineURI(), context.getStatementId(), context.getEventAdapterService(), tags.getTaggedEventTypes(), tags.getArrayEventTypes(), subexpressionIdStack, "observer", context);
                    ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, context.getEngineImportService(), context.getStatementExtensionServicesContext(), null, context.getSchedulingService(), context.getVariableService(), context.getTableService(), evaluatorContext, context.getEventAdapterService(), context.getStatementName(), context.getStatementId(), context.getAnnotations(), context.getContextDescriptor(), false, false, false, false, null, false);
                    List<ExprNode> validated = PatternStreamSpecRaw.validateExpressions(ExprNodeOrigin.PATTERNOBSERVER, observerNode.getPatternObserverSpec().getObjectParameters(), validationContext);
                    MatchedEventConvertorImpl convertor = new MatchedEventConvertorImpl(tags.getTaggedEventTypes(), tags.getArrayEventTypes(), allTagNamesOrdered, context.getEventAdapterService());
                    observerNode.setObserverFactory(observerFactory);
                    observerFactory.setObserverParameters(validated, convertor, validationContext);
                }
                catch (ObserverParameterException e) {
                    throw new ExprValidationException("Invalid parameter for pattern observer '" + observerNode.toPrecedenceFreeEPL() + "': " + e.getMessage(), e);
                }
                catch (PatternObjectException e) {
                    throw new ExprValidationException("Failed to resolve pattern observer '" + observerNode.toPrecedenceFreeEPL() + "': " + e.getMessage(), e);
                }
            }
            if (evalNode instanceof EvalGuardFactoryNode) {
                EvalGuardFactoryNode guardNode = (EvalGuardFactoryNode)evalNode;
                try {
                    GuardFactory guardFactory = context.getPatternResolutionService().create(guardNode.getPatternGuardSpec());
                    StreamTypeService streamTypeService = PatternStreamSpecRaw.getStreamTypeService(context.getEngineURI(), context.getStatementId(), context.getEventAdapterService(), tags.getTaggedEventTypes(), tags.getArrayEventTypes(), subexpressionIdStack, "guard", context);
                    ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, context.getEngineImportService(), context.getStatementExtensionServicesContext(), null, context.getSchedulingService(), context.getVariableService(), context.getTableService(), evaluatorContext, context.getEventAdapterService(), context.getStatementName(), context.getStatementId(), context.getAnnotations(), context.getContextDescriptor(), false, false, false, false, null, false);
                    List<ExprNode> validated = PatternStreamSpecRaw.validateExpressions(ExprNodeOrigin.PATTERNGUARD, guardNode.getPatternGuardSpec().getObjectParameters(), validationContext);
                    MatchedEventConvertorImpl convertor = new MatchedEventConvertorImpl(tags.getTaggedEventTypes(), tags.getArrayEventTypes(), allTagNamesOrdered, context.getEventAdapterService());
                    guardNode.setGuardFactory(guardFactory);
                    guardFactory.setGuardParameters(validated, convertor);
                }
                catch (GuardParameterException e) {
                    throw new ExprValidationException("Invalid parameter for pattern guard '" + guardNode.toPrecedenceFreeEPL() + "': " + e.getMessage(), e);
                }
                catch (PatternObjectException e) {
                    throw new ExprValidationException("Failed to resolve pattern guard '" + guardNode.toPrecedenceFreeEPL() + "': " + e.getMessage(), e);
                }
            }
            if (evalNode instanceof EvalEveryDistinctFactoryNode) {
                List<ExprNode> validated;
                EvalEveryDistinctFactoryNode distinctNode = (EvalEveryDistinctFactoryNode)evalNode;
                MatchEventSpec matchEventFromChildNodes = PatternStreamSpecRaw.analyzeMatchEvent(distinctNode);
                StreamTypeService streamTypeService = PatternStreamSpecRaw.getStreamTypeService(context.getEngineURI(), context.getStatementId(), context.getEventAdapterService(), matchEventFromChildNodes.getTaggedEventTypes(), matchEventFromChildNodes.getArrayEventTypes(), subexpressionIdStack, "every-distinct", context);
                ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, context.getEngineImportService(), context.getStatementExtensionServicesContext(), null, context.getSchedulingService(), context.getVariableService(), context.getTableService(), evaluatorContext, context.getEventAdapterService(), context.getStatementName(), context.getStatementId(), context.getAnnotations(), context.getContextDescriptor(), false, false, false, false, null, false);
                try {
                    validated = PatternStreamSpecRaw.validateExpressions(ExprNodeOrigin.PATTERNEVERYDISTINCT, distinctNode.getExpressions(), validationContext);
                }
                catch (ExprValidationPropertyException ex) {
                    throw new ExprValidationPropertyException(ex.getMessage() + ", every-distinct requires that all properties resolve from sub-expressions to the every-distinct", ex.getCause());
                }
                MatchedEventConvertorImpl convertor = new MatchedEventConvertorImpl(matchEventFromChildNodes.getTaggedEventTypes(), matchEventFromChildNodes.getArrayEventTypes(), allTagNamesOrdered, context.getEventAdapterService());
                distinctNode.setConvertor(convertor);
                ArrayList<ExprNode> distinctExpressions = new ArrayList<ExprNode>();
                ExprTimePeriodEvalDeltaConst timeDeltaComputation = null;
                ExprNode expiryTimeExp = null;
                int count = -1;
                int last = validated.size() - 1;
                for (ExprNode expr : validated) {
                    if (++count == last && expr instanceof ExprTimePeriod) {
                        expiryTimeExp = expr;
                        ExprTimePeriod timePeriodExpr = (ExprTimePeriod)expiryTimeExp;
                        timeDeltaComputation = timePeriodExpr.constEvaluator(new ExprEvaluatorContextStatement(context, false));
                        continue;
                    }
                    if (expr.isConstantResult()) {
                        if (count == last) {
                            Object value = expr.getExprEvaluator().evaluate(null, true, evaluatorContext);
                            if (!(value instanceof Number)) {
                                throw new ExprValidationException("Invalid parameter for every-distinct, expected number of seconds constant (constant not considered for distinct)");
                            }
                            Double secondsExpire = ((Number)expr.getExprEvaluator().evaluate(null, true, evaluatorContext)).doubleValue();
                            if (secondsExpire == null || !(secondsExpire > 0.0)) continue;
                            timeDeltaComputation = new ExprTimePeriodEvalDeltaConstMsec(Math.round(1000.0 * secondsExpire));
                            expiryTimeExp = expr;
                            continue;
                        }
                        log.warn((Object)("Every-distinct node utilizes an expression returning a constant value, please check expression '" + ExprNodeUtility.toExpressionStringMinPrecedenceSafe(expr) + "', not adding expression to distinct-value expression list"));
                        continue;
                    }
                    distinctExpressions.add(expr);
                }
                if (distinctExpressions.isEmpty()) {
                    throw new ExprValidationException("Every-distinct node requires one or more distinct-value expressions that each return non-constant result values");
                }
                distinctNode.setDistinctExpressions(distinctExpressions, timeDeltaComputation, expiryTimeExp);
            } else if (evalNode instanceof EvalMatchUntilFactoryNode) {
                EvalMatchUntilFactoryNode matchUntilNode = (EvalMatchUntilFactoryNode)evalNode;
                MatchEventSpec untilMatchEventSpec = new MatchEventSpec(tags.getTaggedEventTypes(), tags.getArrayEventTypes());
                StreamTypeService streamTypeService = PatternStreamSpecRaw.getStreamTypeService(context.getEngineURI(), context.getStatementId(), context.getEventAdapterService(), untilMatchEventSpec.getTaggedEventTypes(), untilMatchEventSpec.getArrayEventTypes(), subexpressionIdStack, "until", context);
                ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, context.getEngineImportService(), context.getStatementExtensionServicesContext(), null, context.getSchedulingService(), context.getVariableService(), context.getTableService(), evaluatorContext, context.getEventAdapterService(), context.getStatementName(), context.getStatementId(), context.getAnnotations(), context.getContextDescriptor(), false, false, false, false, null, false);
                ExprNode lower = PatternStreamSpecRaw.validateBounds(matchUntilNode.getLowerBounds(), validationContext);
                matchUntilNode.setLowerBounds(lower);
                ExprNode upper = PatternStreamSpecRaw.validateBounds(matchUntilNode.getUpperBounds(), validationContext);
                matchUntilNode.setUpperBounds(upper);
                ExprNode single = PatternStreamSpecRaw.validateBounds(matchUntilNode.getSingleBound(), validationContext);
                matchUntilNode.setSingleBound(single);
                MatchedEventConvertorImpl convertor = new MatchedEventConvertorImpl(untilMatchEventSpec.getTaggedEventTypes(), untilMatchEventSpec.getArrayEventTypes(), allTagNamesOrdered, context.getEventAdapterService());
                matchUntilNode.setConvertor(convertor);
                HashSet<String> arrayTags = null;
                EvalNodeAnalysisResult matchUntilAnalysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(matchUntilNode.getChildNodes().get(0));
                for (EvalFilterFactoryNode filterNode : matchUntilAnalysisResult.getFilterNodes()) {
                    String optionalTag = filterNode.getEventAsName();
                    if (optionalTag == null) continue;
                    if (arrayTags == null) {
                        arrayTags = new HashSet<String>();
                    }
                    arrayTags.add(optionalTag);
                }
                if (arrayTags != null) {
                    for (String arrayTag : arrayTags) {
                        if (tags.getArrayEventTypes().containsKey(arrayTag)) continue;
                        tags.getArrayEventTypes().put(arrayTag, tags.getTaggedEventTypes().get(arrayTag));
                        tags.getTaggedEventTypes().remove(arrayTag);
                    }
                }
                matchUntilNode.setTagsArrayedSet(PatternStreamSpecRaw.getIndexesForTags(allTagNamesOrdered, (Set<String>)arrayTags));
            } else if (evalNode instanceof EvalFollowedByFactoryNode) {
                EvalFollowedByFactoryNode followedByNode = (EvalFollowedByFactoryNode)evalNode;
                StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(context.getEngineURI(), false);
                ExprValidationContext validationContext = new ExprValidationContext(streamTypeService, context.getEngineImportService(), context.getStatementExtensionServicesContext(), null, context.getSchedulingService(), context.getVariableService(), context.getTableService(), evaluatorContext, context.getEventAdapterService(), context.getStatementName(), context.getStatementId(), context.getAnnotations(), context.getContextDescriptor(), false, false, false, false, null, false);
                if (followedByNode.getOptionalMaxExpressions() != null) {
                    ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
                    for (ExprNode maxExpr : followedByNode.getOptionalMaxExpressions()) {
                        if (maxExpr == null) {
                            validated.add(null);
                            continue;
                        }
                        ExprNodeSummaryVisitor visitor = new ExprNodeSummaryVisitor();
                        maxExpr.accept(visitor);
                        if (!visitor.isPlain()) {
                            String errorMessage = "Invalid maximum expression in followed-by, " + visitor.getMessage() + " are not allowed within the expression";
                            log.error((Object)errorMessage);
                            throw new ExprValidationException(errorMessage);
                        }
                        ExprNode validatedExpr = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.FOLLOWEDBYMAX, maxExpr, validationContext);
                        validated.add(validatedExpr);
                        if (validatedExpr.getExprEvaluator().getType() != null && JavaClassHelper.isNumeric(validatedExpr.getExprEvaluator().getType())) continue;
                        String message = "Invalid maximum expression in followed-by, the expression must return an integer value";
                        throw new ExprValidationException(message);
                    }
                    followedByNode.setOptionalMaxExpressions(validated);
                }
            }
        }
        if (newTaggedEventTypes != null) {
            tags.getTaggedEventTypes().putAll(newTaggedEventTypes);
        }
        if (newArrayEventTypes != null) {
            tags.getArrayEventTypes().putAll(newArrayEventTypes);
        }
    }

    private static ExprNode validateBounds(ExprNode bounds, ExprValidationContext validationContext) throws ExprValidationException {
        String message = "Match-until bounds value expressions must return a numeric value";
        if (bounds != null) {
            ExprNode validated = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.PATTERNMATCHUNTILBOUNDS, bounds, validationContext);
            if (validated.getExprEvaluator().getType() == null || !JavaClassHelper.isNumeric(validated.getExprEvaluator().getType())) {
                throw new ExprValidationException(message);
            }
            return validated;
        }
        return null;
    }

    private static int[] getIndexesForTags(LinkedHashSet<String> allTagNamesOrdered, Set<String> arrayTags) {
        if (arrayTags == null || arrayTags.isEmpty()) {
            return new int[0];
        }
        int[] indexes = new int[arrayTags.size()];
        int count = 0;
        for (String arrayTag : arrayTags) {
            int found;
            boolean index = false;
            indexes[count] = found = PatternStreamSpecRaw.findTagNumber(arrayTag, allTagNamesOrdered);
            ++count;
        }
        return indexes;
    }

    private static int findTagNumber(String findTag, LinkedHashSet<String> allTagNamesOrdered) {
        int index = 0;
        for (String tag : allTagNamesOrdered) {
            if (findTag.equals(tag)) {
                return index;
            }
            ++index;
        }
        throw new EPException("Failed to find tag '" + findTag + "' among known tags");
    }

    private static boolean isParentMatchUntil(EvalFactoryNode currentNode, Stack<EvalFactoryNode> parentNodeStack) {
        if (parentNodeStack.isEmpty()) {
            return false;
        }
        for (EvalFactoryNode deepParent : parentNodeStack) {
            EvalMatchUntilFactoryNode matchUntilFactoryNode;
            if (!(deepParent instanceof EvalMatchUntilFactoryNode) || (matchUntilFactoryNode = (EvalMatchUntilFactoryNode)deepParent).getChildNodes().get(0) != currentNode) continue;
            return true;
        }
        return false;
    }

    private static List<ExprNode> validateExpressions(ExprNodeOrigin exprNodeOrigin, List<ExprNode> objectParameters, ExprValidationContext validationContext) throws ExprValidationException {
        if (objectParameters == null) {
            return objectParameters;
        }
        ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
        for (ExprNode node : objectParameters) {
            validated.add(ExprNodeUtility.getValidatedSubtree(exprNodeOrigin, node, validationContext));
        }
        return validated;
    }

    private static StreamTypeService getStreamTypeService(String engineURI, int statementId, EventAdapterService eventAdapterService, Map<String, Pair<EventType, String>> taggedEventTypes, Map<String, Pair<EventType, String>> arrayEventTypes, Deque<Integer> subexpressionIdStack, String objectType, StatementContext statementContext) {
        LinkedHashMap<String, Pair<EventType, String>> filterTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        filterTypes.putAll(taggedEventTypes);
        if (arrayEventTypes != null) {
            String patternSubexEventType = PatternStreamSpecRaw.getPatternSubexEventType(statementId, objectType, subexpressionIdStack);
            EventType arrayTagCompositeEventType = eventAdapterService.createSemiAnonymousMapType(patternSubexEventType, new HashMap<String, Pair<EventType, String>>(), arrayEventTypes, false);
            statementContext.getStatementSemiAnonymousTypeRegistry().register(arrayTagCompositeEventType);
            for (Map.Entry<String, Pair<EventType, String>> entry : arrayEventTypes.entrySet()) {
                String tag = entry.getKey();
                if (filterTypes.containsKey(tag)) continue;
                Pair<EventType, String> pair = new Pair<EventType, String>(arrayTagCompositeEventType, tag);
                filterTypes.put(tag, pair);
            }
        }
        return new StreamTypeServiceImpl(filterTypes, engineURI, true, false);
    }

    private static String getPatternSubexEventType(int statementId, String objectType, Deque<Integer> subexpressionIdStack) {
        StringWriter writer = new StringWriter();
        writer.append(Integer.toString(statementId));
        writer.append("_");
        writer.append(objectType);
        for (Integer num : subexpressionIdStack) {
            writer.append("_");
            writer.append(Integer.toString(num));
        }
        return writer.toString();
    }

    private static EvalFactoryNode recursiveAddAuditNode(PatternNodeFactory patternNodeFactory, EvalFactoryNode parentNode, boolean auditPattern, boolean auditPatternInstance, EvalFactoryNode evalNode, EvalAuditInstanceCount instanceCount) {
        StringWriter writer = new StringWriter();
        evalNode.toEPL(writer, PatternExpressionPrecedenceEnum.MINIMUM);
        String expressionText = writer.toString();
        boolean filterChildNonQuitting = parentNode != null && parentNode.isFilterChildNonQuitting();
        EvalFactoryNode audit = patternNodeFactory.makeAuditNode(auditPattern, auditPatternInstance, expressionText, instanceCount, filterChildNonQuitting);
        audit.addChildNode(evalNode);
        ArrayList<EvalFactoryNode> newChildNodes = new ArrayList<EvalFactoryNode>();
        for (EvalFactoryNode child : evalNode.getChildNodes()) {
            newChildNodes.add(PatternStreamSpecRaw.recursiveAddAuditNode(patternNodeFactory, evalNode, auditPattern, auditPatternInstance, child, instanceCount));
        }
        evalNode.getChildNodes().clear();
        evalNode.addChildNodes(newChildNodes);
        return audit;
    }

    private static MatchEventSpec analyzeMatchEvent(EvalFactoryNode relativeNode) {
        LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(relativeNode);
        for (EvalFilterFactoryNode filterNode : evalNodeAnalysisResult.getFilterNodes()) {
            String optionalTag = filterNode.getEventAsName();
            if (optionalTag == null) continue;
            taggedEventTypes.put(optionalTag, new Pair<EventType, String>(filterNode.getFilterSpec().getFilterForEventType(), filterNode.getFilterSpec().getFilterForEventTypeName()));
        }
        HashSet<String> arrayTags = new HashSet<String>();
        for (EvalMatchUntilFactoryNode matchUntilNode : evalNodeAnalysisResult.getRepeatNodes()) {
            EvalNodeAnalysisResult matchUntilAnalysisResult = EvalNodeUtil.recursiveAnalyzeChildNodes(matchUntilNode.getChildNodes().get(0));
            for (EvalFilterFactoryNode filterNode : matchUntilAnalysisResult.getFilterNodes()) {
                String optionalTag = filterNode.getEventAsName();
                if (optionalTag == null) continue;
                arrayTags.add(optionalTag);
            }
        }
        for (String arrayTag : arrayTags) {
            if (taggedEventTypes.get(arrayTag) == null) continue;
            arrayEventTypes.put(arrayTag, taggedEventTypes.get(arrayTag));
            taggedEventTypes.remove(arrayTag);
        }
        return new MatchEventSpec(taggedEventTypes, arrayEventTypes);
    }

    public boolean isSuppressSameEventMatches() {
        return this.suppressSameEventMatches;
    }

    public boolean isDiscardPartialsOnMatch() {
        return this.discardPartialsOnMatch;
    }

    public static class FilterForFilterFactoryNodes
    implements EvalNodeUtilFactoryFilter {
        public static final FilterForFilterFactoryNodes INSTANCE = new FilterForFilterFactoryNodes();

        @Override
        public boolean consider(EvalFactoryNode node) {
            return node instanceof EvalFilterFactoryNode;
        }
    }
}

