/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.updatehelper;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.updatehelper.EventBeanUpdateItem;
import com.espertech.esper.event.EventBeanCopyMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventBeanUpdateHelper {
    private static final Log log = LogFactory.getLog(EventBeanUpdateHelper.class);
    private final EventBeanCopyMethod copyMethod;
    private final EventBeanUpdateItem[] updateItems;

    public EventBeanUpdateHelper(EventBeanCopyMethod copyMethod, EventBeanUpdateItem[] updateItems) {
        this.copyMethod = copyMethod;
        this.updateItems = updateItems;
    }

    public EventBean updateWCopy(EventBean matchingEvent, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean copy;
        eventsPerStream[0] = copy = this.copyMethod.copy(matchingEvent);
        eventsPerStream[2] = matchingEvent;
        this.updateInternal(eventsPerStream, exprEvaluatorContext, copy);
        return copy;
    }

    public void updateNoCopy(EventBean matchingEvent, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        this.updateInternal(eventsPerStream, exprEvaluatorContext, matchingEvent);
    }

    public EventBeanUpdateItem[] getUpdateItems() {
        return this.updateItems;
    }

    public boolean isRequiresStream2InitialValueEvent() {
        return this.copyMethod != null;
    }

    private void updateInternal(EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext, EventBean target) {
        for (int i = 0; i < this.updateItems.length; ++i) {
            EventBeanUpdateItem updateItem = this.updateItems[i];
            Object result = updateItem.getExpression().evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (updateItem.getOptionalWriter() == null) continue;
            if (result == null && updateItem.isNotNullableField()) {
                log.warn((Object)("Null value returned by expression for assignment to property '" + updateItem.getOptionalPropertyName() + " is ignored as the property type is not nullable for expression"));
                continue;
            }
            if (updateItem.getOptionalWidener() != null) {
                result = updateItem.getOptionalWidener().widen(result);
            }
            updateItem.getOptionalWriter().write(result, target);
        }
    }
}

