/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.VariableValueException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.epl.variable.VariableServiceUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VariableReadWritePackage {
    private static final Log log = LogFactory.getLog(VariableReadWritePackage.class);
    private final VariableTriggerSetDesc[] assignments;
    private final VariableMetaData[] metaData;
    private final VariableReader[] readersForGlobalVars;
    private final boolean[] mustCoerce;
    private final WriteDesc[] writers;
    private final Map<EventTypeSPI, EventBeanCopyMethod> copyMethods;
    private final EventAdapterService eventAdapterService;
    private final Map<String, Object> variableTypes;
    private final VariableService variableService;

    public VariableReadWritePackage(List<OnTriggerSetAssignment> assignments, VariableService variableService, EventAdapterService eventAdapterService) throws ExprValidationException {
        this.metaData = new VariableMetaData[assignments.size()];
        this.readersForGlobalVars = new VariableReader[assignments.size()];
        this.mustCoerce = new boolean[assignments.size()];
        this.writers = new WriteDesc[assignments.size()];
        this.variableTypes = new HashMap<String, Object>();
        this.eventAdapterService = eventAdapterService;
        this.variableService = variableService;
        HashMap<EventTypeSPI, CopyMethodDesc> eventTypeWrittenProps = new HashMap<EventTypeSPI, CopyMethodDesc>();
        int count = 0;
        ArrayList<VariableTriggerSetDesc> assignmentList = new ArrayList<VariableTriggerSetDesc>();
        for (OnTriggerSetAssignment onTriggerSetAssignment : assignments) {
            VariableMetaData variableMetadata;
            String fullVariableName;
            Pair<String, ExprNode> possibleVariableAssignment = ExprNodeUtility.checkGetAssignmentToVariableOrProp(onTriggerSetAssignment.getExpression());
            if (possibleVariableAssignment == null) {
                throw new ExprValidationException("Missing variable assignment expression in assignment number " + count);
            }
            assignmentList.add(new VariableTriggerSetDesc(possibleVariableAssignment.getFirst(), possibleVariableAssignment.getSecond().getExprEvaluator()));
            String variableName = fullVariableName = possibleVariableAssignment.getFirst();
            String subPropertyName = null;
            int indexOfDot = variableName.indexOf(46);
            if (indexOfDot != -1) {
                subPropertyName = variableName.substring(indexOfDot + 1, variableName.length());
                variableName = variableName.substring(0, indexOfDot);
            }
            this.metaData[count] = variableMetadata = variableService.getVariableMetaData(variableName);
            if (variableMetadata == null) {
                throw new ExprValidationException("Variable by name '" + variableName + "' has not been created or configured");
            }
            if (variableMetadata.isConstant()) {
                throw new ExprValidationException("Variable by name '" + variableName + "' is declared constant and may not be set");
            }
            if (variableMetadata.getContextPartitionName() == null) {
                this.readersForGlobalVars[count] = variableService.getReader(variableName, -1);
            }
            if (subPropertyName != null) {
                if (variableMetadata.getEventType() == null) {
                    throw new ExprValidationException("Variable by name '" + variableName + "' does not have a property named '" + subPropertyName + "'");
                }
                EventType type = variableMetadata.getEventType();
                if (!(type instanceof EventTypeSPI)) {
                    throw new ExprValidationException("Variable by name '" + variableName + "' event type '" + type.getName() + "' not writable");
                }
                EventTypeSPI spi = (EventTypeSPI)type;
                EventPropertyWriter writer = spi.getWriter(subPropertyName);
                EventPropertyGetter getter = spi.getGetter(subPropertyName);
                if (writer == null) {
                    throw new ExprValidationException("Variable by name '" + variableName + "' the property '" + subPropertyName + "' is not writable");
                }
                this.variableTypes.put(fullVariableName, spi.getPropertyType(subPropertyName));
                CopyMethodDesc writtenProps = (CopyMethodDesc)eventTypeWrittenProps.get(spi);
                if (writtenProps == null) {
                    writtenProps = new CopyMethodDesc(variableName, new ArrayList<String>());
                    eventTypeWrittenProps.put(spi, writtenProps);
                }
                writtenProps.getPropertiesCopied().add(subPropertyName);
                this.writers[count] = new WriteDesc(spi, variableName, writer, getter);
            } else {
                Class expressionType = possibleVariableAssignment.getSecond().getExprEvaluator().getType();
                if (variableMetadata.getEventType() != null) {
                    if (expressionType != null && !JavaClassHelper.isSubclassOrImplementsInterface(expressionType, variableMetadata.getEventType().getUnderlyingType())) {
                        throw new VariableValueException("Variable '" + variableName + "' of declared event type '" + variableMetadata.getEventType().getName() + "' underlying type '" + variableMetadata.getEventType().getUnderlyingType().getName() + "' cannot be assigned a value of type '" + expressionType.getName() + "'");
                    }
                    this.variableTypes.put(variableName, variableMetadata.getEventType().getUnderlyingType());
                } else {
                    Class variableType = variableMetadata.getType();
                    this.variableTypes.put(variableName, variableType);
                    if (variableType != Object.class && JavaClassHelper.getBoxedType(expressionType) != variableType && expressionType != null) {
                        if (!JavaClassHelper.isNumeric(variableType) || !JavaClassHelper.isNumeric(expressionType)) {
                            throw new ExprValidationException(VariableServiceUtil.getAssigmentExMessage(variableName, variableType, expressionType));
                        }
                        if (!JavaClassHelper.canCoerce(expressionType, variableType)) {
                            throw new ExprValidationException(VariableServiceUtil.getAssigmentExMessage(variableName, variableType, expressionType));
                        }
                        this.mustCoerce[count] = true;
                    }
                }
            }
            ++count;
        }
        this.assignments = assignmentList.toArray(new VariableTriggerSetDesc[assignmentList.size()]);
        if (eventTypeWrittenProps.isEmpty()) {
            this.copyMethods = Collections.EMPTY_MAP;
            return;
        }
        this.copyMethods = new HashMap<EventTypeSPI, EventBeanCopyMethod>();
        for (Map.Entry entry : eventTypeWrittenProps.entrySet()) {
            List<String> propsWritten = ((CopyMethodDesc)entry.getValue()).getPropertiesCopied();
            String[] props = propsWritten.toArray(new String[propsWritten.size()]);
            EventBeanCopyMethod copyMethod = ((EventTypeSPI)entry.getKey()).getCopyMethod(props);
            if (copyMethod == null) {
                throw new ExprValidationException("Variable '" + ((CopyMethodDesc)entry.getValue()).getVariableName() + "' of declared type " + JavaClassHelper.getClassNameFullyQualPretty(((EventTypeSPI)entry.getKey()).getUnderlyingType()) + "' cannot be assigned to");
            }
            this.copyMethods.put((EventTypeSPI)entry.getKey(), copyMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeVariables(VariableService variableService, EventBean[] eventsPerStream, Map<String, Object> valuesWritten, ExprEvaluatorContext exprEvaluatorContext) {
        HashSet<String> variablesBeansCopied = null;
        if (!this.copyMethods.isEmpty()) {
            variablesBeansCopied = new HashSet<String>();
        }
        variableService.getReadWriteLock().writeLock().lock();
        try {
            variableService.setLocalVersion();
            int count = 0;
            for (VariableTriggerSetDesc assignment : this.assignments) {
                VariableMetaData variableMetaData = this.metaData[count];
                int agentInstanceId = variableMetaData.getContextPartitionName() == null ? -1 : exprEvaluatorContext.getAgentInstanceId();
                Object value = assignment.evaluator.evaluate(eventsPerStream, true, exprEvaluatorContext);
                if (this.writers[count] != null) {
                    VariableReader reader = variableService.getReader(variableMetaData.getVariableName(), exprEvaluatorContext.getAgentInstanceId());
                    EventBean current = (EventBean)reader.getValue();
                    if (current == null) {
                        value = null;
                    } else {
                        WriteDesc writeDesc = this.writers[count];
                        boolean copy = variablesBeansCopied.add(writeDesc.getVariableName());
                        if (copy) {
                            EventBean copied;
                            current = copied = this.copyMethods.get(writeDesc.getType()).copy(current);
                        }
                        variableService.write(variableMetaData.getVariableNumber(), agentInstanceId, current);
                        writeDesc.getWriter().write(value, current);
                    }
                } else if (variableMetaData.getEventType() != null) {
                    EventBean eventBean = this.eventAdapterService.adapterForType(value, variableMetaData.getEventType());
                    variableService.write(variableMetaData.getVariableNumber(), agentInstanceId, eventBean);
                } else {
                    if (value != null && this.mustCoerce[count]) {
                        value = JavaClassHelper.coerceBoxed((Number)value, variableMetaData.getType());
                    }
                    variableService.write(variableMetaData.getVariableNumber(), agentInstanceId, value);
                }
                ++count;
                if (valuesWritten == null) continue;
                valuesWritten.put(assignment.variableName, value);
            }
            variableService.commit();
        }
        catch (RuntimeException ex) {
            log.error((Object)("Error evaluating on-set variable expressions: " + ex.getMessage()), (Throwable)ex);
            variableService.rollback();
        }
        finally {
            variableService.getReadWriteLock().writeLock().unlock();
        }
    }

    public Map<String, Object> getVariableTypes() {
        return this.variableTypes;
    }

    public Map<String, Object> iterate(int agentInstanceId) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        int count = 0;
        for (VariableTriggerSetDesc assignment : this.assignments) {
            Object value;
            if (this.readersForGlobalVars[count] == null) {
                VariableReader reader = this.variableService.getReader(assignment.variableName, agentInstanceId);
                if (reader == null) continue;
                value = reader.getValue();
            } else {
                value = this.readersForGlobalVars[count].getValue();
            }
            if (value == null) {
                values.put(assignment.variableName, null);
            } else if (this.writers[count] != null) {
                EventBean current = (EventBean)value;
                values.put(assignment.variableName, this.writers[count].getGetter().get(current));
            } else if (value instanceof EventBean) {
                values.put(assignment.variableName, ((EventBean)value).getUnderlying());
            } else {
                values.put(assignment.variableName, value);
            }
            ++count;
        }
        return values;
    }

    private static class VariableTriggerSetDesc {
        private String variableName;
        private ExprEvaluator evaluator;

        public VariableTriggerSetDesc(String variableName, ExprEvaluator evaluator) {
            this.variableName = variableName;
            this.evaluator = evaluator;
        }
    }

    private static class WriteDesc {
        private final EventTypeSPI type;
        private final String variableName;
        private final EventPropertyWriter writer;
        private final EventPropertyGetter getter;

        public WriteDesc(EventTypeSPI type, String variableName, EventPropertyWriter writer, EventPropertyGetter getter) {
            this.type = type;
            this.variableName = variableName;
            this.writer = writer;
            this.getter = getter;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public EventPropertyWriter getWriter() {
            return this.writer;
        }

        public EventTypeSPI getType() {
            return this.type;
        }

        public EventPropertyGetter getGetter() {
            return this.getter;
        }
    }

    private static class CopyMethodDesc {
        private final String variableName;
        private final List<String> propertiesCopied;

        public CopyMethodDesc(String variableName, List<String> propertiesCopied) {
            this.variableName = variableName;
            this.propertiesCopied = propertiesCopied;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public List<String> getPropertiesCopied() {
            return this.propertiesCopied;
        }
    }
}

