/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledCountFactory;
import com.espertech.esper.epl.view.OutputConditionPolledCountState;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class OutputConditionPolledCount
implements OutputConditionPolled {
    private final OutputConditionPolledCountFactory factory;
    private final OutputConditionPolledCountState state;
    private final VariableReader optionalVariableReader;
    private static final Log log = LogFactory.getLog(OutputConditionPolledCount.class);

    public OutputConditionPolledCount(OutputConditionPolledCountFactory factory, OutputConditionPolledCountState state, VariableReader optionalVariableReader) {
        this.factory = factory;
        this.state = state;
        this.optionalVariableReader = optionalVariableReader;
    }

    @Override
    public OutputConditionPolledCountState getState() {
        return this.state;
    }

    @Override
    public final boolean updateOutputCondition(int newDataCount, int oldDataCount) {
        Object value;
        if (this.optionalVariableReader != null && (value = this.optionalVariableReader.getValue()) != null) {
            this.state.setEventRate(((Number)value).longValue());
        }
        this.state.setNewEventsCount(this.state.getNewEventsCount() + newDataCount);
        this.state.setOldEventsCount(this.state.getOldEventsCount() + oldDataCount);
        if (this.isSatisfied() || this.state.isFirst()) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug((Object)".updateOutputCondition() condition satisfied");
            }
            this.state.setIsFirst(false);
            this.state.setNewEventsCount(0);
            this.state.setOldEventsCount(0);
            return true;
        }
        return false;
    }

    private boolean isSatisfied() {
        return (long)this.state.getNewEventsCount() >= this.state.getEventRate() || (long)this.state.getOldEventsCount() >= this.state.getEventRate();
    }
}

