/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.UpdateDispatchView;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorHelperFactory;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.epl.view.OutputProcessViewConditionDeltaSet;
import com.espertech.esper.epl.view.OutputProcessViewDirectDistinctOrAfterFactory;
import com.espertech.esper.epl.view.OutputStrategyUtil;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputProcessViewDirectDistinctOrAfter
extends OutputProcessViewBaseWAfter {
    private static final Log log = LogFactory.getLog(OutputProcessViewDirectDistinctOrAfter.class);
    private final OutputProcessViewDirectDistinctOrAfterFactory parent;

    public OutputProcessViewDirectDistinctOrAfter(ResultSetProcessorHelperFactory resultSetProcessorHelperFactory, AgentInstanceContext agentInstanceContext, ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewDirectDistinctOrAfterFactory parent) {
        super(resultSetProcessorHelperFactory, agentInstanceContext, resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
    }

    @Override
    public int getNumChangesetRows() {
        return 0;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return null;
    }

    @Override
    public OutputProcessViewConditionDeltaSet getOptionalDeltaSet() {
        return null;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length)));
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processViewResult(newData, oldData, isGenerateSynthetic);
        if (!super.checkAfterCondition(newOldEvents, this.parent.getStatementContext())) {
            return;
        }
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getEventBeanReader()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getEventBeanReader()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
            }
            return;
        }
        boolean forceOutput = false;
        if (newData == null && oldData == null && (newOldEvents == null || newOldEvents.getFirst() == null && newOldEvents.getSecond() == null)) {
            forceOutput = true;
        }
        if (this.childView != null) {
            this.postProcess(forceOutput, newOldEvents, this.childView);
        }
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size())));
        }
        boolean isGenerateSynthetic = this.parent.getStatementResultService().isMakeSynthetic();
        boolean isGenerateNatural = this.parent.getStatementResultService().isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processJoinResult(newEvents, oldEvents, isGenerateSynthetic);
        if (!this.checkAfterCondition(newOldEvents, this.parent.getStatementContext())) {
            return;
        }
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getEventBeanReader()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getEventBeanReader()));
        }
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                OutputStrategyUtil.indicateEarlyReturn(this.parent.getStatementContext(), newOldEvents);
            }
            return;
        }
        if (newOldEvents == null) {
            return;
        }
        if (this.childView != null) {
            this.postProcess(false, newOldEvents, this.childView);
        }
    }

    protected void postProcess(boolean force, UniformPair<EventBean[]> newOldEvents, UpdateDispatchView childView) {
        OutputStrategyUtil.output(force, newOldEvents, childView);
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct());
    }

    @Override
    public void terminated() {
    }
}

