/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventBeanFactory;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.event.BaseConfigurableEventType;
import com.espertech.esper.event.BaseNestableEventType;
import com.espertech.esper.event.DecoratingEventBean;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanAdapterFactory;
import com.espertech.esper.event.EventBeanFactoryBean;
import com.espertech.esper.event.EventBeanFactoryBeanWrapped;
import com.espertech.esper.event.EventBeanFactoryMap;
import com.espertech.esper.event.EventBeanFactoryObjectArray;
import com.espertech.esper.event.EventBeanFactoryXML;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventBeanManufacturerMap;
import com.espertech.esper.event.EventBeanManufacturerObjectArray;
import com.espertech.esper.event.EventBeanSPI;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.event.bean.BeanEventBean;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.EventBeanManufacturerBean;
import com.espertech.esper.event.bean.PropertyHelper;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.XMLEventBean;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class EventAdapterServiceHelper {
    public static String getMessageExpecting(String eventTypeName, EventType existingType, String typeOfEventType) {
        String message = "Event type named '" + eventTypeName + "' has not been defined or is not a " + typeOfEventType + " event type";
        message = existingType != null ? message + ", the name '" + eventTypeName + "' refers to a " + JavaClassHelper.getClassNameFullyQualPretty(existingType.getUnderlyingType()) + " event type" : message + ", the name '" + eventTypeName + "' has not been defined as an event type";
        return message;
    }

    public static EventBeanFactory getFactoryForType(EventType type, EventAdapterService eventAdapterService) {
        WrapperEventType wrapperType;
        if (type instanceof WrapperEventType && (wrapperType = (WrapperEventType)type).getUnderlyingEventType() instanceof BeanEventType) {
            return new EventBeanFactoryBeanWrapped(wrapperType.getUnderlyingEventType(), wrapperType, eventAdapterService);
        }
        if (type instanceof BeanEventType) {
            return new EventBeanFactoryBean(type, eventAdapterService);
        }
        if (type instanceof MapEventType) {
            return new EventBeanFactoryMap(type, eventAdapterService);
        }
        if (type instanceof ObjectArrayEventType) {
            return new EventBeanFactoryObjectArray(type, eventAdapterService);
        }
        if (type instanceof BaseXMLEventType) {
            return new EventBeanFactoryXML(type, eventAdapterService);
        }
        throw new IllegalArgumentException("Cannot create event bean factory for event type '" + type.getName() + "': " + type.getClass().getName() + " is not a recognized event type or supported wrap event type");
    }

    public static Set<WriteablePropertyDescriptor> getWriteableProperties(EventType eventType, boolean allowAnyType) {
        if (!(eventType instanceof EventTypeSPI)) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            BeanEventType beanEventType = (BeanEventType)eventType;
            return PropertyHelper.getWritableProperties(beanEventType.getUnderlyingType());
        }
        EventTypeSPI typeSPI = (EventTypeSPI)eventType;
        if (!allowAnyType && !EventAdapterServiceHelper.allowPropulate(typeSPI)) {
            return null;
        }
        if (eventType instanceof BaseNestableEventType) {
            Map<String, Object> mapdef = ((BaseNestableEventType)eventType).getTypes();
            LinkedHashSet<WriteablePropertyDescriptor> writables = new LinkedHashSet<WriteablePropertyDescriptor>();
            for (Map.Entry<String, Object> types : mapdef.entrySet()) {
                String typeName;
                Class clazz;
                if (types.getValue() instanceof Class) {
                    writables.add(new WriteablePropertyDescriptor(types.getKey(), (Class)types.getValue(), null));
                }
                if (!(types.getValue() instanceof String) || (clazz = JavaClassHelper.getPrimitiveClassForName(typeName = types.getValue().toString())) == null) continue;
                writables.add(new WriteablePropertyDescriptor(types.getKey(), clazz, null));
            }
            return writables;
        }
        return null;
    }

    private static boolean allowPropulate(EventTypeSPI typeSPI) {
        return typeSPI.getMetadata().isApplicationConfigured() || typeSPI.getMetadata().getTypeClass() == EventTypeMetadata.TypeClass.ANONYMOUS || typeSPI.getMetadata().getTypeClass() == EventTypeMetadata.TypeClass.TABLE;
    }

    public static EventBean adapterForType(Object theEvent, EventType eventType, EventAdapterService eventAdapterService) {
        if (theEvent == null) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            return eventAdapterService.adapterForTypedBean(theEvent, (BeanEventType)eventType);
        }
        if (eventType instanceof MapEventType) {
            return eventAdapterService.adapterForTypedMap((Map)theEvent, eventType);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return eventAdapterService.adapterForTypedObjectArray((Object[])theEvent, eventType);
        }
        if (eventType instanceof BaseConfigurableEventType) {
            return eventAdapterService.adapterForTypedDOM((Node)theEvent, eventType);
        }
        return null;
    }

    public static EventBeanManufacturer getManufacturer(EventAdapterService eventAdapterService, EventType eventType, WriteablePropertyDescriptor[] properties, EngineImportService engineImportService, boolean allowAnyType) throws EventBeanManufactureException {
        if (!(eventType instanceof EventTypeSPI)) {
            return null;
        }
        if (eventType instanceof BeanEventType) {
            BeanEventType beanEventType = (BeanEventType)eventType;
            return new EventBeanManufacturerBean(beanEventType, eventAdapterService, properties, engineImportService);
        }
        EventTypeSPI typeSPI = (EventTypeSPI)eventType;
        if (!allowAnyType && !EventAdapterServiceHelper.allowPropulate(typeSPI)) {
            return null;
        }
        if (eventType instanceof MapEventType) {
            MapEventType mapEventType = (MapEventType)eventType;
            return new EventBeanManufacturerMap(mapEventType, eventAdapterService, properties);
        }
        if (eventType instanceof ObjectArrayEventType) {
            ObjectArrayEventType objectArrayEventType = (ObjectArrayEventType)eventType;
            return new EventBeanManufacturerObjectArray(objectArrayEventType, eventAdapterService, properties);
        }
        return null;
    }

    public static EventBean[] typeCast(List<EventBean> events, EventType targetType, EventAdapterService eventAdapterService) {
        EventBean[] convertedArray = new EventBean[events.size()];
        int count = 0;
        for (EventBean theEvent : events) {
            EventBean converted;
            if (theEvent instanceof DecoratingEventBean) {
                DecoratingEventBean wrapper = (DecoratingEventBean)((Object)theEvent);
                if (targetType instanceof MapEventType) {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.putAll(wrapper.getDecoratingProperties());
                    for (EventPropertyDescriptor propDesc : wrapper.getUnderlyingEvent().getEventType().getPropertyDescriptors()) {
                        props.put(propDesc.getPropertyName(), wrapper.getUnderlyingEvent().get(propDesc.getPropertyName()));
                    }
                    converted = eventAdapterService.adapterForTypedMap(props, targetType);
                } else {
                    converted = eventAdapterService.adapterForTypedWrapper(wrapper.getUnderlyingEvent(), wrapper.getDecoratingProperties(), targetType);
                }
            } else if (theEvent.getEventType() instanceof MapEventType && targetType instanceof MapEventType) {
                MappedEventBean mapEvent = (MappedEventBean)theEvent;
                converted = eventAdapterService.adapterForTypedMap(mapEvent.getProperties(), targetType);
            } else if (theEvent.getEventType() instanceof MapEventType && targetType instanceof WrapperEventType) {
                converted = eventAdapterService.adapterForTypedWrapper(theEvent, Collections.EMPTY_MAP, targetType);
            } else if (theEvent.getEventType() instanceof BeanEventType && targetType instanceof BeanEventType) {
                converted = eventAdapterService.adapterForTypedBean(theEvent.getUnderlying(), targetType);
            } else if (theEvent.getEventType() instanceof ObjectArrayEventType && targetType instanceof ObjectArrayEventType) {
                Object[] convertedObjectArray = ObjectArrayEventType.convertEvent(theEvent, (ObjectArrayEventType)targetType);
                converted = eventAdapterService.adapterForTypedObjectArray(convertedObjectArray, targetType);
            } else {
                throw new EPException("Unknown event type " + theEvent.getEventType());
            }
            convertedArray[count] = converted;
            ++count;
        }
        return convertedArray;
    }

    public static EventBeanSPI getShellForType(EventType eventType) {
        if (eventType instanceof BeanEventType) {
            return new BeanEventBean(null, eventType);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return new ObjectArrayEventBean(null, eventType);
        }
        if (eventType instanceof MapEventType) {
            return new MapEventBean(null, eventType);
        }
        if (eventType instanceof BaseXMLEventType) {
            return new XMLEventBean(null, eventType);
        }
        throw new EventAdapterException("Event type '" + eventType.getName() + "' is not an engine-native event type");
    }

    public static EventBeanAdapterFactory getAdapterFactoryForType(EventType eventType) {
        if (eventType instanceof BeanEventType) {
            return new EventBeanAdapterFactoryBean(eventType);
        }
        if (eventType instanceof ObjectArrayEventType) {
            return new EventBeanAdapterFactoryObjectArray(eventType);
        }
        if (eventType instanceof MapEventType) {
            return new EventBeanAdapterFactoryMap(eventType);
        }
        if (eventType instanceof BaseXMLEventType) {
            return new EventBeanAdapterFactoryXml(eventType);
        }
        throw new EventAdapterException("Event type '" + eventType.getName() + "' is not an engine-native event type");
    }

    public static class EventBeanAdapterFactoryXml
    implements EventBeanAdapterFactory {
        private final EventType eventType;

        public EventBeanAdapterFactoryXml(EventType eventType) {
            this.eventType = eventType;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return new XMLEventBean((Node)underlying, this.eventType);
        }
    }

    public static class EventBeanAdapterFactoryObjectArray
    implements EventBeanAdapterFactory {
        private final EventType eventType;

        public EventBeanAdapterFactoryObjectArray(EventType eventType) {
            this.eventType = eventType;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return new ObjectArrayEventBean((Object[])underlying, this.eventType);
        }
    }

    public static class EventBeanAdapterFactoryMap
    implements EventBeanAdapterFactory {
        private final EventType eventType;

        public EventBeanAdapterFactoryMap(EventType eventType) {
            this.eventType = eventType;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return new MapEventBean((Map)underlying, this.eventType);
        }
    }

    public static class EventBeanAdapterFactoryBean
    implements EventBeanAdapterFactory {
        private final EventType eventType;

        public EventBeanAdapterFactoryBean(EventType eventType) {
            this.eventType = eventType;
        }

        @Override
        public EventBean makeAdapter(Object underlying) {
            return new BeanEventBean(underlying, this.eventType);
        }
    }
}

