/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.arr;

import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.BaseNestableEventType;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeNestableGetterFactory;
import com.espertech.esper.event.arr.EventTypeNestableGetterFactoryObjectArray;
import com.espertech.esper.event.arr.ObjectArrayEventBeanCopyMethod;
import com.espertech.esper.event.arr.ObjectArrayEventBeanCopyMethodWithArrayMap;
import com.espertech.esper.event.arr.ObjectArrayEventBeanPropertyWriter;
import com.espertech.esper.event.arr.ObjectArrayEventBeanPropertyWriterIndexedProp;
import com.espertech.esper.event.arr.ObjectArrayEventBeanPropertyWriterMapProp;
import com.espertech.esper.event.arr.ObjectArrayEventBeanWriterPerProp;
import com.espertech.esper.event.arr.ObjectArrayEventBeanWriterSimpleProps;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ObjectArrayEventType
extends BaseNestableEventType {
    protected Map<String, Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>> propertyWriters;
    protected EventPropertyDescriptor[] writablePropertyDescriptors;

    public ObjectArrayEventType(EventTypeMetadata metadata, String eventTypeName, int eventTypeId, EventAdapterService eventAdapterService, Map<String, Object> properyTypes, ConfigurationEventTypeObjectArray typeDef, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes) {
        super(metadata, eventTypeName, eventTypeId, eventAdapterService, properyTypes, optionalSuperTypes, optionalDeepSupertypes, typeDef, ObjectArrayEventType.getGetterFactory(eventTypeName, properyTypes, optionalSuperTypes));
    }

    @Override
    protected void postUpdateNestableTypes() {
        EventTypeNestableGetterFactoryObjectArray factory = (EventTypeNestableGetterFactoryObjectArray)this.getterFactory;
        Map<String, Integer> indexPerProperty = factory.getPropertiesIndex();
        int index = ObjectArrayEventType.findMax(indexPerProperty) + 1;
        for (Map.Entry entry : this.nestableTypes.entrySet()) {
            if (indexPerProperty.containsKey(entry.getKey())) continue;
            indexPerProperty.put((String)entry.getKey(), index);
            ++index;
        }
    }

    public Map<String, Integer> getPropertiesIndexes() {
        return ((EventTypeNestableGetterFactoryObjectArray)this.getterFactory).getPropertiesIndex();
    }

    @Override
    public final Class getUnderlyingType() {
        return Object[].class;
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        BaseNestableEventUtil.MapIndexedPropPair pair = BaseNestableEventUtil.getIndexedAndMappedProps(properties);
        if (pair.getMapProperties().isEmpty() && pair.getArrayProperties().isEmpty()) {
            return new ObjectArrayEventBeanCopyMethod(this, this.eventAdapterService);
        }
        return new ObjectArrayEventBeanCopyMethodWithArrayMap(this, this.eventAdapterService, pair.getMapProperties(), pair.getArrayProperties(), this.getPropertiesIndexes());
    }

    @Override
    public EventBeanReader getReader() {
        return null;
    }

    @Override
    public ObjectArrayEventBeanPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getSecond();
        }
        Property property = PropertyParser.parseAndWalk(propertyName);
        if (property instanceof MappedProperty) {
            MappedProperty mapProp = (MappedProperty)property;
            Integer index = this.getPropertiesIndexes().get(mapProp.getPropertyNameAtomic());
            if (index == null) {
                return null;
            }
            return new ObjectArrayEventBeanPropertyWriterMapProp(index, mapProp.getKey());
        }
        if (property instanceof IndexedProperty) {
            IndexedProperty indexedProp = (IndexedProperty)property;
            Integer index = this.getPropertiesIndexes().get(indexedProp.getPropertyNameAtomic());
            if (index == null) {
                return null;
            }
            return new ObjectArrayEventBeanPropertyWriterIndexedProp(index, indexedProp.getIndex());
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getFirst();
        }
        Property property = PropertyParser.parseAndWalk(propertyName);
        if (property instanceof MappedProperty) {
            ObjectArrayEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            MappedProperty mapProp = (MappedProperty)property;
            return new EventPropertyDescriptor(mapProp.getPropertyNameAtomic(), Object.class, null, false, true, false, true, false);
        }
        if (property instanceof IndexedProperty) {
            ObjectArrayEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            return new EventPropertyDescriptor(indexedProp.getPropertyNameAtomic(), Object.class, null, true, false, true, false, false);
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        return this.writablePropertyDescriptors;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        boolean allSimpleProps = true;
        ObjectArrayEventBeanPropertyWriter[] writers = new ObjectArrayEventBeanPropertyWriter[properties.length];
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Map<String, Integer> indexesPerProperty = this.getPropertiesIndexes();
        for (int i = 0; i < properties.length; ++i) {
            Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter> writerPair = this.propertyWriters.get(properties[i]);
            if (writerPair != null) {
                writers[i] = writerPair.getSecond();
                indexes.add(indexesPerProperty.get(writerPair.getFirst().getPropertyName()));
                continue;
            }
            writers[i] = this.getWriter(properties[i]);
            if (writers[i] == null) {
                return null;
            }
            allSimpleProps = false;
        }
        if (allSimpleProps) {
            int[] propertyIndexes = CollectionUtil.intArray(indexes);
            return new ObjectArrayEventBeanWriterSimpleProps(propertyIndexes);
        }
        return new ObjectArrayEventBeanWriterPerProp(writers);
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writeableProps = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>> propertWritersMap = new HashMap<String, Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>>();
        for (EventPropertyDescriptor prop : this.propertyDescriptors) {
            writeableProps.add(prop);
            String propertyName = prop.getPropertyName();
            Integer index = this.getPropertiesIndexes().get(prop.getPropertyName());
            if (index == null) continue;
            ObjectArrayEventBeanPropertyWriter eventPropertyWriter = new ObjectArrayEventBeanPropertyWriter(index);
            propertWritersMap.put(propertyName, new Pair<EventPropertyDescriptor, ObjectArrayEventBeanPropertyWriter>(prop, eventPropertyWriter));
        }
        this.propertyWriters = propertWritersMap;
        this.writablePropertyDescriptors = writeableProps.toArray(new EventPropertyDescriptor[writeableProps.size()]);
    }

    private static EventTypeNestableGetterFactory getGetterFactory(String eventTypeName, Map<String, Object> propertyTypes, EventType[] optionalSupertypes) {
        HashMap<String, Integer> indexPerProperty = new HashMap<String, Integer>();
        int index = 0;
        if (optionalSupertypes != null) {
            for (EventType superType : optionalSupertypes) {
                ObjectArrayEventType objectArraySuperType = (ObjectArrayEventType)superType;
                for (String propertyName : objectArraySuperType.getPropertyNames()) {
                    if (indexPerProperty.containsKey(propertyName)) continue;
                    indexPerProperty.put(propertyName, index);
                    ++index;
                }
            }
        }
        for (Map.Entry<String, Object> entry : propertyTypes.entrySet()) {
            indexPerProperty.put(entry.getKey(), index);
            ++index;
        }
        return new EventTypeNestableGetterFactoryObjectArray(eventTypeName, indexPerProperty);
    }

    private static int findMax(Map<String, Integer> indexPerProperty) {
        int max = -1;
        for (Map.Entry<String, Integer> entry : indexPerProperty.entrySet()) {
            if (entry.getValue() <= max) continue;
            max = entry.getValue();
        }
        return max;
    }

    public static Object[] convertEvent(EventBean theEvent, ObjectArrayEventType targetType) {
        Map<String, Integer> indexesTarget = targetType.getPropertiesIndexes();
        Map<String, Integer> indexesSource = ((ObjectArrayEventType)theEvent.getEventType()).getPropertiesIndexes();
        Object[] dataTarget = new Object[indexesTarget.size()];
        Object[] dataSource = (Object[])theEvent.getUnderlying();
        for (Map.Entry<String, Integer> sourceEntry : indexesSource.entrySet()) {
            Object value;
            String propertyName = sourceEntry.getKey();
            Integer targetIndex = indexesTarget.get(propertyName);
            if (targetIndex == null) continue;
            dataTarget[targetIndex.intValue()] = value = dataSource[sourceEntry.getValue()];
        }
        return dataTarget;
    }

    public boolean isDeepEqualsConsiderOrder(ObjectArrayEventType other) {
        EventTypeNestableGetterFactoryObjectArray factoryOther = (EventTypeNestableGetterFactoryObjectArray)other.getterFactory;
        EventTypeNestableGetterFactoryObjectArray factoryMe = (EventTypeNestableGetterFactoryObjectArray)this.getterFactory;
        if (factoryOther.getPropertiesIndex().size() != factoryMe.getPropertiesIndex().size()) {
            return false;
        }
        for (Map.Entry<String, Integer> propMeEntry : factoryMe.getPropertiesIndex().entrySet()) {
            boolean setTwoTypeFound;
            Object setTwoType;
            Object setOneType;
            Integer otherIndex = factoryOther.getPropertiesIndex().get(propMeEntry.getKey());
            if (otherIndex == null || !otherIndex.equals(propMeEntry.getValue())) {
                return false;
            }
            String propName = propMeEntry.getKey();
            String comparedMessage = BaseNestableEventUtil.comparePropType(propName, setOneType = this.nestableTypes.get(propName), setTwoType = other.nestableTypes.get(propName), setTwoTypeFound = other.nestableTypes.containsKey(propName), other.getName());
            if (comparedMessage == null) continue;
            return false;
        }
        return true;
    }
}

