/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.BaseNestableEventType;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeNestableGetterFactory;
import com.espertech.esper.event.map.EventTypeNestableGetterFactoryMap;
import com.espertech.esper.event.map.MapEventBeanCopyMethod;
import com.espertech.esper.event.map.MapEventBeanCopyMethodWithArrayMap;
import com.espertech.esper.event.map.MapEventBeanPropertyWriter;
import com.espertech.esper.event.map.MapEventBeanPropertyWriterIndexedProp;
import com.espertech.esper.event.map.MapEventBeanPropertyWriterMapProp;
import com.espertech.esper.event.map.MapEventBeanReader;
import com.espertech.esper.event.map.MapEventBeanWriterPerProp;
import com.espertech.esper.event.map.MapEventBeanWriterSimpleProps;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapEventType
extends BaseNestableEventType {
    private static final EventTypeNestableGetterFactory GETTER_FACTORY = new EventTypeNestableGetterFactoryMap();
    protected Map<String, Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>> propertyWriters;
    protected EventPropertyDescriptor[] writablePropertyDescriptors;

    public MapEventType(EventTypeMetadata metadata, String typeName, int eventTypeId, EventAdapterService eventAdapterService, Map<String, Object> propertyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes, ConfigurationEventTypeMap configMapType) {
        super(metadata, typeName, eventTypeId, eventAdapterService, propertyTypes, optionalSuperTypes, optionalDeepSupertypes, configMapType, GETTER_FACTORY);
    }

    @Override
    protected void postUpdateNestableTypes() {
    }

    @Override
    public final Class getUnderlyingType() {
        return Map.class;
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        BaseNestableEventUtil.MapIndexedPropPair pair = BaseNestableEventUtil.getIndexedAndMappedProps(properties);
        if (pair.getMapProperties().isEmpty() && pair.getArrayProperties().isEmpty()) {
            return new MapEventBeanCopyMethod(this, this.eventAdapterService);
        }
        return new MapEventBeanCopyMethodWithArrayMap(this, this.eventAdapterService, pair.getMapProperties(), pair.getArrayProperties());
    }

    @Override
    public EventBeanReader getReader() {
        return new MapEventBeanReader(this);
    }

    public Object getValue(String propertyName, Map values) {
        MapEventPropertyGetter getter = (MapEventPropertyGetter)this.getGetter(propertyName);
        return getter.getMap(values);
    }

    @Override
    public MapEventBeanPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getSecond();
        }
        Property property = PropertyParser.parseAndWalk(propertyName);
        if (property instanceof MappedProperty) {
            MappedProperty mapProp = (MappedProperty)property;
            return new MapEventBeanPropertyWriterMapProp(mapProp.getPropertyNameAtomic(), mapProp.getKey());
        }
        if (property instanceof IndexedProperty) {
            IndexedProperty indexedProp = (IndexedProperty)property;
            return new MapEventBeanPropertyWriterIndexedProp(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex());
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) != null) {
            return pair.getFirst();
        }
        Property property = PropertyParser.parseAndWalk(propertyName);
        if (property instanceof MappedProperty) {
            MapEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            MappedProperty mapProp = (MappedProperty)property;
            return new EventPropertyDescriptor(mapProp.getPropertyNameAtomic(), Object.class, null, false, true, false, true, false);
        }
        if (property instanceof IndexedProperty) {
            MapEventBeanPropertyWriter writer = this.getWriter(propertyName);
            if (writer == null) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            return new EventPropertyDescriptor(indexedProp.getPropertyNameAtomic(), Object.class, null, true, false, true, false, false);
        }
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        return this.writablePropertyDescriptors;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        boolean allSimpleProps = true;
        MapEventBeanPropertyWriter[] writers = new MapEventBeanPropertyWriter[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter> writerPair = this.propertyWriters.get(properties[i]);
            if (writerPair != null) {
                writers[i] = writerPair.getSecond();
                continue;
            }
            writers[i] = this.getWriter(properties[i]);
            if (writers[i] == null) {
                return null;
            }
            allSimpleProps = false;
        }
        if (allSimpleProps) {
            return new MapEventBeanWriterSimpleProps(properties);
        }
        return new MapEventBeanWriterPerProp(writers);
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writeableProps = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>> propertWritersMap = new HashMap<String, Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>>();
        for (EventPropertyDescriptor prop : this.propertyDescriptors) {
            writeableProps.add(prop);
            String propertyName = prop.getPropertyName();
            MapEventBeanPropertyWriter eventPropertyWriter = new MapEventBeanPropertyWriter(propertyName);
            propertWritersMap.put(propertyName, new Pair<EventPropertyDescriptor, MapEventBeanPropertyWriter>(prop, eventPropertyWriter));
        }
        this.propertyWriters = propertWritersMap;
        this.writablePropertyDescriptors = writeableProps.toArray(new EventPropertyDescriptor[writeableProps.size()]);
    }
}

