/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.client.EventPropertyGetterMapped;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.vaevent.PropertyUtility;
import com.espertech.esper.event.vaevent.VariantPropResolutionStrategy;
import com.espertech.esper.event.vaevent.VariantPropertyDesc;
import com.espertech.esper.event.vaevent.VariantSpec;
import com.espertech.esper.util.JavaClassHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VariantEventType
implements EventTypeSPI {
    private final EventTypeMetadata metadata;
    private final EventType[] variants;
    private final VariantPropResolutionStrategy propertyResStrategy;
    private final Map<String, VariantPropertyDesc> propertyDesc;
    private final String[] propertyNames;
    private final EventPropertyDescriptor[] propertyDescriptors;
    private final Map<String, EventPropertyDescriptor> propertyDescriptorMap;
    private final int eventTypeId;
    private final ConfigurationVariantStream config;

    public VariantEventType(EventTypeMetadata metadata, int eventTypeId, VariantSpec variantSpec, VariantPropResolutionStrategy propertyResStrategy, ConfigurationVariantStream config) {
        this.metadata = metadata;
        this.eventTypeId = eventTypeId;
        this.variants = variantSpec.getEventTypes();
        this.propertyResStrategy = propertyResStrategy;
        this.config = config;
        this.propertyDesc = new HashMap<String, VariantPropertyDesc>();
        for (EventType type : this.variants) {
            String[] properties = type.getPropertyNames();
            for (String property : properties = PropertyUtility.copyAndSort(properties)) {
                if (this.propertyDesc.containsKey(property)) continue;
                this.findProperty(property);
            }
        }
        Set<String> propertyNameKeySet = this.propertyDesc.keySet();
        this.propertyNames = propertyNameKeySet.toArray(new String[propertyNameKeySet.size()]);
        this.propertyDescriptors = new EventPropertyDescriptor[this.propertyDesc.size()];
        this.propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        int count = 0;
        for (Map.Entry<String, VariantPropertyDesc> desc : this.propertyDesc.entrySet()) {
            Class type = desc.getValue().getPropertyType();
            EventPropertyDescriptor descriptor = new EventPropertyDescriptor(desc.getKey(), type, null, false, false, false, false, JavaClassHelper.isFragmentableType(desc.getValue().getPropertyType()));
            this.propertyDescriptors[count++] = descriptor;
            this.propertyDescriptorMap.put(desc.getKey(), descriptor);
        }
    }

    @Override
    public String getStartTimestampPropertyName() {
        return null;
    }

    @Override
    public String getEndTimestampPropertyName() {
        return null;
    }

    @Override
    public Class getPropertyType(String property) {
        VariantPropertyDesc entry = this.propertyDesc.get(property);
        if (entry != null) {
            return entry.getPropertyType();
        }
        entry = this.findProperty(property);
        if (entry != null) {
            return entry.getPropertyType();
        }
        return null;
    }

    @Override
    public Class getUnderlyingType() {
        return Object.class;
    }

    @Override
    public String getName() {
        return this.metadata.getPublicName();
    }

    @Override
    public int getEventTypeId() {
        return this.eventTypeId;
    }

    public ConfigurationVariantStream getConfig() {
        return this.config;
    }

    @Override
    public EventPropertyGetter getGetter(String property) {
        VariantPropertyDesc entry = this.propertyDesc.get(property);
        if (entry != null) {
            return entry.getGetter();
        }
        entry = this.findProperty(property);
        if (entry != null) {
            return entry.getGetter();
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String property) {
        VariantPropertyDesc entry = this.propertyDesc.get(property);
        if (entry != null) {
            return entry.isProperty();
        }
        entry = this.findProperty(property);
        if (entry != null) {
            return entry.isProperty();
        }
        return false;
    }

    @Override
    public EventType[] getSuperTypes() {
        return null;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return null;
    }

    private VariantPropertyDesc findProperty(String propertyName) {
        VariantPropertyDesc desc = this.propertyResStrategy.resolveProperty(propertyName, this.variants);
        if (desc != null) {
            this.propertyDesc.put(propertyName, desc);
        }
        return desc;
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }

    @Override
    public FragmentEventType getFragmentType(String property) {
        return null;
    }

    @Override
    public EventPropertyWriter getWriter(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        return null;
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        return new EventPropertyDescriptor[0];
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        return null;
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        return null;
    }

    @Override
    public EventBeanReader getReader() {
        return null;
    }

    @Override
    public EventPropertyGetterMapped getGetterMapped(String mappedProperty) {
        return null;
    }

    @Override
    public EventPropertyGetterIndexed getGetterIndexed(String indexedProperty) {
        return null;
    }

    @Override
    public boolean equalsCompareType(EventType eventType) {
        return this == eventType;
    }
}

