/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.xml.DOMPropertyGetter;
import com.espertech.esper.event.xml.FragmentFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMMapGetter
implements EventPropertyGetter,
DOMPropertyGetter {
    private final String propertyMap;
    private final String mapKey;
    private final FragmentFactory fragmentFactory;

    public DOMMapGetter(String propertyName, String mapKey, FragmentFactory fragmentFactory) {
        this.propertyMap = propertyName;
        this.mapKey = mapKey;
        this.fragmentFactory = fragmentFactory;
    }

    @Override
    public Node[] getValueAsNodeArray(Node node) {
        return null;
    }

    @Override
    public Object getValueAsFragment(Node node) {
        if (this.fragmentFactory == null) {
            return null;
        }
        Node result = this.getValueAsNode(node);
        if (result == null) {
            return null;
        }
        return this.fragmentFactory.getEvent(result);
    }

    @Override
    public Node getValueAsNode(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node attribute;
            Node childNode = list.item(i);
            if (childNode == null || childNode.getNodeType() != 1 || !childNode.getNodeName().equals(this.propertyMap) || (attribute = childNode.getAttributes().getNamedItem("id")) == null || !attribute.getTextContent().equals(this.mapKey)) continue;
            return childNode;
        }
        return null;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object result = eventBean.getUnderlying();
        if (!(result instanceof Node)) {
            return null;
        }
        Node node = (Node)result;
        return this.getValueAsNode(node);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        Object result = eventBean.getUnderlying();
        if (!(result instanceof Node)) {
            return false;
        }
        Node node = (Node)result;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node attribute;
            Node childNode = list.item(i);
            if (childNode == null || childNode.getNodeType() != 1) continue;
            String elementName = childNode.getLocalName();
            if (elementName == null) {
                elementName = childNode.getNodeName();
            }
            if (!this.propertyMap.equals(elementName) || (attribute = childNode.getAttributes().getNamedItem(this.mapKey)) == null || !attribute.getTextContent().equals(this.mapKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) {
        return null;
    }
}

