/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ASTUtil;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.StringValue;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleXMLPropertyParser {
    private static final Log log = LogFactory.getLog(SimpleXMLPropertyParser.class);

    public static String walk(EsperEPL2GrammarParser.StartEventPropertyRuleContext ast, String propertyName, String rootElementName, String defaultNamespacePrefix, boolean isResolvePropertiesAbsolute) {
        List<EsperEPL2GrammarParser.EventPropertyAtomicContext> ctxs;
        StringBuilder xPathBuf = new StringBuilder();
        xPathBuf.append('/');
        if (isResolvePropertiesAbsolute) {
            if (defaultNamespacePrefix != null) {
                xPathBuf.append(defaultNamespacePrefix);
                xPathBuf.append(':');
            }
            xPathBuf.append(rootElementName);
        }
        if ((ctxs = ast.eventProperty().eventPropertyAtomic()).size() == 1) {
            xPathBuf.append(SimpleXMLPropertyParser.makeProperty(ctxs.get(0), defaultNamespacePrefix));
        } else {
            for (EsperEPL2GrammarParser.EventPropertyAtomicContext ctx : ctxs) {
                xPathBuf.append(SimpleXMLPropertyParser.makeProperty(ctx, defaultNamespacePrefix));
            }
        }
        String xPath = xPathBuf.toString();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug((Object)(".parse For property '" + propertyName + "' the xpath is '" + xPath + '\''));
        }
        return xPath;
    }

    private static String makeProperty(EsperEPL2GrammarParser.EventPropertyAtomicContext ctx, String defaultNamespacePrefix) {
        String prefix = "";
        if (defaultNamespacePrefix != null) {
            prefix = defaultNamespacePrefix + ":";
        }
        String unescapedIdent = ASTUtil.unescapeDot(ctx.eventPropertyIdent().getText());
        if (ctx.lb != null) {
            int index = IntValue.parseString(ctx.number().getText());
            int xPathPosition = index + 1;
            return '/' + prefix + unescapedIdent + "[position() = " + xPathPosition + ']';
        }
        if (ctx.lp != null) {
            String key = StringValue.parseString(ctx.s.getText());
            return '/' + prefix + unescapedIdent + "[@id='" + key + "']";
        }
        return '/' + prefix + unescapedIdent;
    }
}

