/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.event.xml.ElementPathNode;
import com.espertech.esper.event.xml.SchemaElementComplex;
import com.espertech.esper.event.xml.SchemaElementSimple;
import com.espertech.esper.event.xml.SchemaItemAttribute;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.util.FileUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.ResourceLoader;
import com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl;
import com.sun.org.apache.xerces.internal.impl.dv.xs.XSSimpleTypeDecl;
import com.sun.org.apache.xerces.internal.xs.StringList;
import com.sun.org.apache.xerces.internal.xs.XSAttributeUse;
import com.sun.org.apache.xerces.internal.xs.XSComplexTypeDefinition;
import com.sun.org.apache.xerces.internal.xs.XSElementDeclaration;
import com.sun.org.apache.xerces.internal.xs.XSFacet;
import com.sun.org.apache.xerces.internal.xs.XSImplementation;
import com.sun.org.apache.xerces.internal.xs.XSLoader;
import com.sun.org.apache.xerces.internal.xs.XSModel;
import com.sun.org.apache.xerces.internal.xs.XSModelGroup;
import com.sun.org.apache.xerces.internal.xs.XSNamedMap;
import com.sun.org.apache.xerces.internal.xs.XSObject;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;
import com.sun.org.apache.xerces.internal.xs.XSParticle;
import com.sun.org.apache.xerces.internal.xs.XSTerm;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

public class XSDSchemaMapper {
    private static final Log log = LogFactory.getLog(XSDSchemaMapper.class);
    private static final int JAVA5_COMPLEX_TYPE = 13;
    private static final int JAVA5_SIMPLE_TYPE = 14;
    private static final int JAVA6_COMPLEX_TYPE = 15;
    private static final int JAVA6_SIMPLE_TYPE = 16;

    public static SchemaModel loadAndMap(String schemaResource, String schemaText) {
        XSModel model;
        try {
            model = XSDSchemaMapper.readSchemaInternal(schemaResource, schemaText);
        }
        catch (ConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurationException("Failed to read schema '" + schemaResource + "' : " + ex.getMessage(), ex);
        }
        return XSDSchemaMapper.map(model);
    }

    private static XSModel readSchemaInternal(String schemaResource, String schemaText) throws IllegalAccessException, InstantiationException, ClassNotFoundException, ConfigurationException, URISyntaxException {
        XSModel xsModel;
        LSInputImpl input = null;
        String baseURI = null;
        URL url = null;
        if (schemaResource != null) {
            url = ResourceLoader.resolveClassPathOrURLResource("schema", schemaResource);
            baseURI = url.toURI().toString();
        } else {
            input = new LSInputImpl(schemaText);
        }
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        registry.addSource(new DOMXSImplementationSourceImpl());
        DOMImplementation xsImplementation = registry.getDOMImplementation("XS-Loader");
        if (xsImplementation == null) {
            throw new ConfigurationException("Failed to retrieve XS-Loader implementation from registry obtained via DOMImplementationRegistry.newInstance, please check that registry.getDOMImplementation(\"XS-Loader\") returns an instance");
        }
        if (!JavaClassHelper.isImplementsInterface(xsImplementation.getClass(), XSImplementation.class)) {
            String message = "The XS-Loader instance returned by the DOM registry class '" + xsImplementation.getClass().getName() + "' does not implement the interface '" + XSImplementation.class.getName() + "'; If you have a another Xerces distribution in your classpath please ensure the classpath order loads the JRE Xerces distribution or set the DOMImplementationRegistry.PROPERTY system property";
            throw new ConfigurationException(message);
        }
        XSImplementation impl = (XSImplementation)((Object)xsImplementation);
        XSLoader schemaLoader = impl.createXSLoader(null);
        schemaLoader.getConfig().setParameter("error-handler", new XSDSchemaMapperErrorHandler(schemaResource));
        if (input != null) {
            xsModel = schemaLoader.load(input);
        } else {
            xsModel = schemaLoader.loadURI(baseURI);
            if (xsModel == null) {
                String schema;
                try {
                    schema = FileUtil.readTextFile(new File(url.toURI()));
                }
                catch (IOException e) {
                    throw new ConfigurationException("Failed to read file '" + url.toURI() + "':" + e.getMessage(), e);
                }
                log.debug((Object)("Found and obtained schema: " + schema));
                xsModel = schemaLoader.load(new LSInputImpl(schema));
                log.debug((Object)("Model for schema: " + xsModel));
            }
        }
        if (xsModel == null) {
            throw new ConfigurationException("Failed to read schema via URL '" + schemaResource + '\'');
        }
        return xsModel;
    }

    private static SchemaModel map(XSModel xsModel) {
        StringList namespaces = xsModel.getNamespaces();
        ArrayList<String> namesspaceList = new ArrayList<String>();
        for (int i = 0; i < namespaces.getLength(); ++i) {
            namesspaceList.add(namespaces.item(i));
        }
        XSNamedMap elements = xsModel.getComponents((short)2);
        ArrayList<SchemaElementComplex> components = new ArrayList<SchemaElementComplex>();
        for (int i = 0; i < elements.getLength(); ++i) {
            XSElementDeclaration decl;
            XSObject object = elements.item(i);
            if (!(object instanceof XSElementDeclaration) || !XSDSchemaMapper.isComplexTypeCategory((decl = (XSElementDeclaration)elements.item(i)).getTypeDefinition().getTypeCategory())) continue;
            XSComplexTypeDefinition complexActualElement = (XSComplexTypeDefinition)decl.getTypeDefinition();
            String name = object.getName();
            String namespace = object.getNamespace();
            ElementPathNode rootNode = new ElementPathNode(null, name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing component " + namespace + " " + name));
            }
            SchemaElementComplex complexElement = XSDSchemaMapper.process(name, namespace, complexActualElement, false, rootNode);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding component " + namespace + " " + name));
            }
            components.add(complexElement);
        }
        return new SchemaModel(components, namesspaceList);
    }

    private static boolean isComplexTypeCategory(short typeCategory) {
        return typeCategory == 15 || typeCategory == 13 || typeCategory == 15;
    }

    private static boolean isSimpleTypeCategory(short typeCategory) {
        return typeCategory == 16 || typeCategory == 14 || typeCategory == 16;
    }

    private static SchemaElementComplex process(String complexElementName, String complexElementNamespace, XSComplexTypeDefinition complexActualElement, boolean isArray, ElementPathNode node) {
        XSParticle particle;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing complex " + complexElementNamespace + " " + complexElementName + " stack " + node.toString()));
        }
        ArrayList<SchemaItemAttribute> attributes = new ArrayList<SchemaItemAttribute>();
        ArrayList<SchemaElementSimple> simpleElements = new ArrayList<SchemaElementSimple>();
        ArrayList<SchemaElementComplex> complexElements = new ArrayList<SchemaElementComplex>();
        Short optionalSimplyType = null;
        String optionalSimplyTypeName = null;
        if (complexActualElement.getSimpleType() != null) {
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)complexActualElement.getSimpleType();
            optionalSimplyType = simpleType.getPrimitiveKind();
            optionalSimplyTypeName = simpleType.getName();
        }
        SchemaElementComplex complexElement = new SchemaElementComplex(complexElementName, complexElementNamespace, attributes, complexElements, simpleElements, isArray, optionalSimplyType, optionalSimplyTypeName);
        XSObjectList attrs = complexActualElement.getAttributeUses();
        for (int i = 0; i < attrs.getLength(); ++i) {
            XSAttributeUse attr = (XSAttributeUse)attrs.item(i);
            String namespace = attr.getAttrDeclaration().getNamespace();
            String name = attr.getAttrDeclaration().getName();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)attr.getAttrDeclaration().getTypeDefinition();
            attributes.add(new SchemaItemAttribute(namespace, name, simpleType.getPrimitiveKind(), simpleType.getName()));
        }
        if ((complexActualElement.getContentType() == 2 || complexActualElement.getContentType() == 3) && (particle = complexActualElement.getParticle()).getTerm() instanceof XSModelGroup) {
            return XSDSchemaMapper.processModelGroup(particle, simpleElements, complexElements, node, complexActualElement, complexElement);
        }
        return complexElement;
    }

    private static SchemaElementComplex processModelGroup(XSObject xsObject, List<SchemaElementSimple> simpleElements, List<SchemaElementComplex> complexElements, ElementPathNode node, XSComplexTypeDefinition complexActualElement, SchemaElementComplex complexElement) {
        XSTerm term = null;
        term = xsObject instanceof XSParticle ? ((XSParticle)xsObject).getTerm() : (XSTerm)xsObject;
        if (term instanceof XSModelGroup) {
            XSModelGroup group = (XSModelGroup)term;
            XSObjectList particles = group.getParticles();
            for (int i = 0; i < particles.getLength(); ++i) {
                XSParticle childParticle = (XSParticle)particles.item(i);
                if (childParticle.getTerm() instanceof XSElementDeclaration) {
                    XSElementDeclaration decl = (XSElementDeclaration)childParticle.getTerm();
                    boolean isArrayFlag = XSDSchemaMapper.isArray(childParticle);
                    if (XSDSchemaMapper.isSimpleTypeCategory(decl.getTypeDefinition().getTypeCategory())) {
                        XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)decl.getTypeDefinition();
                        Integer fractionDigits = XSDSchemaMapper.getFractionRestriction(simpleType);
                        simpleElements.add(new SchemaElementSimple(decl.getName(), decl.getNamespace(), simpleType.getPrimitiveKind(), simpleType.getName(), isArrayFlag, fractionDigits));
                    }
                    if (XSDSchemaMapper.isComplexTypeCategory(decl.getTypeDefinition().getTypeCategory())) {
                        String name = decl.getName();
                        String namespace = decl.getNamespace();
                        ElementPathNode newChild = node.addChild(name);
                        if (newChild.doesNameAlreadyExistInHierarchy()) continue;
                        complexActualElement = (XSComplexTypeDefinition)decl.getTypeDefinition();
                        SchemaElementComplex innerComplex = XSDSchemaMapper.process(name, namespace, complexActualElement, isArrayFlag, newChild);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding complex " + complexElement));
                        }
                        complexElements.add(innerComplex);
                    }
                }
                XSDSchemaMapper.processModelGroup(childParticle.getTerm(), simpleElements, complexElements, node, complexActualElement, complexElement);
            }
        }
        return complexElement;
    }

    private static Integer getFractionRestriction(XSSimpleTypeDecl simpleType) {
        if ((simpleType.getDefinedFacets() & 0x400) != 0) {
            XSObjectList facets = simpleType.getFacets();
            Integer digits = null;
            for (int f = 0; f < facets.getLength(); ++f) {
                XSFacet facet;
                XSObject item = facets.item(f);
                if (!(item instanceof XSFacet) || (facet = (XSFacet)item).getFacetKind() != 1024) continue;
                try {
                    digits = Integer.parseInt(facet.getLexicalFacetValue());
                    continue;
                }
                catch (RuntimeException ex) {
                    log.warn((Object)("Error parsing fraction facet value '" + facet.getLexicalFacetValue() + "' : " + ex.getMessage()), (Throwable)ex);
                }
            }
            return digits;
        }
        return null;
    }

    private static boolean isArray(XSParticle particle) {
        return particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
    }

    public static class XSDSchemaMapperErrorHandler
    implements DOMErrorHandler {
        private final String schemaResource;

        public XSDSchemaMapperErrorHandler(String schemaResource) {
            this.schemaResource = schemaResource;
        }

        @Override
        public boolean handleError(DOMError error) {
            String from = this.schemaResource != null ? this.schemaResource : "string";
            log.warn((Object)("DOM error reported loading schema from " + from + ":\n" + "  message: " + error.getMessage() + "\n" + "  type: " + error.getType() + "\n" + "  related data: " + error.getRelatedData() + "\n" + "  related exception: " + error.getRelatedException() + "\n" + "  severity: " + error.getSeverity() + "\n" + "  location: " + error.getLocation()));
            if (error.getRelatedException() instanceof Throwable) {
                Throwable t = (Throwable)error.getRelatedException();
                log.warn((Object)("DOM error related exception: " + t.getMessage()), t);
            }
            return false;
        }
    }

    public static class LSInputImpl
    implements LSInput {
        private String stringData;

        public LSInputImpl(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public String getStringData() {
            return this.stringData;
        }

        @Override
        public void setStringData(String stringData) {
            this.stringData = stringData;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }
    }
}

