/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.filter.EventTypeIndex;
import com.espertech.esper.filter.EventTypeIndexBuilder;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterLockBackoffException;
import com.espertech.esper.filter.FilterServiceEntry;
import com.espertech.esper.filter.FilterServiceGranularLockFactory;
import com.espertech.esper.filter.FilterServiceListener;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.filter.FilterSet;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.metrics.jmx.JmxGetter;
import com.espertech.esper.metrics.jmx.JmxOperation;
import com.espertech.esper.util.AuditPath;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FilterServiceBase
implements FilterServiceSPI {
    private final FilterServiceGranularLockFactory lockFactory;
    private static final Log log = LogFactory.getLog(FilterServiceBase.class);
    private final EventTypeIndexBuilder indexBuilder;
    private final EventTypeIndex eventTypeIndex;
    private final AtomicLong numEventsEvaluated = new AtomicLong();
    private volatile long filtersVersion = 1L;
    private final CopyOnWriteArraySet<FilterServiceListener> filterServiceListeners;

    protected FilterServiceBase(FilterServiceGranularLockFactory lockFactory, boolean allowIsolation) {
        this.lockFactory = lockFactory;
        this.eventTypeIndex = new EventTypeIndex(lockFactory);
        this.indexBuilder = new EventTypeIndexBuilder(this.eventTypeIndex, allowIsolation);
        this.filterServiceListeners = new CopyOnWriteArraySet();
    }

    @Override
    public boolean isSupportsTakeApply() {
        return this.indexBuilder.isSupportsTakeApply();
    }

    @Override
    public long getFiltersVersion() {
        return this.filtersVersion;
    }

    @Override
    public void destroy() {
        log.debug((Object)"Destroying filter service");
        this.eventTypeIndex.destroy();
        this.indexBuilder.destroy();
    }

    protected FilterServiceEntry addInternal(FilterValueSet filterValueSet, FilterHandle filterCallback) {
        FilterServiceEntry entry = this.indexBuilder.add(filterValueSet, filterCallback, this.lockFactory);
        ++this.filtersVersion;
        return entry;
    }

    protected void removeInternal(FilterHandle filterCallback, FilterServiceEntry filterServiceEntry) {
        this.indexBuilder.remove(filterCallback, filterServiceEntry);
        ++this.filtersVersion;
    }

    protected long evaluateInternal(EventBean theEvent, Collection<FilterHandle> matches) {
        long version = this.filtersVersion;
        this.numEventsEvaluated.incrementAndGet();
        this.retryableMatchEvent(theEvent, matches);
        if (AuditPath.isAuditEnabled && !this.filterServiceListeners.isEmpty()) {
            for (FilterServiceListener listener : this.filterServiceListeners) {
                listener.filtering(theEvent, matches, null);
            }
        }
        return version;
    }

    protected long evaluateInternal(EventBean theEvent, Collection<FilterHandle> matches, int statementId) {
        long version = this.filtersVersion;
        this.numEventsEvaluated.incrementAndGet();
        ArrayDeque<FilterHandle> allMatches = new ArrayDeque<FilterHandle>();
        this.retryableMatchEvent(theEvent, allMatches);
        for (FilterHandle match : allMatches) {
            if (match.getStatementId() != statementId) continue;
            matches.add(match);
        }
        if (AuditPath.isAuditEnabled && !this.filterServiceListeners.isEmpty()) {
            for (FilterServiceListener listener : this.filterServiceListeners) {
                listener.filtering(theEvent, matches, statementId);
            }
        }
        return version;
    }

    @Override
    @JmxGetter(name="NumEventsEvaluated", description="Number of events evaluated (main)")
    public final long getNumEventsEvaluated() {
        return this.numEventsEvaluated.get();
    }

    @Override
    @JmxOperation(description="Reset number of events evaluated")
    public void resetStats() {
        this.numEventsEvaluated.set(0L);
    }

    @Override
    public void addFilterServiceListener(FilterServiceListener filterServiceListener) {
        this.filterServiceListeners.add(filterServiceListener);
    }

    @Override
    public void removeFilterServiceListener(FilterServiceListener filterServiceListener) {
        this.filterServiceListeners.remove(filterServiceListener);
    }

    protected FilterSet takeInternal(Set<Integer> statementIds) {
        ++this.filtersVersion;
        return this.indexBuilder.take(statementIds);
    }

    protected void applyInternal(FilterSet filterSet) {
        ++this.filtersVersion;
        this.indexBuilder.apply(filterSet, this.lockFactory);
    }

    @Override
    @JmxGetter(name="NumFiltersApprox", description="Number of filters managed (approximately)")
    public int getFilterCountApprox() {
        return this.eventTypeIndex.getFilterCountApprox();
    }

    @Override
    @JmxGetter(name="NumEventTypes", description="Number of event types considered")
    public int getCountTypes() {
        return this.eventTypeIndex.size();
    }

    @Override
    public void init() {
    }

    protected void removeTypeInternal(EventType type) {
        this.eventTypeIndex.removeType(type);
    }

    private void retryableMatchEvent(EventBean theEvent, Collection<FilterHandle> matches) {
        try {
            this.eventTypeIndex.matchEvent(theEvent, matches);
        }
        catch (FilterLockBackoffException ex) {
            long delayNs = 10L;
            while (true) {
                try {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    LockSupport.parkNanos(delayNs);
                    if (delayNs < 1000000000L) {
                        delayNs *= 2L;
                    }
                    matches.clear();
                    this.eventTypeIndex.matchEvent(theEvent, matches);
                }
                catch (FilterLockBackoffException ex2) {
                    continue;
                }
                break;
            }
        }
    }
}

