/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalAuditInstanceCount;
import com.espertech.esper.pattern.EvalAuditNode;
import com.espertech.esper.pattern.EvalAuditStateNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeFactoryBase;
import com.espertech.esper.pattern.EvalNodeUtil;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.pattern.PatternExpressionPrecedenceEnum;
import java.io.StringWriter;

public class EvalAuditFactoryNode
extends EvalNodeFactoryBase {
    private static final long serialVersionUID = 6585271287552353699L;
    private final boolean auditPattern;
    private final boolean auditPatternInstance;
    private final String patternExpr;
    private final transient EvalAuditInstanceCount instanceCount;
    private final boolean filterChildNonQuitting;

    public EvalAuditFactoryNode(boolean auditPattern, boolean auditPatternInstance, String patternExpr, EvalAuditInstanceCount instanceCount, boolean filterChildNonQuitting) {
        this.auditPattern = auditPattern;
        this.auditPatternInstance = auditPatternInstance;
        this.patternExpr = patternExpr;
        this.instanceCount = instanceCount;
        this.filterChildNonQuitting = filterChildNonQuitting;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode child = EvalNodeUtil.makeEvalNodeSingleChild(this.getChildNodes(), agentInstanceContext, parentNode);
        return new EvalAuditNode(agentInstanceContext, this, child);
    }

    public boolean isAuditPattern() {
        return this.auditPattern;
    }

    public String getPatternExpr() {
        return this.patternExpr;
    }

    public final String toString() {
        return "EvalAuditFactoryNode children=" + this.getChildNodes().size();
    }

    public void decreaseRefCount(EvalAuditStateNode current, PatternContext patternContext) {
        if (!this.auditPatternInstance) {
            return;
        }
        this.instanceCount.decreaseRefCount(this.getChildNodes().get(0), current, this.patternExpr, patternContext.getStatementName(), patternContext.getEngineURI());
    }

    public void increaseRefCount(EvalAuditStateNode current, PatternContext patternContext) {
        if (!this.auditPatternInstance) {
            return;
        }
        this.instanceCount.increaseRefCount(this.getChildNodes().get(0), current, this.patternExpr, patternContext.getStatementName(), patternContext.getEngineURI());
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return this.filterChildNonQuitting;
    }

    @Override
    public boolean isStateful() {
        return this.getChildNodes().get(0).isStateful();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return this.getChildNodes().get(0).getPrecedence();
    }
}

