/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalEveryDistinctFactoryNode;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.pattern.EvalGuardFactoryNode;
import com.espertech.esper.pattern.EvalMatchUntilFactoryNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeUtilFactoryFilter;
import com.espertech.esper.pattern.EvalObserverFactoryNode;
import com.espertech.esper.pattern.EvalRootFactoryNode;
import com.espertech.esper.pattern.EvalRootNode;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalNodeUtil {
    private static final Log log = LogFactory.getLog(EvalNodeUtil.class);

    public static EvalNodeAnalysisResult recursiveAnalyzeChildNodes(EvalFactoryNode currentNode) {
        EvalNodeAnalysisResult evalNodeAnalysisResult = new EvalNodeAnalysisResult();
        EvalNodeUtil.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, currentNode);
        return evalNodeAnalysisResult;
    }

    private static void recursiveAnalyzeChildNodes(EvalNodeAnalysisResult evalNodeAnalysisResult, EvalFactoryNode currentNode) {
        if (currentNode instanceof EvalFilterFactoryNode || currentNode instanceof EvalGuardFactoryNode || currentNode instanceof EvalObserverFactoryNode || currentNode instanceof EvalMatchUntilFactoryNode || currentNode instanceof EvalEveryDistinctFactoryNode) {
            evalNodeAnalysisResult.addNode(currentNode);
        }
        for (EvalFactoryNode node : currentNode.getChildNodes()) {
            EvalNodeUtil.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, node);
        }
    }

    public static Set<EvalFactoryNode> recursiveGetChildNodes(EvalFactoryNode currentNode, EvalNodeUtilFactoryFilter filter) {
        LinkedHashSet<EvalFactoryNode> result = new LinkedHashSet<EvalFactoryNode>();
        if (filter.consider(currentNode)) {
            result.add(currentNode);
        }
        EvalNodeUtil.recursiveGetChildNodes(result, currentNode, filter);
        return result;
    }

    private static void recursiveGetChildNodes(Set<EvalFactoryNode> set, EvalFactoryNode currentNode, EvalNodeUtilFactoryFilter filter) {
        for (EvalFactoryNode node : currentNode.getChildNodes()) {
            if (filter.consider(node)) {
                set.add(node);
            }
            EvalNodeUtil.recursiveGetChildNodes(set, node, filter);
        }
    }

    public static EvalRootNode makeRootNodeFromFactory(EvalRootFactoryNode rootFactoryNode, PatternAgentInstanceContext patternAgentInstanceContext) {
        return (EvalRootNode)rootFactoryNode.makeEvalNode(patternAgentInstanceContext, null);
    }

    public static EvalNode makeEvalNodeSingleChild(List<EvalFactoryNode> childNodes, PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        return childNodes.get(0).makeEvalNode(agentInstanceContext, parentNode);
    }

    public static EvalNode[] makeEvalNodeChildren(List<EvalFactoryNode> childNodes, PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode[] children = new EvalNode[childNodes.size()];
        for (int i = 0; i < childNodes.size(); ++i) {
            children[i] = childNodes.get(i).makeEvalNode(agentInstanceContext, parentNode);
        }
        return children;
    }
}

