/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalObserverNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternAgentInstanceContext;
import com.espertech.esper.pattern.PatternConsumptionUtil;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EvalObserverStateNode
extends EvalStateNode
implements ObserverEventEvaluator {
    protected final EvalObserverNode evalObserverNode;
    protected EventObserver eventObserver;
    private static final Log log = LogFactory.getLog(EvalObserverStateNode.class);

    public EvalObserverStateNode(Evaluator parentNode, EvalObserverNode evalObserverNode) {
        super(parentNode);
        this.evalObserverNode = evalObserverNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.eventObserver.getBeginState())) {
            this.quit();
            this.getParentEvaluator().evaluateFalse(this, true);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalObserverNode;
    }

    @Override
    public PatternAgentInstanceContext getContext() {
        return this.evalObserverNode.getContext();
    }

    @Override
    public void observerEvaluateTrue(MatchedEventMap matchEvent, boolean quitted) {
        this.getParentEvaluator().evaluateTrue(matchEvent, this, quitted);
    }

    @Override
    public void observerEvaluateFalse(boolean restartable) {
        this.getParentEvaluator().evaluateFalse(this, restartable);
    }

    @Override
    public void start(MatchedEventMap beginState) {
        this.eventObserver = this.evalObserverNode.getFactoryNode().getObserverFactory().makeObserver(this.evalObserverNode.getContext(), beginState, this, null, null, this.getParentEvaluator().isFilterChildNonQuitting());
        this.eventObserver.startObserve();
    }

    @Override
    public final void quit() {
        this.eventObserver.stopObserve();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitObserver(this.evalObserverNode.getFactoryNode(), this, this.eventObserver);
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return this.evalObserverNode.getFactoryNode().isObserverStateNodeNonRestarting();
    }

    public final String toString() {
        return "EvalObserverStateNode eventObserver=" + this.eventObserver;
    }
}

