/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.EventObserverVisitor;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.schedule.ScheduleHandleCallback;

public class TimerIntervalObserver
implements EventObserver,
ScheduleHandleCallback {
    private final long msec;
    private final MatchedEventMap beginState;
    private final ObserverEventEvaluator observerEventEvaluator;
    private final long scheduleSlot;
    private boolean isTimerActive = false;
    private EPStatementHandleCallback scheduleHandle;

    public TimerIntervalObserver(long msec, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator) {
        this.msec = msec;
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = observerEventEvaluator.getContext().getPatternContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public final void scheduledTrigger(EngineLevelExtensionServicesContext engineLevelExtensionServicesContext) {
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState, true);
        this.isTimerActive = false;
    }

    @Override
    public MatchedEventMap getBeginState() {
        return this.beginState;
    }

    @Override
    public void startObserve() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        if (this.msec <= 0L) {
            this.observerEventEvaluator.observerEvaluateTrue(this.beginState, true);
        } else {
            this.scheduleHandle = new EPStatementHandleCallback(this.observerEventEvaluator.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
            this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService().add(this.msec, this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = true;
        }
    }

    @Override
    public void stopObserve() {
        if (this.isTimerActive) {
            this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = false;
            this.scheduleHandle = null;
        }
    }

    @Override
    public void accept(EventObserverVisitor visitor) {
        visitor.visitObserver(this.beginState, 10, this.scheduleSlot);
    }
}

