/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.client.util.TimePeriod;
import com.espertech.esper.pattern.observer.TimerScheduleSpec;
import com.espertech.esper.schedule.ScheduleParameterException;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerScheduleISO8601Parser {
    private static final Log log = LogFactory.getLog(TimerScheduleISO8601Parser.class);

    public static TimerScheduleSpec parse(String iso) throws ScheduleParameterException {
        if (iso == null) {
            throw new ScheduleParameterException("Received a null value");
        }
        if ((iso = iso.trim()).isEmpty()) {
            throw new ScheduleParameterException("Received an empty string");
        }
        String[] split = iso.split("/");
        Long optionalRepeats = null;
        Calendar optionalDate = null;
        TimePeriod optionalTimePeriod = null;
        try {
            if (iso.equals("/")) {
                throw new ScheduleParameterException("Invalid number of parts");
            }
            if (iso.endsWith("/")) {
                throw new ScheduleParameterException("Missing the period part");
            }
            if (split.length == 3) {
                optionalRepeats = TimerScheduleISO8601Parser.parseRepeat(split[0]);
                optionalDate = TimerScheduleISO8601Parser.parseDate(split[1]);
                optionalTimePeriod = TimerScheduleISO8601Parser.parsePeriod(split[2]);
            } else if (split.length == 2) {
                if (split[0].isEmpty()) {
                    throw new ScheduleParameterException("Expected either a recurrence or a date but received an empty string");
                }
                if (split[0].charAt(0) == 'R') {
                    optionalRepeats = TimerScheduleISO8601Parser.parseRepeat(split[0]);
                } else {
                    optionalDate = TimerScheduleISO8601Parser.parseDate(split[0]);
                }
                optionalTimePeriod = TimerScheduleISO8601Parser.parsePeriod(split[1]);
            } else if (split.length == 1) {
                if (split[0].charAt(0) == 'P') {
                    optionalTimePeriod = TimerScheduleISO8601Parser.parsePeriod(split[0]);
                } else {
                    optionalDate = TimerScheduleISO8601Parser.parseDate(split[0]);
                }
            }
        }
        catch (Exception ex) {
            throw new ScheduleParameterException("Failed to parse '" + iso + "': " + ex.getMessage(), ex);
        }
        return new TimerScheduleSpec(optionalDate, optionalRepeats, optionalTimePeriod);
    }

    public static Calendar parseDate(String dateText) throws ScheduleParameterException {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(dateText).toGregorianCalendar();
        }
        catch (RuntimeException e) {
            String message = "Exception parsing date '" + dateText + "', the date is not a supported ISO 8601 date";
            log.debug((Object)message, (Throwable)e);
            throw new ScheduleParameterException(message);
        }
        catch (DatatypeConfigurationException e) {
            throw new ScheduleParameterException("Exception parsing date '" + dateText + "': " + e.getMessage(), e);
        }
    }

    private static long parseRepeat(String repeat) throws ScheduleParameterException {
        if (repeat.charAt(0) != 'R') {
            throw new ScheduleParameterException("Invalid repeat '" + repeat + "', expecting 'R' but received '" + repeat.charAt(0) + "'");
        }
        long numRepeats = -1L;
        if (repeat.length() > 1) {
            try {
                numRepeats = Long.parseLong(repeat.substring(1));
            }
            catch (RuntimeException ex) {
                String message = "Invalid repeat '" + repeat + "', expecting an long-typed value but received '" + repeat.substring(1) + "'";
                log.debug((Object)message, (Throwable)ex);
                throw new ScheduleParameterException(message);
            }
        }
        return numRepeats;
    }

    private static TimePeriod parsePeriod(String period) throws ScheduleParameterException {
        Pattern p = Pattern.compile("P((\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?)?(T(\\d+H)?(\\d+M)?(\\d+S)?)?");
        Matcher matcher = p.matcher(period);
        if (!matcher.matches()) {
            throw new ScheduleParameterException("Invalid period '" + period + "'");
        }
        TimePeriod timePeriod = new TimePeriod();
        int indexOfT = period.indexOf("T");
        if (indexOfT < 1) {
            TimerScheduleISO8601Parser.parsePeriodDatePart(period.substring(1), timePeriod);
        } else {
            TimerScheduleISO8601Parser.parsePeriodDatePart(period.substring(1, indexOfT), timePeriod);
            TimerScheduleISO8601Parser.parsePeriodTimePart(period.substring(indexOfT + 1), timePeriod);
        }
        Integer largestAbsolute = timePeriod.largestAbsoluteValue();
        if (largestAbsolute == null || largestAbsolute == 0) {
            throw new ScheduleParameterException("Invalid period '" + period + "'");
        }
        return timePeriod;
    }

    private static void parsePeriodDatePart(String datePart, TimePeriod timePeriod) throws ScheduleParameterException {
        Pattern pattern = Pattern.compile("(\\d+Y)?(\\d+M)?(\\d+W)?(\\d+D)?");
        Matcher matcher = pattern.matcher(datePart);
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String group = matcher.group(i + 1);
            if (group == null) continue;
            if (group.endsWith("Y")) {
                timePeriod.setYears(TimerScheduleISO8601Parser.safeParsePrefixedInt(group));
                continue;
            }
            if (group.endsWith("M")) {
                timePeriod.setMonths(TimerScheduleISO8601Parser.safeParsePrefixedInt(group));
                continue;
            }
            if (group.endsWith("D")) {
                timePeriod.setDays(TimerScheduleISO8601Parser.safeParsePrefixedInt(group));
                continue;
            }
            if (!group.endsWith("W")) continue;
            timePeriod.setWeeks(TimerScheduleISO8601Parser.safeParsePrefixedInt(group));
        }
    }

    private static Integer safeParsePrefixedInt(String group) {
        return Integer.parseInt(group.substring(0, group.length() - 1));
    }

    private static void parsePeriodTimePart(String timePart, TimePeriod timePeriod) throws ScheduleParameterException {
        Pattern pattern = Pattern.compile("(\\d+H)?(\\d+M)?(\\d+S)?");
        Matcher matcher = pattern.matcher(timePart);
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String group = matcher.group(i + 1);
            if (group == null) continue;
            if (group.endsWith("H")) {
                timePeriod.setHours(TimerScheduleISO8601Parser.safeParsePrefixedInt(group));
                continue;
            }
            if (group.endsWith("M")) {
                timePeriod.setMinutes(TimerScheduleISO8601Parser.safeParsePrefixedInt(group));
                continue;
            }
            if (!group.endsWith("S")) continue;
            timePeriod.setSeconds(TimerScheduleISO8601Parser.safeParsePrefixedInt(group));
        }
    }
}

