/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern.observer;

import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusFastAddHelper;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusFastAddResult;
import com.espertech.esper.epl.datetime.calop.CalendarOpPlusMinus;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.observer.EventObserver;
import com.espertech.esper.pattern.observer.EventObserverVisitor;
import com.espertech.esper.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.pattern.observer.TimerScheduleSpec;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.SchedulingService;
import java.util.Calendar;

public class TimerScheduleObserver
implements EventObserver,
ScheduleHandleCallback {
    protected final long scheduleSlot;
    protected MatchedEventMap beginState;
    protected final ObserverEventEvaluator observerEventEvaluator;
    private final TimerScheduleSpec spec;
    private final boolean isFilterChildNonQuitting;
    protected Calendar anchorTime;
    protected boolean isTimerActive = false;
    private Calendar cachedLastScheduled;
    private long cachedCountRepeated = 0L;
    protected EPStatementHandleCallback scheduleHandle;

    public TimerScheduleObserver(TimerScheduleSpec spec, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator, boolean isFilterChildNonQuitting) {
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = observerEventEvaluator.getContext().getPatternContext().getScheduleBucket().allocateSlot();
        this.spec = spec;
        this.isFilterChildNonQuitting = isFilterChildNonQuitting;
    }

    @Override
    public MatchedEventMap getBeginState() {
        return this.beginState;
    }

    @Override
    public final void scheduledTrigger(EngineLevelExtensionServicesContext engineLevelExtensionServicesContext) {
        this.isTimerActive = false;
        SchedulingService schedulingService = this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService();
        long nextScheduledTime = this.computeNextSetLastScheduled(schedulingService.getTime());
        boolean quit = !this.isFilterChildNonQuitting || nextScheduledTime == -1L;
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState, quit);
        if (nextScheduledTime == -1L) {
            this.stopObserve();
            this.observerEventEvaluator.observerEvaluateFalse(false);
            return;
        }
        schedulingService.add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void startObserve() {
        long nextScheduledTime;
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        SchedulingService schedulingService = this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService();
        if (this.anchorTime == null) {
            if (this.spec.getOptionalDate() == null) {
                this.anchorTime = Calendar.getInstance(this.observerEventEvaluator.getContext().getStatementContext().getEngineImportService().getTimeZone());
                this.anchorTime.setTimeInMillis(schedulingService.getTime());
            } else {
                this.anchorTime = this.spec.getOptionalDate();
            }
        }
        if ((nextScheduledTime = this.computeNextSetLastScheduled(schedulingService.getTime())) == -1L) {
            this.stopObserve();
            this.observerEventEvaluator.observerEvaluateFalse(false);
            return;
        }
        this.scheduleHandle = new EPStatementHandleCallback(this.observerEventEvaluator.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        schedulingService.add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void stopObserve() {
        if (this.isTimerActive) {
            this.observerEventEvaluator.getContext().getPatternContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
        }
        this.isTimerActive = false;
        this.scheduleHandle = null;
        this.cachedCountRepeated = Long.MAX_VALUE;
        this.cachedLastScheduled = null;
        this.anchorTime = null;
    }

    @Override
    public void accept(EventObserverVisitor visitor) {
        visitor.visitObserver(this.beginState, 2, this.scheduleSlot, this.spec, this.anchorTime, this.cachedCountRepeated, this.cachedLastScheduled, this.isTimerActive);
    }

    private long computeNextSetLastScheduled(long currentTime) {
        if (this.cachedCountRepeated == Long.MAX_VALUE) {
            return -1L;
        }
        if (this.spec.getOptionalRepeatCount() == null && this.spec.getOptionalDate() != null && this.spec.getOptionalTimePeriod() == null) {
            this.cachedCountRepeated = Long.MAX_VALUE;
            if (this.anchorTime.getTimeInMillis() > currentTime) {
                return this.anchorTime.getTimeInMillis() - currentTime;
            }
            return -1L;
        }
        if (this.spec.getOptionalRepeatCount() == null && this.spec.getOptionalTimePeriod() != null) {
            this.cachedCountRepeated = Long.MAX_VALUE;
            this.cachedLastScheduled = (Calendar)this.anchorTime.clone();
            CalendarOpPlusMinus.action(this.cachedLastScheduled, 1, this.spec.getOptionalTimePeriod());
            if (this.cachedLastScheduled.getTimeInMillis() > currentTime) {
                return this.cachedLastScheduled.getTimeInMillis() - currentTime;
            }
            return -1L;
        }
        if (this.cachedLastScheduled == null) {
            this.cachedLastScheduled = (Calendar)this.anchorTime.clone();
            if (this.spec.getOptionalDate() != null) {
                this.cachedCountRepeated = 1L;
            }
        }
        if (this.spec.getOptionalRepeatCount() == -1L) {
            CalendarOpPlusFastAddResult nextDue = CalendarOpPlusFastAddHelper.computeNextDue(currentTime, this.spec.getOptionalTimePeriod(), this.cachedLastScheduled);
            this.cachedLastScheduled = nextDue.getScheduled();
            return this.cachedLastScheduled.getTimeInMillis() - currentTime;
        }
        CalendarOpPlusFastAddResult nextDue = CalendarOpPlusFastAddHelper.computeNextDue(currentTime, this.spec.getOptionalTimePeriod(), this.cachedLastScheduled);
        this.cachedCountRepeated += nextDue.getFactor();
        if (this.cachedCountRepeated <= this.spec.getOptionalRepeatCount()) {
            this.cachedLastScheduled = nextDue.getScheduled();
            if (this.cachedLastScheduled.getTimeInMillis() > currentTime) {
                return this.cachedLastScheduled.getTimeInMillis() - currentTime;
            }
        }
        this.cachedCountRepeated = Long.MAX_VALUE;
        return -1L;
    }
}

