/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.client.hook.ConditionMatchRecognizeStatesMax;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.rowregex.MatchRecognizeStatePoolStmtHandler;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatchRecognizeStatePoolEngineSvc {
    private static final Log log = LogFactory.getLog(MatchRecognizeStatePoolEngineSvc.class);
    private volatile long maxPoolCountConfigured;
    private final boolean preventStart;
    private final AtomicLong poolCount;
    private final Set<StatementEntry> matchRecognizeContexts;

    public MatchRecognizeStatePoolEngineSvc(long maxPoolCountConfigured, boolean preventStart) {
        this.maxPoolCountConfigured = maxPoolCountConfigured;
        this.preventStart = preventStart;
        this.poolCount = new AtomicLong();
        this.matchRecognizeContexts = Collections.synchronizedSet(new HashSet());
    }

    public void setMatchRecognizeMaxStates(Long maxStates) {
        this.maxPoolCountConfigured = maxStates == null ? -1L : maxStates;
    }

    public void addPatternContext(String statementName, MatchRecognizeStatePoolStmtHandler stmtCounts) {
        this.matchRecognizeContexts.add(new StatementEntry(statementName, stmtCounts));
    }

    public void removeStatement(String name) {
        HashSet<StatementEntry> removed = new HashSet<StatementEntry>();
        for (StatementEntry context : this.matchRecognizeContexts) {
            if (!context.getStatementName().equals(name)) continue;
            removed.add(context);
        }
        this.matchRecognizeContexts.removeAll(removed);
    }

    public boolean tryIncreaseCount(AgentInstanceContext agentInstanceContext) {
        long newMax = this.poolCount.incrementAndGet();
        if (newMax > this.maxPoolCountConfigured && this.maxPoolCountConfigured >= 0L) {
            Map<String, Long> counts = this.getCounts();
            agentInstanceContext.getStatementContext().getExceptionHandlingService().handleCondition(new ConditionMatchRecognizeStatesMax(this.maxPoolCountConfigured, counts), agentInstanceContext.getStatementContext().getEpStatementHandle());
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && ExecutionPathDebugLog.isTimerDebugEnabled) {
                MatchRecognizeStatePoolStmtHandler stmtHandler = agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc().getStmtHandler();
                String stmtName = agentInstanceContext.getStatementContext().getStatementName();
                log.debug((Object)(".tryIncreaseCount For statement '" + stmtName + "' pool count overflow at " + newMax + " statement count was " + stmtHandler.getCount() + " preventStart=" + this.preventStart));
            }
            if (this.preventStart) {
                this.poolCount.decrementAndGet();
                return false;
            }
            return true;
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            MatchRecognizeStatePoolStmtHandler stmtHandler = agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc().getStmtHandler();
            String stmtName = agentInstanceContext.getStatementContext().getStatementName();
            log.debug((Object)(".tryIncreaseCount For statement '" + stmtName + "' pool count increases to " + newMax + " statement count was " + stmtHandler.getCount()));
        }
        return true;
    }

    public void decreaseCount(AgentInstanceContext agentInstanceContext) {
        this.decreaseCount(agentInstanceContext, 1);
    }

    public void decreaseCount(AgentInstanceContext agentInstanceContext, int numRemoved) {
        long newMax = this.poolCount.addAndGet(-1 * numRemoved);
        if (newMax < 0L) {
            this.poolCount.set(0L);
        }
        this.logDecrease(agentInstanceContext, newMax);
    }

    private void logDecrease(AgentInstanceContext agentInstanceContext, long newMax) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            MatchRecognizeStatePoolStmtHandler stmtHandler = agentInstanceContext.getStatementContext().getMatchRecognizeStatePoolStmtSvc().getStmtHandler();
            String stmtName = agentInstanceContext.getStatementContext().getStatementName();
            log.debug((Object)(".decreaseCount For statement '" + stmtName + "' pool count decreases to " + newMax + " statement count was " + stmtHandler.getCount()));
        }
    }

    private Map<String, Long> getCounts() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (StatementEntry context : this.matchRecognizeContexts) {
            Long count = (Long)counts.get(context.getStatementName());
            if (count == null) {
                count = 0L;
            }
            count = count + (long)context.getStmtCounts().getCount();
            counts.put(context.getStatementName(), count);
        }
        return counts;
    }

    public static class StatementEntry {
        private final String statementName;
        private final MatchRecognizeStatePoolStmtHandler stmtCounts;

        public StatementEntry(String statementName, MatchRecognizeStatePoolStmtHandler stmtCounts) {
            this.statementName = statementName;
            this.stmtCounts = stmtCounts;
        }

        public String getStatementName() {
            return this.statementName;
        }

        public MatchRecognizeStatePoolStmtHandler getStmtCounts() {
            return this.stmtCounts;
        }
    }
}

