/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.client.util.DateTime;
import com.espertech.esper.metrics.jmx.JmxGetter;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleServiceException;
import com.espertech.esper.schedule.ScheduleSet;
import com.espertech.esper.schedule.ScheduleSetEntry;
import com.espertech.esper.schedule.ScheduleVisit;
import com.espertech.esper.schedule.ScheduleVisitor;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.timer.TimeSourceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SchedulingServiceImpl
implements SchedulingServiceSPI {
    private final SortedMap<Long, SortedMap<Long, ScheduleHandle>> timeHandleMap = new TreeMap<Long, SortedMap<Long, ScheduleHandle>>();
    private final Map<ScheduleHandle, SortedMap<Long, ScheduleHandle>> handleSetMap = new HashMap<ScheduleHandle, SortedMap<Long, ScheduleHandle>>();
    private volatile long currentTime;
    private static final Log log = LogFactory.getLog(SchedulingServiceImpl.class);

    public SchedulingServiceImpl(TimeSourceService timeSourceService) {
        this.currentTime = timeSourceService.getTimeMillis() - 1L;
    }

    @Override
    public void destroy() {
        log.debug((Object)"Destroying scheduling service");
        this.handleSetMap.clear();
        this.timeHandleMap.clear();
    }

    @Override
    public long getTime() {
        return this.currentTime;
    }

    @Override
    public final synchronized void setTime(long currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public final synchronized void add(long afterMSec, ScheduleHandle handle, long slot) throws ScheduleServiceException {
        if (this.handleSetMap.containsKey(handle)) {
            this.remove(handle, slot);
        }
        long triggerOnTime = this.currentTime + afterMSec;
        this.addTrigger(slot, handle, triggerOnTime);
    }

    @Override
    public final synchronized void remove(ScheduleHandle handle, long slot) {
        SortedMap<Long, ScheduleHandle> handleSet = this.handleSetMap.get(handle);
        if (handleSet == null) {
            return;
        }
        handleSet.remove(slot);
        this.handleSetMap.remove(handle);
    }

    @Override
    public final synchronized void evaluate(Collection<ScheduleHandle> handles) {
        SortedMap<Long, SortedMap<Long, ScheduleHandle>> headMap = this.timeHandleMap.headMap(this.currentTime + 1L);
        if (headMap.isEmpty()) {
            return;
        }
        ArrayList<Long> removeKeys = new ArrayList<Long>();
        for (Map.Entry<Long, SortedMap<Long, ScheduleHandle>> entry : headMap.entrySet()) {
            Long key = entry.getKey();
            SortedMap<Long, ScheduleHandle> value = entry.getValue();
            removeKeys.add(key);
            for (ScheduleHandle handle : value.values()) {
                handles.add(handle);
            }
        }
        for (Map.Entry<Long, SortedMap<Long, ScheduleHandle>> entry : headMap.entrySet()) {
            for (ScheduleHandle handle : entry.getValue().values()) {
                this.handleSetMap.remove(handle);
            }
        }
        for (Long key : removeKeys) {
            this.timeHandleMap.remove(key);
        }
    }

    @Override
    public ScheduleSet take(Set<Integer> statementIds) {
        ArrayList<ScheduleSetEntry> list = new ArrayList<ScheduleSetEntry>();
        long currentTime = this.getTime();
        for (Map.Entry<Long, SortedMap<Long, ScheduleHandle>> schedule : this.timeHandleMap.entrySet()) {
            for (Map.Entry<Long, ScheduleHandle> entry : schedule.getValue().entrySet()) {
                if (!statementIds.contains(entry.getValue().getStatementId())) continue;
                long relative = schedule.getKey() - currentTime;
                list.add(new ScheduleSetEntry(relative, entry.getKey(), entry.getValue()));
            }
        }
        for (ScheduleSetEntry entry : list) {
            this.remove(entry.getHandle(), entry.getScheduleSlot());
        }
        return new ScheduleSet(list);
    }

    @Override
    public void apply(ScheduleSet scheduleSet) {
        for (ScheduleSetEntry entry : scheduleSet.getList()) {
            this.add(entry.getTime(), entry.getHandle(), entry.getScheduleSlot());
        }
    }

    @Override
    public void init() {
    }

    private void addTrigger(long slot, ScheduleHandle handle, long triggerTime) {
        TreeMap<Long, ScheduleHandle> handleSet = (TreeMap<Long, ScheduleHandle>)this.timeHandleMap.get(triggerTime);
        if (handleSet == null) {
            handleSet = new TreeMap<Long, ScheduleHandle>();
            this.timeHandleMap.put(triggerTime, handleSet);
        }
        handleSet.put(slot, handle);
        this.handleSetMap.put(handle, handleSet);
    }

    @Override
    @JmxGetter(name="TimeHandleCount", description="Number of outstanding time evaluations")
    public int getTimeHandleCount() {
        return this.timeHandleMap.size();
    }

    @JmxGetter(name="FurthestTimeHandle", description="Furthest outstanding time evaluation")
    public String getFurthestTimeHandleDate() {
        Long handle = this.getFurthestTimeHandle();
        if (handle != null) {
            return DateTime.print(handle);
        }
        return null;
    }

    @JmxGetter(name="NearestTimeHandle", description="Nearest outstanding time evaluation")
    public String getNearestTimeHandleDate() {
        Long handle = this.getNearestTimeHandle();
        if (handle != null) {
            return DateTime.print(handle);
        }
        return null;
    }

    @Override
    public Long getFurthestTimeHandle() {
        if (!this.timeHandleMap.isEmpty()) {
            return this.timeHandleMap.lastKey();
        }
        return null;
    }

    @Override
    public int getScheduleHandleCount() {
        return this.handleSetMap.size();
    }

    @Override
    public boolean isScheduled(ScheduleHandle handle) {
        return this.handleSetMap.containsKey(handle);
    }

    @Override
    public synchronized Long getNearestTimeHandle() {
        if (this.timeHandleMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<Long, SortedMap<Long, ScheduleHandle>> entry : this.timeHandleMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void visitSchedules(ScheduleVisitor visitor) {
        ScheduleVisit visit = new ScheduleVisit();
        for (Map.Entry<Long, SortedMap<Long, ScheduleHandle>> entry : this.timeHandleMap.entrySet()) {
            visit.setTimestamp(entry.getKey());
            for (Map.Entry<Long, ScheduleHandle> inner : entry.getValue().entrySet()) {
                visit.setStatementId(inner.getValue().getStatementId());
                visit.setAgentInstanceId(inner.getValue().getAgentInstanceId());
                visitor.visit(visit);
            }
        }
    }
}

