/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class SQLTypeMapUtil {
    private static Map<String, Integer> sqlTypeMap = new HashMap<String, Integer>();

    public static Class sqlTypeToClass(int sqlType, String className) {
        if (sqlType == 16 || sqlType == -7) {
            return Boolean.class;
        }
        if (sqlType == 1 || sqlType == 12 || sqlType == -1) {
            return String.class;
        }
        if (sqlType == 1 || sqlType == 12) {
            return String.class;
        }
        if (sqlType == 8 || sqlType == 6) {
            return Double.class;
        }
        if (sqlType == 7) {
            return Float.class;
        }
        if (sqlType == 4) {
            return Integer.class;
        }
        if (sqlType == -5) {
            return Long.class;
        }
        if (sqlType == -6) {
            return Byte.class;
        }
        if (sqlType == 5) {
            return Short.class;
        }
        if (sqlType == 2 || sqlType == 3) {
            return BigDecimal.class;
        }
        if (sqlType == -2 || sqlType == -3 || sqlType == -4) {
            return byte[].class;
        }
        if (sqlType == 91) {
            return Date.class;
        }
        if (sqlType == 92) {
            return Time.class;
        }
        if (sqlType == 93) {
            return Timestamp.class;
        }
        if (sqlType == 2005) {
            return Clob.class;
        }
        if (sqlType == 2004) {
            return Blob.class;
        }
        if (sqlType == 2003) {
            return Array.class;
        }
        if (sqlType == 2002) {
            return Struct.class;
        }
        if (sqlType == 2006) {
            return Ref.class;
        }
        if (sqlType == 70) {
            return URL.class;
        }
        if (sqlType == 2000 || sqlType == 2001) {
            if (className == null) {
                throw new IllegalArgumentException("No class supplied for sql type " + sqlType);
            }
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot load class for sql type " + sqlType + " and class " + className);
            }
        }
        throw new IllegalArgumentException("Cannot map java.sql.Types type " + sqlType);
    }

    public static int getSQLTypeByName(String type) {
        Integer val = sqlTypeMap.get(type.toUpperCase());
        if (val != null) {
            return val;
        }
        throw new RuntimeException("Type by name '" + type + "' is not a recognized java.sql.Types type");
    }

    static {
        sqlTypeMap.put("BIT", -7);
        sqlTypeMap.put("TINYINT", -6);
        sqlTypeMap.put("SMALLINT", 5);
        sqlTypeMap.put("INTEGER", 4);
        sqlTypeMap.put("BIGINT", -5);
        sqlTypeMap.put("FLOAT", 6);
        sqlTypeMap.put("REAL", 7);
        sqlTypeMap.put("DOUBLE", 8);
        sqlTypeMap.put("NUMERIC", 2);
        sqlTypeMap.put("DECIMAL", 3);
        sqlTypeMap.put("CHAR", 1);
        sqlTypeMap.put("VARCHAR", 12);
        sqlTypeMap.put("LONGVARCHAR", -1);
        sqlTypeMap.put("DATE", 91);
        sqlTypeMap.put("TIME", 92);
        sqlTypeMap.put("TIMESTAMP", 93);
        sqlTypeMap.put("BINARY", -2);
        sqlTypeMap.put("VARBINARY", -3);
        sqlTypeMap.put("LONGVARBINARY", -4);
        sqlTypeMap.put("NULL", 0);
        sqlTypeMap.put("OTHER", 1111);
        sqlTypeMap.put("JAVA_OBJECT", 2000);
        sqlTypeMap.put("DISTINCT", 2001);
        sqlTypeMap.put("STRUCT", 2002);
        sqlTypeMap.put("ARRAY", 2003);
        sqlTypeMap.put("BLOB", 2004);
        sqlTypeMap.put("CLOB", 2005);
        sqlTypeMap.put("REF", 2006);
        sqlTypeMap.put("DATALINK", 70);
        sqlTypeMap.put("BOOLEAN", 16);
    }
}

