/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.ObjectInputStreamWithTCCL;
import com.espertech.esper.util.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class SerializerFactory {
    private static final List<Serializer> serializers;
    private static final Serializer NULL_SERIALIZER;
    private static final Serializer OBJECT_SERIALIZER;

    public static Serializer[] getSerializers(Class[] classes) {
        Serializer[] serializers = new Serializer[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            serializers[i] = SerializerFactory.getSerializer(classes[i]);
        }
        return serializers;
    }

    public static Serializer getSerializer(Class clazz) {
        if (clazz == null) {
            return NULL_SERIALIZER;
        }
        for (Serializer serializer : serializers) {
            if (!serializer.accepts(JavaClassHelper.getBoxedType(clazz))) continue;
            return serializer;
        }
        return OBJECT_SERIALIZER;
    }

    public static byte[] serialize(Serializer[] serializers, Object[] objects) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(buf);
        for (int i = 0; i < serializers.length; ++i) {
            if (objects[i] == null) continue;
            serializers[i].serialize(objects[i], ds);
        }
        return buf.toByteArray();
    }

    public static Object[] deserialize(int numObjects, byte[] bytes, Serializer[] serializers) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(bytes);
        DataInputStream ds = new DataInputStream(buf);
        Object[] result = new Object[numObjects];
        for (int i = 0; i < serializers.length; ++i) {
            result[i] = serializers[i].deserialize(ds);
        }
        return result;
    }

    static {
        NULL_SERIALIZER = new Serializer(){

            @Override
            public boolean accepts(Class c) {
                throw new UnsupportedOperationException("Not supported for null serializer");
            }

            public void serialize(Object object, DataOutputStream stream) throws IOException {
            }

            public Object deserialize(DataInputStream stream) throws IOException {
                return null;
            }
        };
        OBJECT_SERIALIZER = new Serializer(){

            @Override
            public boolean accepts(Class c) {
                throw new UnsupportedOperationException("Not supported for object serializer");
            }

            public void serialize(Object object, DataOutputStream stream) throws IOException {
                new ObjectOutputStream(stream).writeObject(object);
            }

            public Object deserialize(DataInputStream stream) throws IOException {
                try {
                    return new ObjectInputStreamWithTCCL(stream).readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
        };
        serializers = new ArrayList<Serializer>();
        serializers.add(new Serializer<Integer>(){

            @Override
            public boolean accepts(Class c) {
                return Integer.class.equals((Object)c);
            }

            @Override
            public void serialize(Integer object, DataOutputStream stream) throws IOException {
                stream.writeInt(object);
            }

            @Override
            public Integer deserialize(DataInputStream stream) throws IOException {
                return stream.readInt();
            }
        });
        serializers.add(new Serializer<Long>(){

            @Override
            public boolean accepts(Class c) {
                return Long.class.equals((Object)c);
            }

            @Override
            public void serialize(Long object, DataOutputStream stream) throws IOException {
                stream.writeLong(object);
            }

            @Override
            public Long deserialize(DataInputStream stream) throws IOException {
                return stream.readLong();
            }
        });
        serializers.add(new Serializer<Float>(){

            @Override
            public boolean accepts(Class c) {
                return Float.class.equals((Object)c);
            }

            @Override
            public void serialize(Float object, DataOutputStream stream) throws IOException {
                stream.writeFloat(object.floatValue());
            }

            @Override
            public Float deserialize(DataInputStream stream) throws IOException {
                return Float.valueOf(stream.readFloat());
            }
        });
        serializers.add(new Serializer<Double>(){

            @Override
            public boolean accepts(Class c) {
                return Double.class.equals((Object)c);
            }

            @Override
            public void serialize(Double object, DataOutputStream stream) throws IOException {
                stream.writeDouble(object);
            }

            @Override
            public Double deserialize(DataInputStream stream) throws IOException {
                return stream.readDouble();
            }
        });
        serializers.add(new Serializer<Byte>(){

            @Override
            public boolean accepts(Class c) {
                return Byte.class.equals((Object)c);
            }

            @Override
            public void serialize(Byte object, DataOutputStream stream) throws IOException {
                stream.writeByte(object.byteValue());
            }

            @Override
            public Byte deserialize(DataInputStream stream) throws IOException {
                return stream.readByte();
            }
        });
        serializers.add(new Serializer<Short>(){

            @Override
            public boolean accepts(Class c) {
                return Short.class.equals((Object)c);
            }

            @Override
            public void serialize(Short object, DataOutputStream stream) throws IOException {
                stream.writeShort(object.shortValue());
            }

            @Override
            public Short deserialize(DataInputStream stream) throws IOException {
                return stream.readShort();
            }
        });
        serializers.add(new Serializer<String>(){

            @Override
            public boolean accepts(Class c) {
                return String.class.equals((Object)c);
            }

            @Override
            public void serialize(String object, DataOutputStream stream) throws IOException {
                stream.writeUTF(object);
            }

            @Override
            public String deserialize(DataInputStream stream) throws IOException {
                return stream.readUTF();
            }
        });
        serializers.add(new Serializer<Boolean>(){

            @Override
            public boolean accepts(Class c) {
                return Boolean.class.equals((Object)c);
            }

            @Override
            public void serialize(Boolean object, DataOutputStream stream) throws IOException {
                stream.writeBoolean(object);
            }

            @Override
            public Boolean deserialize(DataInputStream stream) throws IOException {
                return stream.readBoolean();
            }
        });
    }
}

