/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConstMsec;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;

public class ViewFactoryTimePeriodHelper {
    public static ExprTimePeriodEvalDeltaConst validateAndEvaluateTimeDelta(String viewName, StatementContext statementContext, ExprNode expression, String expectedMessage, int expressionNumber) throws ViewParameterException {
        ExprTimePeriodEvalDeltaConst timeDelta;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(statementContext.getEngineURI(), false);
        if (expression instanceof ExprTimePeriod) {
            ExprTimePeriod validated = (ExprTimePeriod)ViewFactorySupport.validateExpr(viewName, statementContext, expression, streamTypeService, expressionNumber);
            timeDelta = validated.constEvaluator(new ExprEvaluatorContextStatement(statementContext, false));
        } else {
            Object result = ViewFactorySupport.validateAndEvaluateExpr(viewName, statementContext, expression, streamTypeService, expressionNumber);
            if (!(result instanceof Number)) {
                throw new ViewParameterException(expectedMessage);
            }
            Number param = (Number)result;
            long millisecondsBeforeExpiry = JavaClassHelper.isFloatingPointNumber(param) ? Math.round(1000.0 * param.doubleValue()) : 1000L * param.longValue();
            timeDelta = new ExprTimePeriodEvalDeltaConstMsec(millisecondsBeforeExpiry);
        }
        if (timeDelta.deltaMillisecondsAdd(0L) < 1L) {
            throw new ViewParameterException(viewName + " view requires a size of at least 1 msec");
        }
        return timeDelta;
    }
}

