/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.annotation.Audit;
import com.espertech.esper.client.annotation.AuditEnum;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.epl.virtualdw.VirtualDWViewFactory;
import com.espertech.esper.view.DataWindowViewFactoryUniqueCandidate;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewEnum;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactoryProxy;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.std.GroupByViewFactoryMarker;
import com.espertech.esper.view.std.MergeViewFactoryMarker;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewServiceHelper {
    private static final Log log = LogFactory.getLog(ViewServiceHelper.class);

    public static Set<String> getUniqueCandidateProperties(List<ViewFactory> viewFactory, Annotation[] annotations) {
        boolean disableUniqueImplicit;
        boolean bl = disableUniqueImplicit = HintEnum.DISABLE_UNIQUE_IMPLICIT_IDX.getHint(annotations) != null;
        if (viewFactory == null || viewFactory.isEmpty()) {
            return null;
        }
        if (viewFactory.get(0) instanceof GroupByViewFactoryMarker) {
            ExprNode[] criteria = ((GroupByViewFactoryMarker)((Object)viewFactory.get(0))).getCriteriaExpressions();
            Set<String> groupedCriteria = ExprNodeUtility.getPropertyNamesIfAllProps(criteria);
            if (groupedCriteria == null) {
                return null;
            }
            if (viewFactory.get(1) instanceof DataWindowViewFactoryUniqueCandidate && !disableUniqueImplicit) {
                DataWindowViewFactoryUniqueCandidate uniqueFactory = (DataWindowViewFactoryUniqueCandidate)((Object)viewFactory.get(1));
                Set<String> uniqueCandidates = uniqueFactory.getUniquenessCandidatePropertyNames();
                if (uniqueCandidates != null) {
                    uniqueCandidates.addAll(groupedCriteria);
                }
                return uniqueCandidates;
            }
            return null;
        }
        if (viewFactory.get(0) instanceof DataWindowViewFactoryUniqueCandidate && !disableUniqueImplicit) {
            DataWindowViewFactoryUniqueCandidate uniqueFactory = (DataWindowViewFactoryUniqueCandidate)((Object)viewFactory.get(0));
            return uniqueFactory.getUniquenessCandidatePropertyNames();
        }
        if (viewFactory.get(0) instanceof VirtualDWViewFactory) {
            VirtualDWViewFactory vdw = (VirtualDWViewFactory)((Object)viewFactory.get(0));
            return vdw.getUniqueKeys();
        }
        return null;
    }

    protected static void addMergeViews(List<ViewSpec> specifications) throws ViewProcessingException {
        ViewSpec lastView;
        ViewEnum viewEnum;
        if (log.isDebugEnabled()) {
            log.debug((Object)(".addMergeViews Incoming specifications=" + Arrays.toString(specifications.toArray())));
        }
        if (specifications.size() > 0 && (viewEnum = ViewEnum.forName((lastView = specifications.get(specifications.size() - 1)).getObjectNamespace(), lastView.getObjectName())) != null && viewEnum.getMergeView() != null) {
            throw new ViewProcessingException("Invalid use of the '" + lastView.getObjectNamespace() + ":" + lastView.getObjectName() + "' view, the view requires one or more child views to group, or consider using the group-by clause");
        }
        LinkedList<ViewSpec> mergeViewSpecs = new LinkedList<ViewSpec>();
        for (ViewSpec spec : specifications) {
            ViewEnum viewEnum2 = ViewEnum.forName(spec.getObjectNamespace(), spec.getObjectName());
            if (viewEnum2 == null || viewEnum2.getMergeView() == null) continue;
            ViewSpec mergeViewSpec = new ViewSpec(viewEnum2.getMergeView().getNamespace(), viewEnum2.getMergeView().getName(), spec.getObjectParameters());
            mergeViewSpecs.addFirst(mergeViewSpec);
        }
        specifications.addAll(mergeViewSpecs);
        if (log.isDebugEnabled()) {
            log.debug((Object)(".addMergeViews Outgoing specifications=" + Arrays.toString(specifications.toArray())));
        }
    }

    public static List<View> instantiateChain(Viewable parentViewable, List<ViewFactory> viewFactories, AgentInstanceViewFactoryChainContext viewFactoryChainContext) {
        LinkedList<View> newViews = new LinkedList<View>();
        Viewable parent = parentViewable;
        for (int i = 0; i < viewFactories.size(); ++i) {
            ViewFactory viewFactory = viewFactories.get(i);
            View currentView = viewFactory.makeView(viewFactoryChainContext);
            newViews.add(currentView);
            parent.addView(currentView);
            parent = currentView;
        }
        return newViews;
    }

    public static void removeFirstUnsharedView(List<View> childViews) {
        for (int i = childViews.size() - 1; i >= 0; --i) {
            View child = childViews.get(i);
            Viewable parent = child.getParent();
            if (parent == null) {
                return;
            }
            parent.removeView(child);
            if (!parent.hasViews()) continue;
            return;
        }
    }

    protected static List<View> removeChainLeafView(Viewable parentViewable, Viewable viewToRemove) {
        LinkedList<View> removedViews = new LinkedList<View>();
        if (viewToRemove.hasViews()) {
            return removedViews;
        }
        List<View> viewPath = ViewSupport.findDescendent(parentViewable, viewToRemove);
        if (viewPath == null) {
            String message = "Viewable not found when removing view " + viewToRemove;
            throw new IllegalArgumentException(message);
        }
        if (viewPath.isEmpty()) {
            boolean isViewRemoved = parentViewable.removeView((View)viewToRemove);
            if (!isViewRemoved) {
                String message = "Failed to remove immediate child view " + viewToRemove;
                log.fatal((Object)(".remove " + message));
                throw new IllegalStateException(message);
            }
            removedViews.add((View)viewToRemove);
            return removedViews;
        }
        View[] viewPathArray = viewPath.toArray(new View[viewPath.size()]);
        View currentView = (View)viewToRemove;
        for (int index = viewPathArray.length - 1; index >= 0; --index) {
            boolean isViewRemoved = viewPathArray[index].removeView(currentView);
            removedViews.add(currentView);
            if (!isViewRemoved) {
                String message = "Failed to remove view " + currentView;
                log.fatal((Object)(".remove " + message));
                throw new IllegalStateException(message);
            }
            if (viewPathArray[index].hasViews()) break;
            if (index == 0) {
                parentViewable.removeView(viewPathArray[0]);
                removedViews.add(viewPathArray[0]);
                continue;
            }
            currentView = viewPathArray[index];
        }
        return removedViews;
    }

    protected static Pair<Viewable, List<View>> matchExistingViews(Viewable rootViewable, List<ViewFactory> viewFactories) {
        boolean foundMatch;
        Viewable currentParent = rootViewable;
        LinkedList<View> matchedViewList = new LinkedList<View>();
        if (viewFactories.isEmpty()) {
            return new Pair<Viewable, List<View>>(rootViewable, Collections.emptyList());
        }
        block0: do {
            foundMatch = false;
            for (View childView : currentParent.getViews()) {
                ViewFactory currentFactory = viewFactories.get(0);
                if (!currentFactory.canReuse(childView)) continue;
                viewFactories.remove(0);
                currentParent = childView;
                foundMatch = true;
                matchedViewList.add(childView);
                continue block0;
            }
        } while (foundMatch && !viewFactories.isEmpty());
        return new Pair<Viewable, List<View>>(currentParent, matchedViewList);
    }

    public static List<ViewFactory> instantiateFactories(int streamNum, List<ViewSpec> viewSpecList, StatementContext statementContext, boolean isSubquery, int subqueryNumber) throws ViewProcessingException {
        ArrayList<ViewFactory> factoryChain = new ArrayList<ViewFactory>();
        boolean grouped = false;
        for (ViewSpec spec : viewSpecList) {
            ViewFactory viewFactory = statementContext.getViewResolutionService().create(spec.getObjectNamespace(), spec.getObjectName());
            Audit audit = AuditEnum.VIEW.getAudit(statementContext.getAnnotations());
            if (audit != null) {
                viewFactory = (ViewFactory)ViewFactoryProxy.newInstance(statementContext.getEngineURI(), statementContext.getStatementName(), viewFactory, spec.getObjectName());
            }
            factoryChain.add(viewFactory);
            try {
                ViewFactoryContext context = new ViewFactoryContext(statementContext, streamNum, spec.getObjectNamespace(), spec.getObjectName(), isSubquery, subqueryNumber, grouped);
                viewFactory.setViewParameters(context, spec.getObjectParameters());
            }
            catch (ViewParameterException e) {
                throw new ViewProcessingException("Error in view '" + spec.getObjectNamespace() + ':' + spec.getObjectName() + "', " + e.getMessage());
            }
            if (viewFactory instanceof GroupByViewFactoryMarker) {
                grouped = true;
            }
            if (!(viewFactory instanceof MergeViewFactoryMarker)) continue;
            grouped = false;
        }
        return factoryChain;
    }
}

