/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import java.util.Iterator;

public final class ZeroDepthStreamIterable
implements EventStream {
    private View[] children = ViewSupport.EMPTY_VIEW_ARRAY;
    private final EventType eventType;
    private EventBean lastInsertedEvent;
    private EventBean[] lastInsertedEvents;

    public ZeroDepthStreamIterable(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void insert(EventBean[] events) {
        for (View childView : this.children) {
            childView.update(events, null);
        }
        this.lastInsertedEvents = events;
    }

    @Override
    public final void insert(EventBean theEvent) {
        EventBean[] row = new EventBean[]{theEvent};
        for (View childView : this.children) {
            childView.update(row, null);
        }
        this.lastInsertedEvent = theEvent;
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        if (this.lastInsertedEvents != null) {
            return new ArrayEventIterator(this.lastInsertedEvents);
        }
        return new SingleEventIterator(this.lastInsertedEvent);
    }

    @Override
    public final View addView(View view) {
        this.children = ViewSupport.addView(this.children, view);
        view.setParent(this);
        return view;
    }

    @Override
    public final View[] getViews() {
        return this.children;
    }

    @Override
    public final boolean removeView(View view) {
        int index = ViewSupport.findViewIndex(this.children, view);
        if (index == -1) {
            return false;
        }
        this.children = ViewSupport.removeView(this.children, index);
        view.setParent(null);
        return true;
    }

    @Override
    public final boolean hasViews() {
        return this.children.length > 0;
    }

    @Override
    public void removeAllViews() {
        this.children = ViewSupport.EMPTY_VIEW_ARRAY;
    }
}

