/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitableContainer;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.internal.IntersectDefaultViewLocalState;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.IntersectViewMarker;
import com.espertech.esper.view.internal.LastPostObserver;
import com.espertech.esper.view.internal.LastPostObserverView;
import com.espertech.esper.view.internal.ViewContainer;
import java.util.Iterator;
import java.util.List;

public class IntersectDefaultView
extends ViewSupport
implements LastPostObserver,
CloneableView,
StoppableView,
DataWindowView,
IntersectViewMarker,
ViewDataVisitableContainer,
ViewContainer {
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final IntersectViewFactory factory;
    protected final View[] views;

    public IntersectDefaultView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, IntersectViewFactory factory, List<View> viewList) {
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.factory = factory;
        this.views = viewList.toArray(new View[viewList.size()]);
        for (int i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].removeAllViews();
            this.views[i].addView(view);
            view.setObserver(this);
        }
    }

    @Override
    public View[] getViewContained() {
        return this.views;
    }

    @Override
    public View cloneView() {
        return this.factory.makeView(this.agentInstanceViewFactoryContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        IntersectDefaultViewLocalState localState = this.factory.getDefaultViewLocalStatePerThread();
        if (newData != null) {
            localState.setHasRemovestreamData(false);
            localState.setIsRetainObserverEvents(true);
            try {
                for (View view : this.views) {
                    view.update(newData, oldData);
                }
            }
            finally {
                localState.setIsRetainObserverEvents(false);
            }
            if (localState.hasRemovestreamData()) {
                localState.getRemovalEvents().clear();
                for (int i = 0; i < localState.getOldEventsPerView().length; ++i) {
                    if (localState.getOldEventsPerView()[i] == null) continue;
                    EventBean[] viewOldData = localState.getOldEventsPerView()[i];
                    localState.getOldEventsPerView()[i] = null;
                    for (EventBean oldEvent : viewOldData) {
                        localState.getRemovalEvents().add(oldEvent);
                    }
                    localState.setIsDiscardObserverEvents(true);
                    try {
                        for (int j = 0; j < this.views.length; ++j) {
                            if (i == j) continue;
                            this.views[j].update(null, viewOldData);
                        }
                        continue;
                    }
                    finally {
                        localState.setIsDiscardObserverEvents(false);
                    }
                }
                oldData = localState.getRemovalEvents().toArray(new EventBean[localState.getRemovalEvents().size()]);
            }
            this.updateChildren(newData, oldData);
        } else if (oldData != null) {
            localState.setIsDiscardObserverEvents(true);
            try {
                for (View view : this.views) {
                    view.update(null, oldData);
                }
            }
            finally {
                localState.setIsDiscardObserverEvents(false);
            }
            this.updateChildren(null, oldData);
        }
    }

    @Override
    public EventType getEventType() {
        return this.factory.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.views[0].iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        IntersectDefaultViewLocalState localState = this.factory.getDefaultViewLocalStatePerThread();
        if (oldEvents == null || localState.isDiscardObserverEvents()) {
            return;
        }
        if (localState.isRetainObserverEvents()) {
            localState.getOldEventsPerView()[streamId] = oldEvents;
            localState.setHasRemovestreamData(true);
            return;
        }
        localState.setIsDiscardObserverEvents(true);
        try {
            for (int i = 0; i < this.views.length; ++i) {
                if (i == streamId) continue;
                this.views[i].update(null, oldEvents);
            }
        }
        finally {
            localState.setIsDiscardObserverEvents(false);
        }
        this.updateChildren(null, oldEvents);
    }

    @Override
    public void stop() {
        for (View view : this.views) {
            if (!(view instanceof StoppableView)) continue;
            ((StoppableView)((Object)view)).stop();
        }
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        IntersectDefaultView.visitViewContained(viewDataVisitor, this.factory, this.views);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        throw new UnsupportedOperationException();
    }

    public static void visitViewContained(ViewDataVisitorContained viewDataVisitor, ViewFactory viewFactory, View[] views) {
        viewDataVisitor.visitPrimary(viewFactory.getViewName(), views.length);
        for (int i = 0; i < views.length; ++i) {
            viewDataVisitor.visitContained(i, views[i]);
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

