/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.view.AsymetricDataWindowViewFactory;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewFactoryUniqueCandidate;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.internal.IntersectAsymetricView;
import com.espertech.esper.view.internal.IntersectAsymetricViewLocalState;
import com.espertech.esper.view.internal.IntersectBatchView;
import com.espertech.esper.view.internal.IntersectBatchViewLocalState;
import com.espertech.esper.view.internal.IntersectDefaultView;
import com.espertech.esper.view.internal.IntersectDefaultViewLocalState;
import com.espertech.esper.view.internal.ViewFactoryContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class IntersectViewFactory
implements ViewFactory,
DataWindowViewFactory,
DataWindowViewFactoryUniqueCandidate,
ViewFactoryContainer {
    protected EventType parentEventType;
    protected List<ViewFactory> viewFactories;
    protected int batchViewIndex;
    protected boolean hasAsymetric;
    protected ThreadLocal<IntersectBatchViewLocalState> batchViewLocalState;
    protected ThreadLocal<IntersectDefaultViewLocalState> defaultViewLocalState;
    protected ThreadLocal<IntersectAsymetricViewLocalState> asymetricViewLocalState;

    public void setParentEventType(EventType parentEventType) {
        this.parentEventType = parentEventType;
    }

    public void setViewFactories(final List<ViewFactory> viewFactories) {
        this.viewFactories = viewFactories;
        int batchCount = 0;
        for (int i = 0; i < viewFactories.size(); ++i) {
            ViewFactory viewFactory = viewFactories.get(i);
            this.hasAsymetric |= viewFactory instanceof AsymetricDataWindowViewFactory;
            if (!(viewFactory instanceof DataWindowBatchingViewFactory)) continue;
            ++batchCount;
            this.batchViewIndex = i;
        }
        if (batchCount > 1) {
            throw new ViewProcessingException("Cannot combined multiple batch data windows into an intersection");
        }
        if (batchCount == 1) {
            this.batchViewLocalState = new ThreadLocal<IntersectBatchViewLocalState>(){

                @Override
                protected synchronized IntersectBatchViewLocalState initialValue() {
                    return new IntersectBatchViewLocalState(new EventBean[viewFactories.size()][], new EventBean[viewFactories.size()][]);
                }
            };
        } else if (this.hasAsymetric) {
            this.asymetricViewLocalState = new ThreadLocal<IntersectAsymetricViewLocalState>(){

                @Override
                protected synchronized IntersectAsymetricViewLocalState initialValue() {
                    return new IntersectAsymetricViewLocalState(new EventBean[viewFactories.size()][]);
                }
            };
        } else {
            this.defaultViewLocalState = new ThreadLocal<IntersectDefaultViewLocalState>(){

                @Override
                protected synchronized IntersectDefaultViewLocalState initialValue() {
                    return new IntersectDefaultViewLocalState(new EventBean[viewFactories.size()][]);
                }
            };
        }
    }

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> viewParameters) throws ViewParameterException {
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ArrayList<View> views = new ArrayList<View>();
        boolean hasBatch = false;
        for (ViewFactory viewFactory : this.viewFactories) {
            agentInstanceViewFactoryContext.setRemoveStream(true);
            views.add(viewFactory.makeView(agentInstanceViewFactoryContext));
            hasBatch |= viewFactory instanceof DataWindowBatchingViewFactory;
        }
        if (hasBatch) {
            return new IntersectBatchView(agentInstanceViewFactoryContext, this, views);
        }
        if (this.hasAsymetric) {
            return new IntersectAsymetricView(agentInstanceViewFactoryContext, this, views);
        }
        return new IntersectDefaultView(agentInstanceViewFactoryContext, this, views);
    }

    @Override
    public EventType getEventType() {
        return this.parentEventType;
    }

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    @Override
    public Set<String> getUniquenessCandidatePropertyNames() {
        for (ViewFactory viewFactory : this.viewFactories) {
            DataWindowViewFactoryUniqueCandidate unique;
            Set<String> props;
            if (!(viewFactory instanceof DataWindowViewFactoryUniqueCandidate) || (props = (unique = (DataWindowViewFactoryUniqueCandidate)((Object)viewFactory)).getUniquenessCandidatePropertyNames()) == null) continue;
            return props;
        }
        return null;
    }

    @Override
    public String getViewName() {
        return IntersectViewFactory.getViewNameUnionIntersect(true, this.viewFactories);
    }

    @Override
    public Collection<ViewFactory> getViewFactoriesContained() {
        return this.viewFactories;
    }

    protected static String getViewNameUnionIntersect(boolean intersect, Collection<ViewFactory> factories) {
        StringBuilder buf = new StringBuilder();
        buf.append(intersect ? "Intersection" : "Union");
        if (factories == null) {
            return buf.toString();
        }
        buf.append(" of ");
        String delimiter = "";
        for (ViewFactory factory : factories) {
            buf.append(delimiter);
            buf.append(factory.getViewName());
            delimiter = ",";
        }
        return buf.toString();
    }

    public EventType getParentEventType() {
        return this.parentEventType;
    }

    public int getBatchViewIndex() {
        return this.batchViewIndex;
    }

    public boolean isHasAsymetric() {
        return this.hasAsymetric;
    }

    public IntersectBatchViewLocalState getBatchViewLocalStatePerThread() {
        return this.batchViewLocalState.get();
    }

    public IntersectDefaultViewLocalState getDefaultViewLocalStatePerThread() {
        return this.defaultViewLocalState.get();
    }

    public IntersectAsymetricViewLocalState getAsymetricViewLocalStatePerThread() {
        return this.asymetricViewLocalState.get();
    }
}

