/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.internal;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.prior.ExprPriorNode;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.internal.PriorEventBufferMulti;
import com.espertech.esper.view.internal.PriorEventBufferSingle;
import com.espertech.esper.view.internal.PriorEventBufferUnbound;
import com.espertech.esper.view.internal.PriorEventView;
import java.util.List;
import java.util.SortedMap;

public class PriorEventViewFactory
implements ViewFactory {
    private EventType eventType;
    protected boolean isUnbound;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        List<Object> viewParameters = ViewFactorySupport.validateAndEvaluate(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters);
        if (viewParameters.size() != 1) {
            throw new ViewParameterException("View requires a single parameter indicating unbound or not");
        }
        this.isUnbound = (Boolean)viewParameters.get(0);
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new PriorEventView(agentInstanceViewFactoryContext.getPriorViewUpdatedCollection());
    }

    public ViewUpdatedCollection makeViewUpdatedCollection(SortedMap<Integer, List<ExprPriorNode>> callbacksPerIndex, int agentInstanceId) {
        if (callbacksPerIndex.isEmpty()) {
            throw new IllegalStateException("No resources requested");
        }
        int[] requested = new int[callbacksPerIndex.size()];
        int count = 0;
        for (int reqIndex : callbacksPerIndex.keySet()) {
            requested[count++] = reqIndex;
        }
        if (this.isUnbound) {
            return new PriorEventBufferUnbound(callbacksPerIndex.lastKey());
        }
        if (requested.length == 1) {
            return new PriorEventBufferSingle(requested[0]);
        }
        return new PriorEventBufferMulti(requested);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        return false;
    }

    @Override
    public String getViewName() {
        return "Prior-Event";
    }
}

