/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AddPropertyValueOptionalView
extends ViewSupport
implements CloneableView,
StoppableView {
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final String[] propertyNames;
    private final Object propertyValues;
    private final EventType eventType;
    private boolean mustAddProperty;
    private Map<EventBean, EventBean> newToOldEventMap;
    private static final Log log = LogFactory.getLog(AddPropertyValueOptionalView.class);

    public AddPropertyValueOptionalView(AgentInstanceViewFactoryChainContext agentInstanceContext, String[] propertyNames, Object mergeValues, EventType mergedResultEventType) {
        this.propertyNames = propertyNames;
        this.propertyValues = mergeValues;
        this.eventType = mergedResultEventType;
        this.agentInstanceContext = agentInstanceContext;
        this.newToOldEventMap = Collections.emptyMap();
    }

    @Override
    public View cloneView() {
        return new AddPropertyValueOptionalView(this.agentInstanceContext, this.propertyNames, this.propertyValues, this.eventType);
    }

    @Override
    public void setParent(Viewable parent) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(".setParent parent=" + parent));
        }
        super.setParent(parent);
        if (parent.getEventType() != this.eventType) {
            this.mustAddProperty = true;
            this.newToOldEventMap = new HashMap<EventBean, EventBean>();
        } else {
            this.mustAddProperty = false;
        }
    }

    public final String[] getPropertyNames() {
        return this.propertyNames;
    }

    public final Object getPropertyValues() {
        return this.propertyValues;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        int index;
        if (!this.mustAddProperty) {
            this.updateChildren(newData, oldData);
            return;
        }
        EventBean[] newEvents = null;
        EventBean[] oldEvents = null;
        if (newData != null) {
            newEvents = new EventBean[newData.length];
            index = 0;
            for (EventBean newEvent : newData) {
                EventBean theEvent = AddPropertyValueOptionalView.addProperty(newEvent, this.propertyNames, this.propertyValues, this.eventType, this.agentInstanceContext.getStatementContext().getEventAdapterService());
                newEvents[index++] = theEvent;
                this.newToOldEventMap.put(newEvent, theEvent);
            }
        }
        if (oldData != null) {
            oldEvents = new EventBean[oldData.length];
            index = 0;
            for (EventBean oldEvent : oldData) {
                EventBean outgoing = this.newToOldEventMap.remove(oldEvent);
                if (outgoing != null) {
                    oldEvents[index++] = outgoing;
                    continue;
                }
                EventBean theEvent = AddPropertyValueOptionalView.addProperty(oldEvent, this.propertyNames, this.propertyValues, this.eventType, this.agentInstanceContext.getStatementContext().getEventAdapterService());
                oldEvents[index++] = theEvent;
            }
        }
        this.updateChildren(newEvents, oldEvents);
    }

    @Override
    public final EventType getEventType() {
        return this.eventType;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        final Iterator<EventBean> parentIterator = this.parent.iterator();
        return new Iterator<EventBean>(){

            @Override
            public boolean hasNext() {
                return parentIterator.hasNext();
            }

            @Override
            public EventBean next() {
                EventBean nextEvent = (EventBean)parentIterator.next();
                if (AddPropertyValueOptionalView.this.mustAddProperty) {
                    return AddPropertyValueOptionalView.addProperty(nextEvent, AddPropertyValueOptionalView.this.propertyNames, AddPropertyValueOptionalView.this.propertyValues, AddPropertyValueOptionalView.this.eventType, AddPropertyValueOptionalView.this.agentInstanceContext.getStatementContext().getEventAdapterService());
                }
                return nextEvent;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void stop() {
        if (!this.newToOldEventMap.isEmpty()) {
            OneEventCollection oldEvents = new OneEventCollection();
            for (Map.Entry<EventBean, EventBean> oldEvent : this.newToOldEventMap.entrySet()) {
                oldEvents.add(oldEvent.getValue());
            }
            if (!oldEvents.isEmpty()) {
                this.updateChildren(null, oldEvents.toArray());
            }
            this.newToOldEventMap.clear();
        }
    }

    protected static EventBean addProperty(EventBean originalEvent, String[] propertyNames, Object propertyValues, EventType targetEventType, EventAdapterService eventAdapterService) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (propertyValues instanceof MultiKeyUntyped) {
            MultiKeyUntyped props = (MultiKeyUntyped)propertyValues;
            Object[] propertyValuesArr = props.getKeys();
            for (int i = 0; i < propertyNames.length; ++i) {
                values.put(propertyNames[i], propertyValuesArr[i]);
            }
        } else {
            values.put(propertyNames[0], propertyValues);
        }
        return eventAdapterService.adapterForTypedWrapper(originalEvent, values, targetEventType);
    }

    public final String toString() {
        return this.getClass().getName() + " propertyNames=" + Arrays.toString(this.propertyNames) + " propertyValue=" + this.propertyValues;
    }
}

