/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.GroupableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.AddPropertyValueOptionalView;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.MergeView;
import com.espertech.esper.view.std.MergeViewMarker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupByViewImpl
extends ViewSupport
implements CloneableView,
GroupByView {
    public static final String VIEWNAME = "Group-By";
    private final ExprNode[] criteriaExpressions;
    private final ExprEvaluator[] criteriaEvaluators;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected String[] propertyNames;
    protected final Map<Object, Object> subViewsPerKey = new HashMap<Object, Object>();
    private final HashMap<Object, Pair<Object, Object>> groupedEvents = new HashMap();
    private static final Log log = LogFactory.getLog(GroupByViewImpl.class);

    public GroupByViewImpl(AgentInstanceViewFactoryChainContext agentInstanceContext, ExprNode[] criteriaExpressions, ExprEvaluator[] criteriaEvaluators) {
        this.agentInstanceContext = agentInstanceContext;
        this.criteriaExpressions = criteriaExpressions;
        this.criteriaEvaluators = criteriaEvaluators;
        this.propertyNames = new String[criteriaExpressions.length];
        for (int i = 0; i < criteriaExpressions.length; ++i) {
            this.propertyNames[i] = ExprNodeUtility.toExpressionStringMinPrecedenceSafe(criteriaExpressions[i]);
        }
    }

    @Override
    public View cloneView() {
        return new GroupByViewImpl(this.agentInstanceContext, this.criteriaExpressions, this.criteriaEvaluators);
    }

    @Override
    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean theEvent = newData[0];
            EventBean[] newDataToPost = new EventBean[]{theEvent};
            Object groupByValuesKey = this.getGroupKey(theEvent);
            Object subViews = this.subViewsPerKey.get(groupByValuesKey);
            if (subViews == null) {
                subViews = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey, this.agentInstanceContext);
                this.subViewsPerKey.put(groupByValuesKey, subViews);
            }
            GroupByViewImpl.updateChildViews(subViews, newDataToPost, null);
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry<Object, Pair<Object, Object>> entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = GroupByViewImpl.convertToArray(entry.getValue().getFirst());
                EventBean[] oldEvents = GroupByViewImpl.convertToArray(entry.getValue().getSecond());
                GroupByViewImpl.updateChildViews(entry.getKey(), newEvents, oldEvents);
            }
            this.groupedEvents.clear();
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.criteriaExpressions);
    }

    public static Object makeSubViews(GroupByView groupView, String[] propertyNames, Object groupByValues, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        Iterable<View> subviewHolder;
        if (!groupView.hasViews()) {
            String message = "Unexpected empty list of child nodes for group view";
            log.fatal((Object)(".copySubViews " + message));
            throw new EPException(message);
        }
        if (groupView.getViews().length == 1) {
            subviewHolder = GroupByViewImpl.copyChildView(groupView, propertyNames, groupByValues, agentInstanceContext, groupView.getViews()[0]);
        } else {
            ArrayList<View> subViewList;
            subviewHolder = subViewList = new ArrayList<View>(4);
            for (View originalChildView : groupView.getViews()) {
                View copyChildView = GroupByViewImpl.copyChildView(groupView, propertyNames, groupByValues, agentInstanceContext, originalChildView);
                subViewList.add(copyChildView);
            }
        }
        return subviewHolder;
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        viewDataVisitor.visitPrimary(VIEWNAME, this.subViewsPerKey.size());
        for (Map.Entry<Object, Object> entry : this.subViewsPerKey.entrySet()) {
            GroupByViewImpl.visitView(viewDataVisitor, entry.getKey(), entry.getValue());
        }
    }

    public static void visitView(ViewDataVisitorContained viewDataVisitor, Object groupkey, Object subviewHolder) {
        Collection deque;
        Iterator i$;
        if (subviewHolder == null) {
            return;
        }
        if (subviewHolder instanceof View) {
            viewDataVisitor.visitContained(groupkey, (View)subviewHolder);
            return;
        }
        if (subviewHolder instanceof Collection && (i$ = (deque = (Collection)subviewHolder).iterator()).hasNext()) {
            View view = (View)i$.next();
            viewDataVisitor.visitContained(groupkey, view);
            return;
        }
    }

    @Override
    public boolean removeView(View view) {
        boolean removed;
        if (!(view instanceof GroupableView)) {
            super.removeView(view);
        }
        if (!(removed = super.removeView(view))) {
            return false;
        }
        if (!this.hasViews()) {
            this.subViewsPerKey.clear();
            return true;
        }
        GroupableView removedView = (GroupableView)((Object)view);
        ArrayDeque<Object> removedKeys = null;
        block0: for (Map.Entry<Object, Object> entry : this.subViewsPerKey.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof View) {
                GroupableView subview = (GroupableView)value;
                if (!this.compareViews(subview, removedView)) continue;
                if (removedKeys == null) {
                    removedKeys = new ArrayDeque<Object>();
                }
                removedKeys.add(entry.getKey());
                continue;
            }
            if (!(value instanceof List)) continue;
            List subviews = (List)value;
            for (int i = 0; i < subviews.size(); ++i) {
                GroupableView subview = (GroupableView)subviews.get(i);
                if (!this.compareViews(subview, removedView)) continue;
                subviews.remove(i);
                if (!subviews.isEmpty()) continue block0;
                if (removedKeys == null) {
                    removedKeys = new ArrayDeque();
                }
                removedKeys.add(entry.getKey());
                continue block0;
            }
        }
        if (removedKeys != null) {
            for (Map.Entry<Object, Object> entry : removedKeys) {
                this.subViewsPerKey.remove(entry);
            }
        }
        return true;
    }

    private boolean compareViews(GroupableView subview, GroupableView removed) {
        return subview.getViewFactory() == removed.getViewFactory();
    }

    protected static void updateChildViews(Object subViews, EventBean[] newData, EventBean[] oldData) {
        if (subViews instanceof List) {
            List viewList = (List)subViews;
            ViewSupport.updateChildren(viewList, newData, oldData);
        } else {
            ((View)subViews).update(newData, oldData);
        }
    }

    private void handleEvent(EventBean theEvent, boolean isNew) {
        Pair<Object, Object> pair;
        Object groupByValuesKey = this.getGroupKey(theEvent);
        Object subViews = this.subViewsPerKey.get(groupByValuesKey);
        if (subViews == null) {
            subViews = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey, this.agentInstanceContext);
            this.subViewsPerKey.put(groupByValuesKey, subViews);
        }
        if ((pair = this.groupedEvents.get(subViews)) == null) {
            pair = new Pair<Object, Object>(null, null);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.setFirst(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getFirst(), theEvent));
        } else {
            pair.setSecond(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getSecond(), theEvent));
        }
    }

    private static View copyChildView(GroupByView groupView, String[] propertyNames, Object groupByValues, AgentInstanceViewFactoryChainContext agentInstanceContext, View originalChildView) {
        if (originalChildView instanceof MergeView) {
            String message = "Unexpected merge view as child of group-by view";
            log.fatal((Object)(".copySubViews " + message));
            throw new EPException(message);
        }
        if (!(originalChildView instanceof CloneableView)) {
            throw new EPException("Unexpected error copying subview " + originalChildView.getClass().getName());
        }
        CloneableView cloneableView = (CloneableView)((Object)originalChildView);
        View copyChildView = cloneableView.cloneView();
        copyChildView.setParent(groupView);
        GroupByViewImpl.copySubViews(groupView.getCriteriaExpressions(), propertyNames, groupByValues, originalChildView, copyChildView, agentInstanceContext);
        return copyChildView;
    }

    private static void copySubViews(ExprNode[] criteriaExpressions, String[] propertyNames, Object groupByValues, View originalView, View copyView, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        for (View subView : originalView.getViews()) {
            MergeViewMarker mergeView;
            if (subView instanceof MergeViewMarker && ExprNodeUtility.deepEquals((mergeView = (MergeViewMarker)subView).getGroupFieldNames(), criteriaExpressions)) {
                if (mergeView.getEventType() != copyView.getEventType()) {
                    AddPropertyValueOptionalView addPropertyView = new AddPropertyValueOptionalView(agentInstanceContext, propertyNames, groupByValues, mergeView.getEventType());
                    copyView.addView(addPropertyView);
                    addPropertyView.addView(mergeView);
                    mergeView.addParentView(addPropertyView);
                    continue;
                }
                copyView.addView(mergeView);
                mergeView.addParentView(copyView);
                continue;
            }
            if (!(subView instanceof CloneableView)) {
                throw new EPException("Unexpected error copying subview");
            }
            CloneableView cloneableView = (CloneableView)((Object)subView);
            View copiedChild = cloneableView.cloneView();
            copyView.addView(copiedChild);
            GroupByViewImpl.copySubViews(criteriaExpressions, propertyNames, groupByValues, subView, copiedChild, agentInstanceContext);
        }
    }

    private Object getGroupKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        if (this.criteriaEvaluators.length == 1) {
            return this.criteriaEvaluators[0].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        Object[] values = new Object[this.criteriaEvaluators.length];
        for (int i = 0; i < this.criteriaEvaluators.length; ++i) {
            values[i] = this.criteriaEvaluators[i].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(values);
    }

    protected static Object addUpgradeToDequeIfPopulated(Object holder, EventBean theEvent) {
        if (holder == null) {
            return theEvent;
        }
        if (holder instanceof Deque) {
            Deque deque = (Deque)holder;
            deque.add(theEvent);
            return deque;
        }
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(4);
        deque.add((EventBean)holder);
        deque.add(theEvent);
        return deque;
    }

    protected static EventBean[] convertToArray(Object eventOrDeque) {
        if (eventOrDeque == null) {
            return null;
        }
        if (eventOrDeque instanceof EventBean) {
            return new EventBean[]{(EventBean)eventOrDeque};
        }
        return EventBeanUtility.toArray((ArrayDeque)eventOrDeque);
    }
}

