/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.agg.service.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.service.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.event.arr.ObjectArrayEventBean;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.window.ExpressionBatchViewFactory;
import com.espertech.esper.view.window.ExpressionViewBase;
import com.espertech.esper.view.window.ExpressionViewOAFieldEnum;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExpressionBatchView
extends ExpressionViewBase {
    private final ExpressionBatchViewFactory dataWindowViewFactory;
    protected final Set<EventBean> window = new LinkedHashSet<EventBean>();
    protected EventBean[] lastBatch;
    protected long newestEventTimestamp;
    protected long oldestEventTimestamp;
    protected EventBean oldestEvent;
    protected EventBean newestEvent;

    public ExpressionBatchView(ExpressionBatchViewFactory dataWindowViewFactory, ViewUpdatedCollection viewUpdatedCollection, ExprEvaluator expiryExpression, AggregationServiceFactoryDesc aggregationServiceFactoryDesc, ObjectArrayEventBean builtinEventProps, Set<String> variableNames, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        super(viewUpdatedCollection, expiryExpression, aggregationServiceFactoryDesc, builtinEventProps, variableNames, agentInstanceContext);
        this.dataWindowViewFactory = dataWindowViewFactory;
    }

    @Override
    public String getViewName() {
        return this.dataWindowViewFactory.getViewName();
    }

    @Override
    public View cloneView() {
        return this.dataWindowViewFactory.makeView(this.agentInstanceContext);
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    @Override
    public void scheduleCallback() {
        boolean fireBatch = this.evaluateExpression(null, this.window.size());
        if (fireBatch) {
            this.expire(this.window.size());
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        boolean fireBatch = false;
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.window.remove(anOldData);
            }
            if (this.aggregationService != null) {
                this.aggregationService.applyLeave(oldData, null, this.agentInstanceContext);
            }
            this.oldestEvent = !this.window.isEmpty() ? this.window.iterator().next() : null;
            fireBatch = this.evaluateExpression(null, this.window.size());
        }
        int numEventsInBatch = -1;
        if (newData != null && newData.length > 0) {
            if (this.window.isEmpty()) {
                this.oldestEventTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            }
            this.newestEventTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            if (this.oldestEvent == null) {
                this.oldestEvent = newData[0];
            }
            for (EventBean newEvent : newData) {
                this.window.add(newEvent);
                if (this.aggregationService != null) {
                    this.aggregationService.applyEnter(new EventBean[]{newEvent}, null, this.agentInstanceContext);
                }
                this.newestEvent = newEvent;
                if (fireBatch || !(fireBatch = this.evaluateExpression(newEvent, this.window.size())) || this.dataWindowViewFactory.isIncludeTriggeringEvent()) continue;
                numEventsInBatch = this.window.size() - 1;
            }
        }
        if (fireBatch) {
            this.expire(numEventsInBatch);
        }
    }

    public void expire(int numEventsInBatch) {
        if (numEventsInBatch == this.window.size() || numEventsInBatch == -1) {
            EventBean[] batchNewData = this.window.toArray(new EventBean[this.window.size()]);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(batchNewData, this.lastBatch);
            }
            if (batchNewData != null || this.lastBatch != null) {
                this.updateChildren(batchNewData, this.lastBatch);
            }
            this.window.clear();
            this.lastBatch = batchNewData;
            if (this.aggregationService != null) {
                this.aggregationService.clearResults(this.agentInstanceContext);
            }
            this.oldestEvent = null;
            this.newestEvent = null;
        } else {
            EventBean[] batchNewData = new EventBean[numEventsInBatch];
            Iterator<EventBean> it = this.window.iterator();
            for (int i = 0; i < batchNewData.length; ++i) {
                batchNewData[i] = it.next();
                it.remove();
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(batchNewData, this.lastBatch);
            }
            if (batchNewData != null || this.lastBatch != null) {
                this.updateChildren(batchNewData, this.lastBatch);
            }
            this.lastBatch = batchNewData;
            if (this.aggregationService != null) {
                this.aggregationService.applyLeave(batchNewData, null, this.agentInstanceContext);
            }
            this.oldestEvent = this.window.iterator().next();
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.window, true, this.dataWindowViewFactory.getViewName(), null);
        viewDataVisitor.visitPrimary(this.lastBatch, this.dataWindowViewFactory.getViewName());
    }

    private boolean evaluateExpression(EventBean arriving, int windowSize) {
        ExpressionViewOAFieldEnum.populate(this.builtinEventProps.getProperties(), windowSize, this.oldestEventTimestamp, this.newestEventTimestamp, this, 0, this.oldestEvent, this.newestEvent);
        this.eventsPerStream[0] = arriving;
        for (AggregationServiceAggExpressionDesc aggregateNode : this.aggregateNodes) {
            aggregateNode.assignFuture(this.aggregationService);
        }
        Boolean result = (Boolean)this.expiryExpression.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        if (result == null) {
            return false;
        }
        return result;
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.window.iterator();
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.dataWindowViewFactory;
    }
}

