/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactorySupport;
import com.espertech.esper.view.ViewFactoryTimePeriodHelper;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.ExternallyTimedBatchView;
import com.espertech.esper.view.window.RelativeAccessByEventNIndexGetterImpl;
import java.util.List;

public class ExternallyTimedBatchViewFactory
implements DataWindowBatchingViewFactory,
DataWindowViewFactory,
DataWindowViewWithPrevious {
    private List<ExprNode> viewParameters;
    private EventType eventType;
    protected ExprNode timestampExpression;
    protected ExprEvaluator timestampExpressionEval;
    protected Long optionalReferencePoint;
    protected ExprTimePeriodEvalDeltaConst timeDeltaComputation;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        this.viewParameters = expressionParameters;
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        String windowName = this.getViewName();
        ExprNode[] validated = ViewFactorySupport.validate(windowName, parentEventType, statementContext, this.viewParameters, true);
        if (this.viewParameters.size() < 2 || this.viewParameters.size() > 3) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (!JavaClassHelper.isNumeric(validated[0].getExprEvaluator().getType())) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timestampExpression = validated[0];
        this.timestampExpressionEval = this.timestampExpression.getExprEvaluator();
        ViewFactorySupport.assertReturnsNonConstant(windowName, validated[0], 0);
        this.timeDeltaComputation = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDelta(this.getViewName(), statementContext, this.viewParameters.get(1), this.getViewParamMessage(), 1);
        if (validated.length == 3) {
            Object constant = ViewFactorySupport.validateAndEvaluate(windowName, statementContext, validated[2]);
            if (!(constant instanceof Number) || JavaClassHelper.isFloatingPointNumber((Number)constant)) {
                throw new ViewParameterException("Externally-timed batch view requires a Long-typed reference point in msec as a third parameter");
            }
            this.optionalReferencePoint = ((Number)constant).longValue();
        }
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RelativeAccessByEventNIndexGetterImpl();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ViewUpdatedCollection viewUpdatedCollection = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprRelativeAccess(agentInstanceViewFactoryContext);
        return new ExternallyTimedBatchView(this, this.timestampExpression, this.timestampExpressionEval, this.timeDeltaComputation, this.optionalReferencePoint, viewUpdatedCollection, agentInstanceViewFactoryContext);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof ExternallyTimedBatchView)) {
            return false;
        }
        ExternallyTimedBatchView myView = (ExternallyTimedBatchView)view;
        if (!this.timeDeltaComputation.equalsTimePeriod(myView.getTimeDeltaComputation()) || !ExprNodeUtility.deepEquals(myView.getTimestampExpression(), this.timestampExpression)) {
            return false;
        }
        return myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Externally-timed-batch";
    }

    public ExprEvaluator getTimestampExpressionEval() {
        return this.timestampExpressionEval;
    }

    public Long getOptionalReferencePoint() {
        return this.optionalReferencePoint;
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a timestamp expression and a numeric or time period parameter for window size and an optional long-typed reference point in msec, and an optional list of control keywords as a string parameter (please see the documentation)";
    }
}

