/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.OneEventCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.FirstTimeViewFactory;
import com.espertech.esper.view.window.TimeBatchViewRStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FirstTimeView
extends ViewSupport
implements CloneableView,
StoppableView,
DataWindowView,
StopCallback {
    private final FirstTimeViewFactory timeFirstViewFactory;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    protected final ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    protected final long scheduleSlot;
    protected EPStatementHandleCallback handle;
    protected LinkedHashSet<EventBean> events = new LinkedHashSet();
    protected boolean isClosed;
    private static final Log log = LogFactory.getLog(TimeBatchViewRStream.class);

    public FirstTimeView(FirstTimeViewFactory timeFirstViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext, ExprTimePeriodEvalDeltaConst timeDeltaComputation) {
        this.agentInstanceContext = agentInstanceContext;
        this.timeFirstViewFactory = timeFirstViewFactory;
        this.timeDeltaComputation = timeDeltaComputation;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.scheduleCallback();
        agentInstanceContext.addTerminationCallback(this);
    }

    @Override
    public View cloneView() {
        return this.timeFirstViewFactory.makeView(this.agentInstanceContext);
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        OneEventCollection oldDataToPost = null;
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                boolean removed = this.events.remove(anOldData);
                if (!removed) continue;
                if (oldDataToPost == null) {
                    oldDataToPost = new OneEventCollection();
                }
                oldDataToPost.add(anOldData);
                this.internalHandleRemoved(anOldData);
            }
        }
        OneEventCollection newDataToPost = null;
        if (!this.isClosed && newData != null) {
            for (EventBean aNewData : newData) {
                this.events.add(aNewData);
                if (newDataToPost == null) {
                    newDataToPost = new OneEventCollection();
                }
                newDataToPost.add(aNewData);
                this.internalHandleAdded(aNewData);
            }
        }
        if (this.hasViews() && (newDataToPost != null || oldDataToPost != null)) {
            EventBean[] nd = newDataToPost != null ? newDataToPost.toArray() : null;
            EventBean[] od = oldDataToPost != null ? oldDataToPost.toArray() : null;
            this.updateChildren(nd, od);
        }
    }

    public void internalHandleAdded(EventBean newEvent) {
    }

    public void internalHandleRemoved(EventBean oldEvent) {
    }

    public void internalHandleClosed() {
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    private void scheduleCallback() {
        long afterMSec = this.timeDeltaComputation.deltaMillisecondsAdd(this.agentInstanceContext.getStatementContext().getSchedulingService().getTime());
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                FirstTimeView.this.isClosed = true;
                FirstTimeView.this.internalHandleClosed();
            }
        };
        this.handle = new EPStatementHandleCallback(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(afterMSec, this.handle, this.scheduleSlot);
    }

    public void stopView() {
        this.stopSchedule();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    @Override
    public void stop() {
        this.stopSchedule();
    }

    public void stopSchedule() {
        if (this.handle != null) {
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    public LinkedHashSet<EventBean> getEvents() {
        return this.events;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.events, true, this.timeFirstViewFactory.getViewName(), null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.timeFirstViewFactory;
    }
}

