/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.window.LengthWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class LengthWindowView
extends ViewSupport
implements DataWindowView,
CloneableView {
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final LengthWindowViewFactory lengthWindowViewFactory;
    private final int size;
    private final ViewUpdatedCollection viewUpdatedCollection;
    protected final ArrayDeque<EventBean> events = new ArrayDeque();

    public LengthWindowView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, LengthWindowViewFactory lengthWindowViewFactory, int size, ViewUpdatedCollection viewUpdatedCollection) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.lengthWindowViewFactory = lengthWindowViewFactory;
        this.size = size;
        this.viewUpdatedCollection = viewUpdatedCollection;
    }

    @Override
    public View cloneView() {
        return this.lengthWindowViewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        if (newData != null) {
            for (EventBean event : newData) {
                this.events.add(event);
            }
        }
        int expiredCount = this.events.size() - this.size;
        EventBean[] expiredArr = null;
        if (expiredCount > 0) {
            expiredArr = new EventBean[expiredCount];
            for (int i = 0; i < expiredCount; ++i) {
                expiredArr[i] = this.events.removeFirst();
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, expiredArr);
        }
        if (this.hasViews()) {
            this.updateChildren(newData, expiredArr);
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.events, true, this.lengthWindowViewFactory.getViewName(), null);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.lengthWindowViewFactory;
    }
}

