/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.window;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ViewUpdatedCollection;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.DataWindowViewWithPrevious;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewFactoryTimePeriodHelper;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.window.RandomAccessByIndexGetter;
import com.espertech.esper.view.window.TimeWindowView;
import java.util.List;

public class TimeWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    protected ExprTimePeriodEvalDeltaConst timeDeltaComputation;
    private EventType eventType;

    @Override
    public void setViewParameters(ViewFactoryContext viewFactoryContext, List<ExprNode> expressionParameters) throws ViewParameterException {
        if (expressionParameters.size() != 1) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timeDeltaComputation = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDelta(this.getViewName(), viewFactoryContext.getStatementContext(), expressionParameters.get(0), this.getViewParamMessage(), 0);
    }

    @Override
    public void attach(EventType parentEventType, StatementContext statementContext, ViewFactory optionalParentFactory, List<ViewFactory> parentViewFactories) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public Object makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ViewUpdatedCollection randomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprRandomAccess(agentInstanceViewFactoryContext);
        return new TimeWindowView(agentInstanceViewFactoryContext, this, this.timeDeltaComputation, randomAccess);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public boolean canReuse(View view) {
        if (!(view instanceof TimeWindowView)) {
            return false;
        }
        TimeWindowView myView = (TimeWindowView)view;
        if (!this.timeDeltaComputation.equalsTimePeriod(myView.getTimeDeltaComputation())) {
            return false;
        }
        return myView.isEmpty();
    }

    @Override
    public String getViewName() {
        return "Time";
    }

    public ExprTimePeriodEvalDeltaConst getTimeDeltaComputation() {
        return this.timeDeltaComputation;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a single numeric or time period parameter";
    }
}

