/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationMetricsReporting;
import com.espertech.esper.client.soda.StreamSelector;
import com.espertech.esper.client.util.EventUnderlyingType;
import java.io.Serializable;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class ConfigurationEngineDefaults
implements Serializable {
    private static final long serialVersionUID = -528835191586154300L;
    private Threading threading = new Threading();
    private ViewResources viewResources = new ViewResources();
    private EventMeta eventMeta = new EventMeta();
    private Logging logging = new Logging();
    private Variables variables = new Variables();
    private StreamSelection streamSelection = new StreamSelection();
    private TimeSource timeSource = new TimeSource();
    private Language language;
    private Expression expression;
    private Execution execution;
    private ExceptionHandling exceptionHandling;
    private ConditionHandling conditionHandling;
    private ConfigurationMetricsReporting metricsReporting = new ConfigurationMetricsReporting();
    private AlternativeContext alternativeContext;
    private Patterns patterns;
    private MatchRecognize matchRecognize;
    private Scripts scripts;

    protected ConfigurationEngineDefaults() {
        this.language = new Language();
        this.expression = new Expression();
        this.execution = new Execution();
        this.exceptionHandling = new ExceptionHandling();
        this.conditionHandling = new ConditionHandling();
        this.alternativeContext = new AlternativeContext();
        this.patterns = new Patterns();
        this.matchRecognize = new MatchRecognize();
        this.scripts = new Scripts();
    }

    public Threading getThreading() {
        return this.threading;
    }

    public ViewResources getViewResources() {
        return this.viewResources;
    }

    public EventMeta getEventMeta() {
        return this.eventMeta;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public StreamSelection getStreamSelection() {
        return this.streamSelection;
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public ConfigurationMetricsReporting getMetricsReporting() {
        return this.metricsReporting;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public AlternativeContext getAlternativeContext() {
        return this.alternativeContext;
    }

    public void setAlternativeContext(AlternativeContext alternativeContext) {
        this.alternativeContext = alternativeContext;
    }

    public ExceptionHandling getExceptionHandling() {
        return this.exceptionHandling;
    }

    public void setExceptionHandling(ExceptionHandling exceptionHandling) {
        this.exceptionHandling = exceptionHandling;
    }

    public ConditionHandling getConditionHandling() {
        return this.conditionHandling;
    }

    public void setConditionHandling(ConditionHandling conditionHandling) {
        this.conditionHandling = conditionHandling;
    }

    public Patterns getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Patterns patterns) {
        this.patterns = patterns;
    }

    public MatchRecognize getMatchRecognize() {
        return this.matchRecognize;
    }

    public void setMatchRecognize(MatchRecognize matchRecognize) {
        this.matchRecognize = matchRecognize;
    }

    public Scripts getScripts() {
        return this.scripts;
    }

    public void setScripts(Scripts scripts) {
        this.scripts = scripts;
    }

    public static interface ClusterConfigurator {
        public void configure(Configuration var1);
    }

    public static class ConditionHandling
    implements Serializable {
        private static final long serialVersionUID = -708367341332718634L;
        private List<String> handlerFactories;

        public List<String> getHandlerFactories() {
            return this.handlerFactories;
        }

        public void addClass(String className) {
            if (this.handlerFactories == null) {
                this.handlerFactories = new ArrayList<String>();
            }
            this.handlerFactories.add(className);
        }

        public void addClasses(List<String> classNames) {
            if (this.handlerFactories == null) {
                this.handlerFactories = new ArrayList<String>();
            }
            this.handlerFactories.addAll(classNames);
        }

        public void addClass(Class clazz) {
            this.addClass(clazz.getName());
        }
    }

    public static class ExceptionHandling
    implements Serializable {
        private static final long serialVersionUID = -708367341332718634L;
        private List<String> handlerFactories;
        private UndeployRethrowPolicy undeployRethrowPolicy = UndeployRethrowPolicy.WARN;

        public List<String> getHandlerFactories() {
            return this.handlerFactories;
        }

        public void addClass(String exceptionHandlerFactoryClassName) {
            if (this.handlerFactories == null) {
                this.handlerFactories = new ArrayList<String>();
            }
            this.handlerFactories.add(exceptionHandlerFactoryClassName);
        }

        public void addClasses(List<String> classNames) {
            if (this.handlerFactories == null) {
                this.handlerFactories = new ArrayList<String>();
            }
            this.handlerFactories.addAll(classNames);
        }

        public void addClass(Class exceptionHandlerFactoryClass) {
            this.addClass(exceptionHandlerFactoryClass.getName());
        }

        public UndeployRethrowPolicy getUndeployRethrowPolicy() {
            return this.undeployRethrowPolicy;
        }

        public void setUndeployRethrowPolicy(UndeployRethrowPolicy undeployRethrowPolicy) {
            this.undeployRethrowPolicy = undeployRethrowPolicy;
        }

        public static enum UndeployRethrowPolicy {
            WARN,
            RETHROW_FIRST;

        }
    }

    public static class AlternativeContext
    implements Serializable {
        private static final long serialVersionUID = 4488861684585251042L;
        private String runtime;
        private String admin;
        private String eventTypeIdGeneratorFactory;
        private String virtualDataWindowViewFactory;
        private String statementMetadataFactory;
        private Object userConfiguration;
        private String memberName;

        public String getRuntime() {
            return this.runtime;
        }

        public void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public String getAdmin() {
            return this.admin;
        }

        public void setAdmin(String admin) {
            this.admin = admin;
        }

        public String getEventTypeIdGeneratorFactory() {
            return this.eventTypeIdGeneratorFactory;
        }

        public void setEventTypeIdGeneratorFactory(String factory) {
            this.eventTypeIdGeneratorFactory = factory;
        }

        public void setVirtualDataWindowViewFactory(String factory) {
            this.virtualDataWindowViewFactory = factory;
        }

        public String getVirtualDataWindowViewFactory() {
            return this.virtualDataWindowViewFactory;
        }

        public String getStatementMetadataFactory() {
            return this.statementMetadataFactory;
        }

        public void setStatementMetadataFactory(String factory) {
            this.statementMetadataFactory = factory;
        }

        public Object getUserConfiguration() {
            return this.userConfiguration;
        }

        public void setUserConfiguration(Object userConfiguration) {
            this.userConfiguration = userConfiguration;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }
    }

    public static enum TimeSourceType {
        MILLI,
        NANO;

    }

    public static enum FilterServiceProfile {
        READMOSTLY,
        READWRITE;

    }

    public static enum ThreadingProfile {
        LARGE,
        NORMAL;

    }

    public static class Execution
    implements Serializable {
        private boolean prioritized = false;
        private boolean fairlock;
        private boolean disableLocking;
        private boolean allowIsolatedService;
        private ThreadingProfile threadingProfile = ThreadingProfile.NORMAL;
        private FilterServiceProfile filterServiceProfile = FilterServiceProfile.READMOSTLY;
        private int filterServiceMaxFilterWidth = 16;
        private int declaredExprValueCacheSize = 1;
        private static final long serialVersionUID = 0L;

        protected Execution() {
        }

        public boolean isPrioritized() {
            return this.prioritized;
        }

        public void setPrioritized(boolean prioritized) {
            this.prioritized = prioritized;
        }

        public boolean isFairlock() {
            return this.fairlock;
        }

        public void setFairlock(boolean fairlock) {
            this.fairlock = fairlock;
        }

        public boolean isDisableLocking() {
            return this.disableLocking;
        }

        public void setDisableLocking(boolean disableLocking) {
            this.disableLocking = disableLocking;
        }

        public ThreadingProfile getThreadingProfile() {
            return this.threadingProfile;
        }

        public void setThreadingProfile(ThreadingProfile threadingProfile) {
            this.threadingProfile = threadingProfile;
        }

        public boolean isAllowIsolatedService() {
            return this.allowIsolatedService;
        }

        public void setAllowIsolatedService(boolean allowIsolatedService) {
            this.allowIsolatedService = allowIsolatedService;
        }

        public FilterServiceProfile getFilterServiceProfile() {
            return this.filterServiceProfile;
        }

        public void setFilterServiceProfile(FilterServiceProfile filterServiceProfile) {
            this.filterServiceProfile = filterServiceProfile;
        }

        public int getFilterServiceMaxFilterWidth() {
            return this.filterServiceMaxFilterWidth;
        }

        public void setFilterServiceMaxFilterWidth(int filterServiceMaxFilterWidth) {
            this.filterServiceMaxFilterWidth = filterServiceMaxFilterWidth;
        }

        public int getDeclaredExprValueCacheSize() {
            return this.declaredExprValueCacheSize;
        }

        public void setDeclaredExprValueCacheSize(int declaredExprValueCacheSize) {
            this.declaredExprValueCacheSize = declaredExprValueCacheSize;
        }
    }

    public static class Expression
    implements Serializable {
        private static final long serialVersionUID = 3192205923560011213L;
        private boolean integerDivision = false;
        private boolean divisionByZeroReturnsNull = false;
        private boolean udfCache = true;
        private boolean selfSubselectPreeval = true;
        private boolean extendedAggregation = true;
        private boolean duckTyping;
        private MathContext mathContext;
        private TimeZone timeZone = TimeZone.getDefault();

        public boolean isIntegerDivision() {
            return this.integerDivision;
        }

        public void setIntegerDivision(boolean integerDivision) {
            this.integerDivision = integerDivision;
        }

        public boolean isDivisionByZeroReturnsNull() {
            return this.divisionByZeroReturnsNull;
        }

        public void setDivisionByZeroReturnsNull(boolean divisionByZeroReturnsNull) {
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        public boolean isUdfCache() {
            return this.udfCache;
        }

        public void setUdfCache(boolean udfCache) {
            this.udfCache = udfCache;
        }

        public boolean isSelfSubselectPreeval() {
            return this.selfSubselectPreeval;
        }

        public void setSelfSubselectPreeval(boolean selfSubselectPreeval) {
            this.selfSubselectPreeval = selfSubselectPreeval;
        }

        public boolean isExtendedAggregation() {
            return this.extendedAggregation;
        }

        public void setExtendedAggregation(boolean extendedAggregation) {
            this.extendedAggregation = extendedAggregation;
        }

        public boolean isDuckTyping() {
            return this.duckTyping;
        }

        public void setDuckTyping(boolean duckTyping) {
            this.duckTyping = duckTyping;
        }

        public MathContext getMathContext() {
            return this.mathContext;
        }

        public void setMathContext(MathContext mathContext) {
            this.mathContext = mathContext;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }
    }

    public static class Language
    implements Serializable {
        private boolean sortUsingCollator = false;
        private static final long serialVersionUID = -6237674558477894392L;

        public boolean isSortUsingCollator() {
            return this.sortUsingCollator;
        }

        public void setSortUsingCollator(boolean sortUsingCollator) {
            this.sortUsingCollator = sortUsingCollator;
        }
    }

    public static class TimeSource
    implements Serializable {
        private TimeSourceType timeSourceType;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private static final long serialVersionUID = 2075039404763313824L;

        public TimeSource() {
            this.timeSourceType = TimeSourceType.MILLI;
        }

        public TimeSourceType getTimeSourceType() {
            return this.timeSourceType;
        }

        public void setTimeSourceType(TimeSourceType timeSourceType) {
            this.timeSourceType = timeSourceType;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }
    }

    public static class StreamSelection
    implements Serializable {
        private StreamSelector defaultStreamSelector = StreamSelector.ISTREAM_ONLY;
        private static final long serialVersionUID = -7943748323859161674L;

        protected StreamSelection() {
        }

        public StreamSelector getDefaultStreamSelector() {
            return this.defaultStreamSelector;
        }

        public void setDefaultStreamSelector(StreamSelector defaultStreamSelector) {
            this.defaultStreamSelector = defaultStreamSelector;
        }
    }

    public static class MatchRecognize
    implements Serializable {
        private static final long serialVersionUID = 4541565245238216789L;
        private Long maxStates;
        private boolean maxStatesPreventStart = true;

        public Long getMaxStates() {
            return this.maxStates;
        }

        public void setMaxStates(Long maxStates) {
            this.maxStates = maxStates;
        }

        public boolean isMaxStatesPreventStart() {
            return this.maxStatesPreventStart;
        }

        public void setMaxStatesPreventStart(boolean maxStatesPreventStart) {
            this.maxStatesPreventStart = maxStatesPreventStart;
        }
    }

    public static class Patterns
    implements Serializable {
        private static final long serialVersionUID = -7596853289989573800L;
        private Long maxSubexpressions;
        private boolean maxSubexpressionPreventStart = true;

        public Long getMaxSubexpressions() {
            return this.maxSubexpressions;
        }

        public void setMaxSubexpressions(Long maxSubexpressions) {
            this.maxSubexpressions = maxSubexpressions;
        }

        public boolean isMaxSubexpressionPreventStart() {
            return this.maxSubexpressionPreventStart;
        }

        public void setMaxSubexpressionPreventStart(boolean maxSubexpressionPreventStart) {
            this.maxSubexpressionPreventStart = maxSubexpressionPreventStart;
        }
    }

    public static class Scripts
    implements Serializable {
        private static final long serialVersionUID = -3111856398932434323L;
        private String defaultDialect = "js";

        public String getDefaultDialect() {
            return this.defaultDialect;
        }

        public void setDefaultDialect(String defaultDialect) {
            this.defaultDialect = defaultDialect;
        }
    }

    public static class Variables
    implements Serializable {
        private long msecVersionRelease = 15000L;
        private static final long serialVersionUID = 8276015152830052323L;

        protected Variables() {
        }

        public long getMsecVersionRelease() {
            return this.msecVersionRelease;
        }

        public void setMsecVersionRelease(long msecVersionRelease) {
            this.msecVersionRelease = msecVersionRelease;
        }
    }

    public static class Logging
    implements Serializable {
        private boolean enableExecutionDebug = false;
        private boolean enableTimerDebug = true;
        private boolean enableQueryPlan = false;
        private boolean enableJDBC = false;
        private String auditPattern;
        private static final long serialVersionUID = -8129836306582810327L;

        protected Logging() {
        }

        public boolean isEnableExecutionDebug() {
            return this.enableExecutionDebug;
        }

        public void setEnableExecutionDebug(boolean enableExecutionDebug) {
            this.enableExecutionDebug = enableExecutionDebug;
        }

        public boolean isEnableTimerDebug() {
            return this.enableTimerDebug;
        }

        public void setEnableTimerDebug(boolean enableTimerDebug) {
            this.enableTimerDebug = enableTimerDebug;
        }

        public boolean isEnableQueryPlan() {
            return this.enableQueryPlan;
        }

        public void setEnableQueryPlan(boolean enableQueryPlan) {
            this.enableQueryPlan = enableQueryPlan;
        }

        public boolean isEnableJDBC() {
            return this.enableJDBC;
        }

        public void setEnableJDBC(boolean enableJDBC) {
            this.enableJDBC = enableJDBC;
        }

        public String getAuditPattern() {
            return this.auditPattern;
        }

        public void setAuditPattern(String auditPattern) {
            this.auditPattern = auditPattern;
        }
    }

    public static class EventMeta
    implements Serializable {
        private static final long serialVersionUID = -6091772368103140370L;
        private Configuration.PropertyResolutionStyle classPropertyResolutionStyle = Configuration.PropertyResolutionStyle.getDefault();
        private ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle = ConfigurationEventTypeLegacy.AccessorStyle.JAVABEAN;
        private EventUnderlyingType defaultEventRepresentation = EventUnderlyingType.getDefault();
        private int anonymousCacheSize = 5;
        private AvroSettings avroSettings = new AvroSettings();

        public ConfigurationEventTypeLegacy.AccessorStyle getDefaultAccessorStyle() {
            return this.defaultAccessorStyle;
        }

        public void setDefaultAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle defaultAccessorStyle) {
            this.defaultAccessorStyle = defaultAccessorStyle;
        }

        public Configuration.PropertyResolutionStyle getClassPropertyResolutionStyle() {
            return this.classPropertyResolutionStyle;
        }

        public void setClassPropertyResolutionStyle(Configuration.PropertyResolutionStyle classPropertyResolutionStyle) {
            this.classPropertyResolutionStyle = classPropertyResolutionStyle;
        }

        public void setDefaultEventRepresentation(EventUnderlyingType defaultEventRepresentation) {
            this.defaultEventRepresentation = defaultEventRepresentation;
        }

        public EventUnderlyingType getDefaultEventRepresentation() {
            return this.defaultEventRepresentation;
        }

        public int getAnonymousCacheSize() {
            return this.anonymousCacheSize;
        }

        public void setAnonymousCacheSize(int anonymousCacheSize) {
            this.anonymousCacheSize = anonymousCacheSize;
        }

        public AvroSettings getAvroSettings() {
            return this.avroSettings;
        }

        public void setAvroSettings(AvroSettings avroSettings) {
            this.avroSettings = avroSettings;
        }

        public static class AvroSettings
        implements Serializable {
            private static final long serialVersionUID = 2977645210525767203L;
            private boolean enableAvro = true;
            private boolean enableNativeString = true;
            private boolean enableSchemaDefaultNonNull = true;
            private String typeRepresentationMapperClass;
            private String objectValueTypeWidenerFactoryClass;

            public boolean isEnableAvro() {
                return this.enableAvro;
            }

            public void setEnableAvro(boolean enableAvro) {
                this.enableAvro = enableAvro;
            }

            public boolean isEnableNativeString() {
                return this.enableNativeString;
            }

            public void setEnableNativeString(boolean enableNativeString) {
                this.enableNativeString = enableNativeString;
            }

            public boolean isEnableSchemaDefaultNonNull() {
                return this.enableSchemaDefaultNonNull;
            }

            public void setEnableSchemaDefaultNonNull(boolean enableSchemaDefaultNonNull) {
                this.enableSchemaDefaultNonNull = enableSchemaDefaultNonNull;
            }

            public void setTypeRepresentationMapperClass(String typeRepresentationMapperClass) {
                this.typeRepresentationMapperClass = typeRepresentationMapperClass;
            }

            public String getTypeRepresentationMapperClass() {
                return this.typeRepresentationMapperClass;
            }

            public String getObjectValueTypeWidenerFactoryClass() {
                return this.objectValueTypeWidenerFactoryClass;
            }

            public void setObjectValueTypeWidenerFactoryClass(String objectValueTypeWidenerFactoryClass) {
                this.objectValueTypeWidenerFactoryClass = objectValueTypeWidenerFactoryClass;
            }
        }
    }

    public static class ViewResources
    implements Serializable {
        private boolean shareViews = true;
        private boolean allowMultipleExpiryPolicies = false;
        private boolean iterableUnbound = false;
        private static final long serialVersionUID = 2527853225433208362L;

        protected ViewResources() {
        }

        public boolean isShareViews() {
            return this.shareViews;
        }

        public void setShareViews(boolean shareViews) {
            this.shareViews = shareViews;
        }

        public boolean isAllowMultipleExpiryPolicies() {
            return this.allowMultipleExpiryPolicies;
        }

        public void setAllowMultipleExpiryPolicies(boolean allowMultipleExpiryPolicies) {
            this.allowMultipleExpiryPolicies = allowMultipleExpiryPolicies;
        }

        public boolean isIterableUnbound() {
            return this.iterableUnbound;
        }

        public void setIterableUnbound(boolean iterableUnbound) {
            this.iterableUnbound = iterableUnbound;
        }
    }

    public static class Threading
    implements Serializable {
        private static final long serialVersionUID = 6504606101119059962L;
        private boolean isListenerDispatchPreserveOrder = true;
        private long listenerDispatchTimeout = 1000L;
        private Locking listenerDispatchLocking = Locking.SPIN;
        private boolean isInsertIntoDispatchPreserveOrder = true;
        private long insertIntoDispatchTimeout = 100L;
        private Locking insertIntoDispatchLocking = Locking.SPIN;
        private boolean isNamedWindowConsumerDispatchPreserveOrder = true;
        private long namedWindowConsumerDispatchTimeout = Long.MAX_VALUE;
        private Locking namedWindowConsumerDispatchLocking = Locking.SPIN;
        private long internalTimerMsecResolution = 100L;
        private boolean internalTimerEnabled = true;
        private boolean isThreadPoolTimerExec = false;
        private boolean isThreadPoolInbound = false;
        private boolean isThreadPoolRouteExec = false;
        private boolean isThreadPoolOutbound = false;
        private int threadPoolTimerExecNumThreads = 2;
        private int threadPoolInboundNumThreads = 2;
        private int threadPoolRouteExecNumThreads = 2;
        private int threadPoolOutboundNumThreads = 2;
        private Integer threadPoolTimerExecCapacity;
        private Integer threadPoolInboundCapacity;
        private Integer threadPoolRouteExecCapacity;
        private Integer threadPoolOutboundCapacity;
        private boolean engineFairlock;

        public void setListenerDispatchPreserveOrder(boolean value) {
            this.isListenerDispatchPreserveOrder = value;
        }

        public void setListenerDispatchTimeout(long value) {
            this.listenerDispatchTimeout = value;
        }

        public void setInsertIntoDispatchPreserveOrder(boolean value) {
            this.isInsertIntoDispatchPreserveOrder = value;
        }

        public boolean isListenerDispatchPreserveOrder() {
            return this.isListenerDispatchPreserveOrder;
        }

        public long getListenerDispatchTimeout() {
            return this.listenerDispatchTimeout;
        }

        public boolean isInsertIntoDispatchPreserveOrder() {
            return this.isInsertIntoDispatchPreserveOrder;
        }

        public void setInternalTimerEnabled(boolean internalTimerEnabled) {
            this.internalTimerEnabled = internalTimerEnabled;
        }

        public boolean isInternalTimerEnabled() {
            return this.internalTimerEnabled;
        }

        public long getInternalTimerMsecResolution() {
            return this.internalTimerMsecResolution;
        }

        public void setInternalTimerMsecResolution(long internalTimerMsecResolution) {
            this.internalTimerMsecResolution = internalTimerMsecResolution;
        }

        public long getInsertIntoDispatchTimeout() {
            return this.insertIntoDispatchTimeout;
        }

        public void setListenerDispatchLocking(Locking listenerDispatchLocking) {
            this.listenerDispatchLocking = listenerDispatchLocking;
        }

        public void setInsertIntoDispatchTimeout(long msecTimeout) {
            this.insertIntoDispatchTimeout = msecTimeout;
        }

        public void setInsertIntoDispatchLocking(Locking insertIntoDispatchLocking) {
            this.insertIntoDispatchLocking = insertIntoDispatchLocking;
        }

        public Locking getListenerDispatchLocking() {
            return this.listenerDispatchLocking;
        }

        public Locking getInsertIntoDispatchLocking() {
            return this.insertIntoDispatchLocking;
        }

        public boolean isThreadPoolInbound() {
            return this.isThreadPoolInbound;
        }

        public void setThreadPoolInbound(boolean threadPoolInbound) {
            this.isThreadPoolInbound = threadPoolInbound;
        }

        public boolean isThreadPoolTimerExec() {
            return this.isThreadPoolTimerExec;
        }

        public void setThreadPoolTimerExec(boolean threadPoolTimerExec) {
            this.isThreadPoolTimerExec = threadPoolTimerExec;
        }

        public boolean isThreadPoolRouteExec() {
            return this.isThreadPoolRouteExec;
        }

        public void setThreadPoolRouteExec(boolean threadPoolRouteExec) {
            this.isThreadPoolRouteExec = threadPoolRouteExec;
        }

        public boolean isThreadPoolOutbound() {
            return this.isThreadPoolOutbound;
        }

        public void setThreadPoolOutbound(boolean threadPoolOutbound) {
            this.isThreadPoolOutbound = threadPoolOutbound;
        }

        public int getThreadPoolInboundNumThreads() {
            return this.threadPoolInboundNumThreads;
        }

        public void setThreadPoolInboundNumThreads(int num) {
            this.threadPoolInboundNumThreads = num;
        }

        public int getThreadPoolOutboundNumThreads() {
            return this.threadPoolOutboundNumThreads;
        }

        public void setThreadPoolOutboundNumThreads(int num) {
            this.threadPoolOutboundNumThreads = num;
        }

        public int getThreadPoolRouteExecNumThreads() {
            return this.threadPoolRouteExecNumThreads;
        }

        public void setThreadPoolRouteExecNumThreads(int num) {
            this.threadPoolRouteExecNumThreads = num;
        }

        public int getThreadPoolTimerExecNumThreads() {
            return this.threadPoolTimerExecNumThreads;
        }

        public void setThreadPoolTimerExecNumThreads(int num) {
            this.threadPoolTimerExecNumThreads = num;
        }

        public Integer getThreadPoolTimerExecCapacity() {
            return this.threadPoolTimerExecCapacity;
        }

        public void setThreadPoolTimerExecCapacity(Integer capacity) {
            this.threadPoolTimerExecCapacity = capacity;
        }

        public Integer getThreadPoolInboundCapacity() {
            return this.threadPoolInboundCapacity;
        }

        public void setThreadPoolInboundCapacity(Integer capacity) {
            this.threadPoolInboundCapacity = capacity;
        }

        public Integer getThreadPoolRouteExecCapacity() {
            return this.threadPoolRouteExecCapacity;
        }

        public void setThreadPoolRouteExecCapacity(Integer capacity) {
            this.threadPoolRouteExecCapacity = capacity;
        }

        public Integer getThreadPoolOutboundCapacity() {
            return this.threadPoolOutboundCapacity;
        }

        public void setThreadPoolOutboundCapacity(Integer capacity) {
            this.threadPoolOutboundCapacity = capacity;
        }

        public boolean isEngineFairlock() {
            return this.engineFairlock;
        }

        public void setEngineFairlock(boolean engineFairlock) {
            this.engineFairlock = engineFairlock;
        }

        public boolean isNamedWindowConsumerDispatchPreserveOrder() {
            return this.isNamedWindowConsumerDispatchPreserveOrder;
        }

        public void setNamedWindowConsumerDispatchPreserveOrder(boolean isNamedWindowConsumerDispatchPreserveOrder) {
            this.isNamedWindowConsumerDispatchPreserveOrder = isNamedWindowConsumerDispatchPreserveOrder;
        }

        public long getNamedWindowConsumerDispatchTimeout() {
            return this.namedWindowConsumerDispatchTimeout;
        }

        public void setNamedWindowConsumerDispatchTimeout(long namedWindowConsumerDispatchTimeout) {
            this.namedWindowConsumerDispatchTimeout = namedWindowConsumerDispatchTimeout;
        }

        public Locking getNamedWindowConsumerDispatchLocking() {
            return this.namedWindowConsumerDispatchLocking;
        }

        public void setNamedWindowConsumerDispatchLocking(Locking namedWindowConsumerDispatchLocking) {
            this.namedWindowConsumerDispatchLocking = namedWindowConsumerDispatchLocking;
        }

        public static enum Locking {
            SPIN,
            SUSPEND;

        }
    }
}

