/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ContextDescriptor;
import com.espertech.esper.client.soda.ContextDescriptorCondition;
import com.espertech.esper.client.soda.ContextDescriptorConditionNever;
import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.StringWriter;
import java.util.List;

public class ContextDescriptorInitiatedTerminated
implements ContextDescriptor {
    private static final long serialVersionUID = 8185386941253467559L;
    private ContextDescriptorCondition startCondition;
    private ContextDescriptorCondition endCondition;
    private boolean overlapping;
    private List<Expression> optionalDistinctExpressions;

    public ContextDescriptorInitiatedTerminated() {
    }

    public ContextDescriptorInitiatedTerminated(ContextDescriptorCondition startCondition, ContextDescriptorCondition endCondition, boolean overlapping, List<Expression> optionalDistinctExpressions) {
        this.startCondition = startCondition;
        this.endCondition = endCondition;
        this.overlapping = overlapping;
        this.optionalDistinctExpressions = optionalDistinctExpressions;
    }

    public ContextDescriptorInitiatedTerminated(ContextDescriptorCondition startCondition, ContextDescriptorCondition endCondition, boolean overlapping) {
        this.startCondition = startCondition;
        this.endCondition = endCondition;
        this.overlapping = overlapping;
    }

    public ContextDescriptorCondition getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(ContextDescriptorCondition startCondition) {
        this.startCondition = startCondition;
    }

    public ContextDescriptorCondition getEndCondition() {
        return this.endCondition;
    }

    public void setEndCondition(ContextDescriptorCondition endCondition) {
        this.endCondition = endCondition;
    }

    public boolean isOverlapping() {
        return this.overlapping;
    }

    public void setOverlapping(boolean overlapping) {
        this.overlapping = overlapping;
    }

    public List<Expression> getOptionalDistinctExpressions() {
        return this.optionalDistinctExpressions;
    }

    public void setOptionalDistinctExpressions(List<Expression> optionalDistinctExpressions) {
        this.optionalDistinctExpressions = optionalDistinctExpressions;
    }

    @Override
    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        writer.append(this.overlapping ? "initiated by " : "start ");
        if (this.optionalDistinctExpressions != null && this.optionalDistinctExpressions.size() > 0) {
            writer.append("distinct(");
            String delimiter = "";
            for (Expression expression : this.optionalDistinctExpressions) {
                writer.write(delimiter);
                expression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
                delimiter = ", ";
            }
            writer.append(") ");
        }
        this.startCondition.toEPL(writer, formatter);
        if (!(this.endCondition instanceof ContextDescriptorConditionNever)) {
            writer.append(" ");
            writer.append(this.overlapping ? "terminated " : "end ");
            this.endCondition.toEPL(writer, formatter);
        }
    }
}

